<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system   = "GE:エンジンサンプル"
	pgid     = "GE0016"
	title    = "ユーザー永続化情報"
	date     = "2007/12/12"
	author   = "K.HASEGAWA"
	text     = "ZZZZ"
	version  = "001"
/>

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<og:columnCheck
	command   = "{@command}"
	columns   = "SYSTEM_ID,USERID,ROLES,PARAM_ID,PARAM"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command = "{@command}" />

<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
		select '1' as WRITABLE,A.USERID,A.PARAM_ID,A.PARAM,A.KBSET,
				B.LANG,B.NAME_JA,A.ROLES,A.SYSTEM_ID,A.FGJ,A.UNIQ
		from GE20 A
			left outer join  GEA10 B
			on  A.SYSTEM_ID = B.SYSTEM_ID
			and A.USERID = B.USERID 
			and A.ROLES = B.ROLES
			and B.FGJ='1'
	<og:where>
		<og:and value = "A.FGJ			=	'{@FGJ}'"		/>
		<og:and value = "A.SYSTEM_ID	=	'{@SYSTEM_ID}'"	/>
		<og:and value = "A.USERID		like '{@USERID}'"	/>
		<og:and value = "A.ROLES		like '{@ROLES}'"	/>
		<og:and value = "A.PARAM_ID	like '{@PARAM_ID}'"/>
		<og:and value = "A.PARAM		like '{@PARAM}'"	/>
		<og:and value = "A.KBSET		=	'{@KBSET}'"		/>
	</og:where>
	<og:appear startKey = "order by" value = "{@ORDER_BY}"
				defaultVal = "SYSTEM_ID,USERID,FGDEFAULT,ROLES,PARAM_ID" />
</og:query>

<og:columnEditor columns="SYSTEM_ID,USERID,ROLES,PARAM_ID,PARAM" must="true" />

<og:viewMarker isRenderer="false"  command="NEW">
	<og:columnMarker column="ROLES" onMark="true">
	[ROLES]<img style="cursor:pointer;" src="{@SYS.JSP}/image/multiChoose.gif"
				onClick="ogOpen('{@SYS.JSP}/custom/multiChoose.jsp?name=ROLES&amp;SYSTEM_ID={@SYSTEM_ID}&amp;editor=DBMENU&amp;param=select ROLES,NMROLE from GEA05 where SYSTEM_ID=\\'{@SYSTEM_ID}\\' and KBROLE=\\'1\\' and FGJ=\\'1\\'', event,'ROLES__[I]','width=500,height=200,resizable=no' );" />
	</og:columnMarker>
</og:viewMarker>

<form method="POST" action="forward.jsp" target="RESULT">
<og:writeCheck>
	<og:input name="repeatCount" value="1" lbl="" td="false" size="2"/>
	<og:submit  action="COPY"    noWritable="LANG,NAME_JA" />
	<og:submit  action="MODIFY"  noWritable="SYSTEM_ID,USERID,ROLES,LANG,NAME_JA,PARAM_ID"  />
	<og:submit  action="DELETE"  columnWritable="null" keys="logicalDelete" vals="true" />
	<og:submit  action="DELETE"  columnWritable="null" lbl="DELETE_PH" roles="DEL"/>

	<og:equals val1="{@ACTION}" val2="{@ACTION}" notEquals="true">
		<fieldset style="display:inline;">
			<legend><strong><og:message lbl="INSERT_GE20" /></strong></legend>
			<og:column  name="SYSTEM_ID" useRequestValue="false" td="no" />
			<og:column  name="USERID" useRequestValue="false" td="no" />
			<og:submit  action="COPY" noWritable="LANG,NAME_JA" lbl="SYS{@LBL.COPY}" keys="sysins" vals="true"  />
		</fieldset>
	</og:equals>

<!--
	<og:submit  value="update"   lbl="COPY"      command="COPY"   accesskey="C"
		keys="noWritable" vals='"LANG,NAME_JA"' />
	<og:submit  value="update"   lbl="MODIFY"    command="MODIFY" accesskey="M"
		keys="noWritable" vals='"SYSTEM_ID,USERID,ROLES,LANG,NAME_JA,PARAM_ID"' />
	<og:submit  value="update"   lbl="DELETE"    command="DELETE" accesskey="Z"
		keys="columnWritable,logicalDelete" vals="null,true" />
	<og:submit  value="update"   lbl="DELETE_PH" command="DELETE" roles="DEL"
		keys="columnWritable" vals="null" />
	<og:equals val1="{@ACTION}" val2="{@ACTION}" notEquals="true">
		<fieldset style="display:inline;">
			<legend><strong><og:message lbl="INSERT_GE20" /></strong></legend>
			<og:column  name="SYSTEM_ID" useRequestValue="false" td="no" />
			<og:column  name="USERID" useRequestValue="false" td="no" />
			<og:submit  value="update" lbl="COPY" command="COPY"
				keys="noWritable,sysins" vals='"LANG,NAME_JA",true' />
		</fieldset>
	</og:equals>
-->
	<br />
</og:writeCheck>

<og:view
	viewFormType = "HTMLTable"
	command		= "{@command}"
	noDisplay	= "UNIQ"
	checked		= "{@checked}"
	startNo		= "{@startNo}"
	pageSize	= "{@pageSize}" />
</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
