/*
 * 左メニューの絞り込み用スクリプトです。
 * メニュー画面でロードした上でidがsearchmenuというinputを作成してください。
 * 実行にはjQuery(1.4-)が必要です。
 *
 * @og.rev 5.10.11.3 (2019/05/24) Tsuda 新規作成
*/

$(function(){
	var searchInput = $('#searchmenu'); 	//ﾃｷｽﾄﾎﾞｯｸｽ
	var searchExpand1 = $('.expand1');	//中分類（class="expand1")
	var searchExpand2 = $('.expand2');	//小分類（class="expand2")

// 7.0.4.0 (2019/05/31) initialDisplay は、初期表示でmenuが展開している場合の状態保存用（今回は削除しておきます）
//	//画面表示時の小分類の表示形式(displayの値)を独自属性「initialDisplay」に追加する
//	searchExpand1.each(function(){
//		 $(this).attr('initialDisplay',$(this).css('display'));
//	});

//	//画面表示時の小分類の表示形式(displayの値)を独自属性「initialDisplay」に追加する
//	searchExpand2.each(function(){
//		 $(this).attr('initialDisplay',$(this).css('display'));
//	});

	function searhWord(searchInput,searchExpand1,searchExpand2){
		var EXCLUDED = 'is-excluded';		//絞り込み対象外の要素に付与するclass
		var DELEXPAND1 = 'delexp1';		//expand1ｲﾍﾞﾝﾄ削除用ｸﾗｽ

		var keyword = toZenkakuKana(searchInput.val().toLowerCase());	//ﾃｷｽﾄﾎﾞｯｸｽの文字列を取得し、大文字小文字変換・半角ｶﾅ全角ｶﾅ変換を行う
		var keywordArr = keyword.replace(/　/g, ' ').split(' ');	// ｽﾍﾟｰｽで入力文字列を分割
		if(searchInput.val() === ""){
//			//小分類の表示形式を初期状態(initialDisplayの値）に戻す
//			searchExpand2.each(function(){
//				$(this).css({"display": $(this).attr('initialDisplay')});
//			});

			// 非表示判定用のｸﾗｽ「is-excluded」がついている場合、削除
			$('.'+EXCLUDED).removeClass(EXCLUDED);
			// 中分類のｸﾗｽを「delexp1」から「expand1」に戻して表示する
			$('.' + DELEXPAND1).addClass('expand1');
			$('.' + DELEXPAND1).removeClass(DELEXPAND1).show();

//			//中分類の表示形式を初期状態(initialDisplayの値）に戻す
//			searchExpand1.each(function(){
//				$(this).css({"display": $(this).attr('initialDisplay')});
//			});
		}else{
			// すべての小分類を表示させる(一旦表示し、一致しないものを後で非表示にする）
			$('.expand2').show();
			// 中分類のｸﾗｽを「expand1」から「delexp1」に変更(イベントが動かないようにする）
			$('.expand1').addClass(DELEXPAND1);
			$('.expand1').removeClass('expand1');
			// 非表示判定用のｸﾗｽ「is-excluded」を削除し、表示させる
			$('.' + EXCLUDED).removeClass(EXCLUDED).show();

			// 小分類の数だけﾙｰﾌﾟ
			// ﾃｷｽﾄﾎﾞｯｸｽ内の分割された文字列と小分類のﾃｷｽﾄと比較し、一致しない小分類のｸﾗｽに「is-excluded」を付与
			searchExpand2.each(function(){
				for(i=0;i<keywordArr.length;i++){
					var thisText = toZenkakuKana($(this).text().toLowerCase());
					// 小分類の先頭に全角ｽﾍﾟｰｽが入るため、0以下を条件としている
					if(thisText.indexOf(keywordArr[i]) <= 0){
						$(this).addClass(EXCLUDED);
					}
				}
			});

			//中分類の表示非表示処理
			var countExpand2 = 0;	//小分類のｶｳﾝﾄ用
			//中分類の数だけﾙｰﾌﾟ
			searchExpand1.each(function(){
				var displayFlg = false; //中分類の表示・非表示制御用ﾌﾗｸﾞ（falseのとき中分類のｸﾗｽに「is-excluded」を付与)
				var IDExpand1 = $(this).attr('id');
				// 中分類[緑](IDがついていない)以外の中分類に対して処理
//				if(IDExpand1 !== ""){
				if(typeof IDExpand1 != "undefined"){
					//ｶｳﾝﾀが小分類の数になるまでﾙｰﾌﾟ
					while(countExpand2 < searchExpand2.length){
						var IDExpand2 = searchExpand2.eq(countExpand2).attr('id');
						var classExpand2 = searchExpand2.eq(countExpand2).attr('class');

						// 中分類自身にﾘﾝｸがある場合、表示ﾌﾗｸﾞを立てる
						if($(this).children('a').length === 1){
							displayFlg = true;
						}

						// 小分類のIDに中分類のIDが含まれない場合ﾙｰﾌﾟを抜ける
						// ※中分類と小分類はIDで紐ついている(中分類：menu13→小分類：menu13_0,menu13_1,…)
						if(IDExpand2.indexOf(IDExpand1) < 0){
							break;
						}

						// 小分類のｸﾗｽに「is-excluded」が付与されていない場合、表示ﾌﾗｸﾞを立てる
						if(classExpand2.indexOf(EXCLUDED) < 0){
							displayFlg = true;
						}
						countExpand2++;
					}

					// 表示ﾌﾗｸﾞが立っていない中分類のｸﾗｽに'is-excluded'を付与
					if(displayFlg === false){
						$(this).addClass(EXCLUDED);
					}
				}
			});

			// 中分類[緑]の表示・非表示処理
			var delExpand1Elem = $('.'+DELEXPAND1); // 中分類(検索時)の要素取得
			delExpand1Elem.each(function(){
				var IDExpand1 = $(this).attr('id');
				// 中分類[緑]（IDがついていない）の場合のみ実行
	//			if(IDExpand1 === ""){
				if(typeof IDExpand1 == "undefined"){
					// classが「delexp1」のみの子孫要素を取得
					// 存在しなければ、中分類のｸﾗｽに「is-excluded」を付与
					var delExpand1Elem2 = $(this).find('.'+ DELEXPAND1).not('.is-excluded');
					if( delExpand1Elem2.length === 0){
						$(this).addClass(EXCLUDED);
					}
				}
			});

			// ｸﾗｽに「is-excluded」がついているdivﾀｸﾞのdisplayをnoneにする
			$('.' + EXCLUDED).hide(); 
		}
	}

	// ﾃｷｽﾄﾎﾞｯｸｽに関する操作が行われたとき絞り込み処理を実行
	searchInput.bind('input propertychange',function() {
		searhWord(searchInput,searchExpand1,searchExpand2);
	});

});