/****************************************************************************/
/* chartOptions.js															*/
/*																			*/
/* Chart.js に、ﾗﾍﾞﾙや値の表示を行う、plugins や、onClick で使用できる		*/
/* 関数を定義します。														*/
/*																			*/
/* @og.rev 6.9.9.2 (2018/09/18) 新規作成									*/
/****************************************************************************/

/****************************************************************************/
/* chartLabelPlugin															*/
/*																			*/
/* jsChart チャートタグのグラフに値を表示する plugins です。				*/
/*																			*/
/* <og:jsChart																*/
/*	  chartType = "bar" 													*/
/*	  plugins	= "chartLabelPlugin"										*/
/*	  ････																	*/
/*																			*/
/* すべてのチャートに適用させる場合は、register 登録します。				*/
/*	※ 便宜的に、chartTypeが、polarArea/pie/doughnut の場合は、ﾗﾍﾞﾙと値を	*/
/*		それ以外は、値のみ表示するように処理を入れています。				*/
/*		また、文字の色は、黒のみで、円グラフの背景色が濃い場合は、			*/
/*		見えにくくなるため、円グラフの背景色で調整してください。			*/
/*																			*/
/*	<script type="text/javascript"> 										*/
/*		Chart.plugins.register( chartLabelPlugin );							*/
/*	</script>																*/
/*																			*/
/* Define a plugin to provide data labels									*/
/* https://beiznotes.org/data-label-on-chart-js/							*/
/*																			*/
/* @og.rev 6.9.9.2 (2018/09/18) 新規作成									*/
/****************************************************************************/
var chartLabelPlugin = { afterDatasetsDraw: function(chart) {
	var ctx = chart.ctx;
	// Draw the text in black, with the specified font
	ctx.fillStyle = 'rgb(0, 0, 0)';

	var fontSize   = 12;
	var fontStyle  = 'normal';
	var fontFamily = 'Helvetica Neue';
	ctx.font = Chart.helpers.fontString(fontSize, fontStyle, fontFamily);

	// Make sure alignment settings are correct
	ctx.textAlign    = 'center';
	ctx.textBaseline = 'bottom';

	var padding = 2;
	var lblOffset =  padding + fontSize;					// 'bottom'
	var valOffset =  padding;								// 'bottom'

	chart.data.datasets.forEach(function(dataset, no) {		// no:グラフ番号
		var meta = chart.getDatasetMeta(no);
		if (!meta.hidden) {
			meta.data.forEach(function(element, idx) {		// index:data番号
				if( dataset.data[idx] ) {					// null(undefine)チェック
					var pos = element.tooltipPosition();

					if( "polarArea/pie/doughnut".indexOf( chart.config.type ) >= 0 ) {
						var lbl = chart.data.labels[idx];					// ﾗﾍﾞﾙの表示
						ctx.fillText( lbl , pos.x, pos.y - lblOffset );		// ﾗﾍﾞﾙ
					}

					var val = dataset.data[idx].toString();				// 値の表示
					ctx.fillText( val , pos.x, pos.y - valOffset );		// 値
				}
			});
		}
	});
}};

/****************************************************************************/
/* clickLink																*/
/*																			*/
/* グラフクリック時に呼び出す、画面を遷移するための処理です。				*/
/*																			*/
/* <og:jsChart																*/
/*	  chartType = "bar" 													*/
/*	  onClick	= "clickLink( event, obj , 									*/
/*					'index.jsp?chartTitle={LBL}&amp;markValues={CLM}',		*/
/*					parent );"												*/
/*	  labelColumn = "LABELS"												*/
/*	  ････																	*/
/* >																		*/
/*	  <og:jsChartData														*/
/*		  chartColumn = "SAL"												*/
/*		  ････																*/
/*	  />																	*/
/*																			*/
/* 第３引数に、location.href で遷移させる アドレスを記入します。			*/
/* その際、{LBL} に、jsChart の labelColumn で指定した値が、{CLM} に、		*/
/* jsChartData の chartColumn で指定した値が、セットされます。				*/
/* jsChartData が、複数ある場合は、クリックしたグラフの値が指定されます。	*/
/*																			*/
/* ちなみに、現時点では、ajax で動的に変更したDATAは、反映しません。		*/
/*																			*/
/* @og.rev 6.9.9.2 (2018/09/18) 新規作成									*/
/* @og.rev 6.9.9.4 (2018/10/01) データの持ち方変更							*/
/* @og.rev 7.0.1.2 (2018/11/04) CLM,VAL,IDXとを変数にencodeURI 対応			*/
/****************************************************************************/
// 棒グラフクリック時に呼び出されて、画面を遷移するための処理です。
// リンクは、{LBL} と、{CLM} が、ラベルとグラフのデータに置き換えられます。
var clickLink = function( event,obj,link,frame ){
	if( !frame ) { frame = this; }			// frame で、_top , parent 等指定可能。
	var trg = obj[0]._chart.getElementAtEvent(event);

	var data = trg[0]._chart.data;
	if( trg[0] ) {
		var idx = trg[0]._index;					// IDX
		var sel = trg[0]._datasetIndex;

		var clm = data.labels[idx];					// CLM=0:ﾗﾍﾞﾙ
		var val = data.datasets[sel].data[idx];		// VAL=ﾃﾞｰﾀ
		var html = link.replace(/\{CLM\}/g,clm ).replace(/\{VAL\}/g,val ).replace(/\{IDX\}/g,idx );

		// 画面遷移します。
		frame.location.href = encodeURI( html );
	}
};
