/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.plugin.column;

import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.db.AbstractEditor;
import org.opengion.hayabusa.db.CellEditor;
import org.opengion.hayabusa.db.DBColumn;
import org.opengion.fukurou.util.XHTMLTag;
import org.opengion.fukurou.util.TagBuffer;

import static org.opengion.fukurou.util.StringUtil.isNull;				// 6.1.1.0 (2015/01/17)

/**
 * YMD エディターは、カラムのデータを日付(年/月/日)編集する場合に使用するクラスです。
 * YMD2はカレンダーのポップアップボタンが付属するタイプです。
 *
 * このエディタはeventColumnに対応していません。
 *
 *  カラムの表示に必要な属性は, DBColumn オブジェクト より取り出します。
 * このクラスは、DBColumn オブジェクト毎に１つ作成されます。
 *
 * @og.rev 3.5.6.2 (2004/07/05) 新規作成
 * @og.rev 5.4.3.6 (2012/01/19) コメント修正
 * @og.rev 5.6.5.2 (2013/06/21) ポップアップ変更
 * @og.rev 5.9.4.0 (2016/01/08) type=button追加,背景色transparent
 * @og.rev 5.9.4.3 (2016/01/15) buttonのpadding:0
 *
 * @og.group データ編集
 *
 * @version  4.0
 * @author   Kazuhiko Hasegawa
 * @since    JDK5.0,
 */
public class Editor_YMD2 extends AbstractEditor {
	/** このプログラムのVERSION文字列を設定します。	{@value} */
	private static final String VERSION = "6.9.8.0 (2018/05/28)" ;

	// 5.6.5.2 (2013/06/21) htmlからjspに変更
	// 6.0.2.5 (2014/10/31) height,width に、"px"を追加
	// 5.9.4.0 (2016/01/09) type=button追加
	// 6.5.0.1 (2016/10/21) サイズ変更 '250px','265px' → '265px','260px'
	// 4.3.6.7 (2009/05/22) FireFox対応
	// 5.9.4.0 背景色transparent 5.9.4.3 padding
	// 6.4.2.0 (2016/01/29) alt属性にtitle属性を追記。

	private static final String CAL1 = "<button type=\"button\" onclick=\"ogPopup('../common/calendar.jsp','265px','260px',null,this,new Array('" ;
	// 6.8.5.0 (2018/01/09)
	private static final String CAL3 = "<button type=\"button\" onclick=\"ogPopup('../common/calendar_3month.jsp','320px','770px',null,this,new Array('" ;

	// 6.8.5.0 (2018/01/09) とりあえず、CAL1 と CAL3 しかないので、決め打ち
	// 6.9.8.0 (2018/05/28) キーワード変更(CAL_ST → CAL_STR)
	private static final String CAL_STR = "CAL1".equals( HybsSystem.sys( "CALENDAR_POPUP_TYPE" ) ) ? CAL1 : CAL3 ;

//	// 6.8.5.0 (2018/01/09) キーワード変更(CAL2 → CAL_END)
//	private static final String CAL_END = "'),event); return false;\" style=\"background-color:transparent;border:0px;padding:0;\">"
//												+ "<img src=\"../image/calendar.gif\" alt=\"Calendar\" title=\"Calendar\"/></button>";
	// 5.9.32.3command,p_appendの対応
	// 7.0.1.0 (2018/10/15) XHTML → HTML5 対応(空要素の、"／＞" 止めを、"＞" に変更します)。
	private static final String CAL_END = "'),'NEW',false,event); return false;\" style=\"background-color:transparent;border:0px;padding:0;\">"
//												+ "<img src=\"../image/calendar.gif\" alt=\"Calendar\"/></button>";
												+ "<img src=\"../image/calendar.gif\" alt=\"Calendar\"></button>";

	// 6.9.8.0 (2018/05/28) disabled 時に、日付ピッカーを出さない対応
	private final boolean disabled ;

	/**
	 * デフォルトコンストラクター。
	 * このコンストラクターで、基本オブジェクトを作成します。
	 *
	 * @og.rev 6.9.8.0 (2018/05/28) disabled 時に、日付ピッカーを出さない対応
	 */
//	public Editor_YMD2() { super(); }		// これも、自動的に呼ばれるが、空のメソッドを作成すると警告されるので、明示的にしておきます。
	public Editor_YMD2() {
		super();
		disabled = false;
	}

	/**
	 * DBColumnオブジェクトを指定したprivateコンストラクター。
	 *
	 * @og.rev 6.9.8.0 (2018/05/28) disabled 時に、日付ピッカーを出さない対応
	 *
	 * @param	clm	DBColumnオブジェクト
	 */
	private Editor_YMD2( final DBColumn clm ) {
		super( clm );
		tagBuffer.add( XHTMLTag.inputAttri( attributes ) );

		disabled = "disabled".equalsIgnoreCase( attributes.get( "disabled" ) );		// 6.9.8.0 (2018/05/28)
	}

	/**
	 * 各オブジェクトから自分のインスタンスを返します。
	 * 自分自身をキャッシュするのか、新たに作成するのかは、各サブクラスの実装に
	 * まかされます。
	 *
	 * @param	clm	DBColumnオブジェクト
	 *
	 * @return	CellEditorオブジェクト
	 * @og.rtnNotNull
	 */
	public CellEditor newInstance( final DBColumn clm ) {
		return new Editor_YMD2( clm );
	}

	/**
	 * データの編集用文字列を返します。
	 *
	 * @og.rev 4.3.7.2 (2009/06/15) 属性でidが出力される場合は、idを出力しない
	 * @og.rev 6.8.5.0 (2018/01/09) カレンダポップアップで、３ヶ月ピッカー対応
	 * @og.rev 6.9.8.0 (2018/05/28) disabled 時に、日付ピッカーを出さない対応
	 *
	 * @param	value 入力値
	 *
	 * @return	データの編集用文字列
	 * @og.rtnNotNull
	 */
	@Override
	public String getValue( final String value ) {
		// 6.1.1.0 (2015/01/17) TagBufferの連結記述
		final String tag = new TagBuffer( "input" )
						.add( "name"	, name )
						.add( "id"		, name , isNull( attributes.get( "id" ) ) )		// 4.3.7.2 (2009/06/15)
						.add( "value"	, value )
						.add( "size"	, size1 )
						.add( tagBuffer.makeTag() )
						.makeTag();

//		return tag + CAL_ST + name + CAL_END ;
		return disabled ? tag									// 6.9.8.0 (2018/05/28) disabled 時に、日付ピッカーを出さない対応
						: tag + CAL_STR + name + CAL_END ;		// 6.9.8.0 (2018/05/28) 変数名を、CAL_ST → CAL_STR に変更。
	}

	/**
	 * name属性を変えた、データ表示/編集用のHTML文字列を作成します。
	 * テーブル上の name に 行番号を付加して、名前_行番号 で登録するキーを作成し,
	 * リクエスト情報を１つ毎のフィールドで処理できます。
	 *
	 * @og.rev 4.3.7.2 (2009/06/15) 属性でidが出力される場合は、idを出力しない
	 * @og.rev 6.8.5.0 (2018/01/09) カレンダポップアップで、３ヶ月ピッカー対応
	 * @og.rev 6.9.8.0 (2018/05/28) disabled 時に、日付ピッカーを出さない対応
	 *
	 * @param	row   行番号
	 * @param	value 入力値
	 *
	 * @return	データ表示/編集用の文字列
	 * @og.rtnNotNull
	 */
	@Override
	public String getValue( final int row,final String value ) {
		final String name2 =  name + HybsSystem.JOINT_STRING + row ;

		// 6.1.1.0 (2015/01/17) TagBufferの連結記述
		final String tag = new TagBuffer( "input" )
						.add( "name"	, name2 )
						.add( "id"		, name2 , isNull( attributes.get( "id" ) ) )		// 4.3.7.2 (2009/06/15)
						.add( "value"	, value )
						.add( "size"	, size2 )
						.add( tagBuffer.makeTag() )
						.makeTag( row,value );

//		return tag + CAL_ST + name2 + CAL_END ;
		return disabled ? tag									// 6.9.8.0 (2018/05/28) disabled 時に、日付ピッカーを出さない対応
						: tag + CAL_STR + name2 + CAL_END ;		// 6.9.8.0 (2018/05/28) 変数名を、CAL_ST → CAL_STR に変更。
	}
}
