<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<jsp:directive.page import="org.opengion.hayabusa.common.HybsSystem,org.opengion.hayabusa.db.DBTableModel" />

<og:head headType="result" />

<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF9110"
	title	= "標準(タグ)"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>
<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />
<!-- 入力チェック -->
<og:columnCheck
	command   = "{@command}"
	columns   = "*"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command="{@command}" />

<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->
<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
	<!-- 先頭のカラム名が、"WRITABLE" の場合、'true' or '1' で、書き込み許可が与えら,'2' でチェック済みになります。-->
		select CASE KBSAKU WHEN '3' THEN '0' ELSE KBSAKU END AS WRITABLE,
				CLM,NAME_JA,LABEL_NAME,KBSAKU,SYSTEM_ID,LANG,
				FGJ,USRSET,DYSET,USRUPD,DYUPD
		from GF41
	<og:where>
		<og:and value = "SYSTEM_ID	=  '{@SYSTEM_ID}'"	/>
		<og:and value = "LANG		=  '{@LANG}'"		/>
		<og:and value = "CLM		like '{@CLM}'"		/>
		<og:and value = "CLM"		instrVals="{@CLMS}" instrType="in" />
		<og:and value = "NAME_JA	like '{@NAME_JA}'"	/>
		<og:and value = "LABEL_NAME	like '{@LABEL_NAME}'" />
		<og:and value = "KBSAKU		=    '{@KBSAKU}'"	/>
	</og:where>
	<og:appear startKey = "order by" value = "{@ORDER_BY}"
				defaultVal = "SYSTEM_ID,CLM,LANG" />
</og:query>

<jsp:scriptlet>
<![CDATA[
	DBTableModel table = (DBTableModel)session.getAttribute( HybsSystem.TBL_MDL_KEY );

	final int maxRow = table.getRowCount();
	final int maxCol = table.getColumnCount();

	out.print( "<table rules='all'  border='1' frame='box'><tr><th>No</th>" );
	for( int col=0; col<maxCol; col++ ) {
		final String lbl = table.getColumnLabel( col );
		out.print( "<th>" + lbl + "</th>" );
	}
	out.println( "</tr>" );

	for( int row=0; row<maxRow; row++ ) {
		out.println( "<tr><td>" + row + "</td>" );
		for( int col=0; col<maxCol; col++ ) {
			final String val = table.getValue( row,col );
			out.print( "<td>" + val + "</td>" );
		}
		out.println( "</tr>" );
	}
	out.println( "</table>" );
]]>
</jsp:scriptlet>

<!--
<og:view
	viewFormType = "HTMLTable"
	command    = "{@command}"
	noDisplay  = "{@extDisplay}"
	checked    = "{@checked}"
	startNo    = "{@startNo}"
	pageSize   = "{@pageSize}"
/>
-->

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
