<jsp:directive.page pageEncoding="UTF-8" />
<!-- PostgreSQL 版 -->
<og:equals val1="{@DBF.NAME @DBID}" val2="POSTGRES">
  <og:query command="NEW" dbid="{@DBID}" debug="{@debug}" maxRowCount="0">
		select CONSTRAINT_NAME AS INDEX_NAME,TABLE_NAME,'' AS TABLESPACE_NAME,CONSTRAINT_NAME AS NAME_JA,
				(CASE WHEN CONSTRAINT_NAME LIKE '%_pkey' THEN '1' ELSE '2' END) AS INDTYPE,
				'0' AS INITIAL_EXTENT,
				'{@TBLSYU}' AS TBLSYU,'{@SYSTEM_ID}' AS SYSTEM_ID
		from information_schema.key_column_usage
		where CONSTRAINT_SCHEMA = 'public'
	<og:where startKey="and">
		<og:and value = "TABLE_NAME  like '{@TABLE_NAME}'"  />
	</og:where>
		group by CONSTRAINT_NAME,TABLE_NAME
		order by CONSTRAINT_NAME,TABLE_NAME
  </og:query>
</og:equals>

<!-- ORACLE 版 -->
<og:equals val1="{@DBF.NAME @DBID}" val2="ORACLE">
  <og:query command="NEW" dbid="{@DBID}" debug="{@debug}" maxRowCount="0">
		select A.INDEX_NAME,A.TABLE_NAME,A.TABLESPACE_NAME,A.INDEX_NAME AS NAME_JA,
	--			(CASE A.UNIQUENESS WHEN 'UNIQUE' THEN '1' ELSE '2' END) AS INDTYPE,
				(CASE B.CONSTRAINT_TYPE WHEN 'P' THEN '0' WHEN 'U' THEN '1' ELSE '2' END) AS INDTYPE,
				A.INITIAL_EXTENT/1024 AS INITIAL_EXTENT,
				'{@TBLSYU}' AS TBLSYU,'{@SYSTEM_ID}' AS SYSTEM_ID
		from USER_INDEXES A left outer join USER_CONSTRAINTS B
					ON  A.TABLE_NAME = B.TABLE_NAME
					AND A.INDEX_NAME = B.CONSTRAINT_NAME
		where exists ( select 'X' from USER_TABLES C
						where C.TABLE_NAME = A.TABLE_NAME
					)
		and   INSTR(A.TABLE_NAME,'$') < 1
		and   INSTR(A.INDEX_NAME,'$') < 1
	<og:where startKey="and">
		<og:and value = "A.TABLE_NAME  like '{@TABLE_NAME}'"  />
	</og:where>
		order by A.TABLE_NAME,A.INDEX_NAME
  </og:query>
</og:equals>

<!-- FIREBIRD 版 -->
<og:equals val1="{@DBF.NAME @DBID}" val2="FIREBIRD">
  <og:query command="NEW" dbid="{@DBID}" debug="{@debug}" maxRowCount="0">
		select	trim(RDB$INDEX_NAME)		AS INDEX_NAME, 
				trim(RDB$RELATION_NAME)		AS TABLE_NAME, 
				'X'							AS TABLESPACE_NAME, 
				trim(RDB$INDEX_NAME)		AS NAME_JA, 
				(CASE RDB$UNIQUE_FLAG WHEN '1' THEN '1' ELSE '2' END) AS INDTYPE, 
				0						AS INITIAL_EXTENT, 
				'{@TBLSYU}' AS TBLSYU,'{@SYSTEM_ID}' AS SYSTEM_ID
		from  RDB$INDICES
		where RDB$SYSTEM_FLAG = 0
	<og:where startKey="and">
		<og:and value = "RDB$RELATION_NAME  like '{@TABLE_NAME}'"  />
	</og:where>
		order by RDB$RELATION_NAME,RDB$INDEX_NAME
  </og:query>
</og:equals>

<!-- MySQL 版 -->
<og:equals val1="{@DBF.NAME @DBID}" val2="MYSQL">
  <og:query command="NEW" dbid="{@DBID}" debug="{@debug}" maxRowCount="0">
		select	A.INDEX_NAME, 
				A.TABLE_NAME, 
				A.TABLE_SCHEMA				AS TABLESPACE_NAME, 
				A.INDEX_NAME				AS NAME_JA, 
				(CASE WHEN B.CONSTRAINT_TYPE = 'PRIMARY KEY' THEN '0'
					  WHEN A.NON_UNIQUE = '0' THEN '1'
					  ELSE '2'  END) AS INDTYPE, 
				0						AS INITIAL_EXTENT, 
				'{@TBLSYU}' AS TBLSYU,'{@SYSTEM_ID}' AS SYSTEM_ID
		from  information_schema.statistics A left outer join information_schema.table_constraints B
				on  A.table_schema = B.constraint_schema
				and A.TABLE_NAME   = B.TABLE_NAME
				and A.INDEX_NAME   = B.CONSTRAINT_NAME
		where A.table_schema=database()
	<og:where startKey="and">
		<og:and value = "A.TABLE_NAME like '{@TABLE_NAME}'"  />
	</og:where>
		group by A.TABLE_NAME,A.INDEX_NAME
		order by A.TABLE_NAME,A.INDEX_NAME
  </og:query>
</og:equals>

<!-- POSTGRES,ORACLE,FIREBIRD,MYSQL 以外の場合 -->
<og:equals val1="POSTGRES,ORACLE,FIREBIRD,MYSQL" val2="{@DBF.NAME @DBID}" contains="true" notEquals="true">
	<!-- GFE0009 : {0} は、{1} のデータベースに対応していません。 -->
	<og:message lbl="GFE0009" val0="{@LBL.GF2030}" val1="{@DBF.NAME @DBID}" />
</og:equals>
