/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.filter;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.opengion.fukurou.security.HybsCryptography;
import org.opengion.fukurou.system.ThrowUtil;
import org.opengion.fukurou.util.FileUtil;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystem;

public final class URLCheckFilter
implements Filter {
    private static final HybsCryptography HYBS_CRYPTOGRAPHY = new HybsCryptography(HybsSystem.sys("URL_CHECK_CRYPT"));
    private String filename = "jsp/custom/refuseAccess.html";
    private boolean isDebug;
    private boolean isDecode = true;
    private String ignoreURL;
    private String ommitURL;
    private String ommitReferer;

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (!this.isValidAccess(servletRequest)) {
            servletResponse.setContentType("text/html; charset=UTF-8");
            PrintWriter printWriter = servletResponse.getWriter();
            printWriter.println(this.refuseMsg());
            printWriter.flush();
            return;
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    public void init(FilterConfig filterConfig) {
        this.filename = HybsSystem.getRealPath() + StringUtil.nval((String)filterConfig.getInitParameter("filename"), (String)this.filename);
        this.isDecode = StringUtil.nval((String)filterConfig.getInitParameter("decode"), (boolean)true);
        this.ignoreURL = filterConfig.getInitParameter("ignoreURL");
        this.isDebug = StringUtil.nval((String)filterConfig.getInitParameter("debug"), (boolean)false);
        this.ommitURL = filterConfig.getInitParameter("ommitURL");
        this.ommitReferer = filterConfig.getInitParameter("ommitReferer");
    }

    public void destroy() {
    }

    private String refuseMsg() {
        return FileUtil.getValue((String)this.filename, (String)"UTF-8");
    }

    private boolean isValidAccess(ServletRequest servletRequest) {
        boolean bl;
        block18: {
            if (this.isDebug) {
                System.out.println(((HttpServletRequest)servletRequest).getRequestURI());
            }
            String string = ((HttpServletRequest)servletRequest).getQueryString();
            Object object = ((HttpServletRequest)servletRequest).getRequestURL().toString();
            String string2 = ((HttpServletRequest)servletRequest).getHeader("REFERER");
            if (string2 != null && this.ommitReferer != null && string2.indexOf(this.ommitReferer) >= 0) {
                if (this.isDebug) {
                    System.out.println("URLCheck ommitRef" + (String)object);
                }
                return true;
            }
            object = (String)object + (String)(string != null ? "?" + string : "");
            if (this.ommitURL != null && ((String)object).matches(this.ommitURL)) {
                if (this.isDebug) {
                    System.out.println("URLCheck ommitURL" + (String)object);
                }
                return true;
            }
            String string3 = servletRequest.getParameter("h_urlCheck");
            if (string3 == null || string3.isEmpty()) {
                if (this.isDebug) {
                    System.out.println("  check NG [ No Check Key ]");
                }
                return false;
            }
            bl = false;
            try {
                string3 = HYBS_CRYPTOGRAPHY.decrypt(string3).replace("&amp;", "&");
                if (this.isDebug) {
                    System.out.println("  checkKey=" + string3);
                }
                int n = string3.lastIndexOf(",time=");
                int n2 = string3.lastIndexOf(",userid=");
                String string4 = string3.substring(0, n);
                long l = Long.parseLong(string3.substring(n + 6, n2));
                String string5 = string3.substring(n2 + 8);
                String[] stringArray = StringUtil.csv2Array((String)string5);
                if (this.ignoreURL != null && this.ignoreURL.length() > 0 && string4.indexOf(this.ignoreURL) == 0) {
                    string4 = string4.substring(this.ignoreURL.length());
                }
                if (this.isDebug) {
                    System.out.println("   [ignoreURL]=" + this.ignoreURL);
                    System.out.println("   [url]      =" + string4);
                    System.out.println("   [vtime]    =" + l);
                    System.out.println("   [userid]   =" + string5);
                }
                if (this.isDecode) {
                    if (this.isDebug) {
                        System.out.println("[BeforeURIDecode]=" + (String)object);
                    }
                    object = StringUtil.urlDecode((String)object);
                    string4 = StringUtil.urlDecode((String)string4);
                }
                object = ((String)object).substring(0, ((String)object).lastIndexOf("h_urlCheck") - 1);
                String string6 = ((HttpServletRequest)servletRequest).getRemoteUser();
                if (this.isDebug) {
                    System.out.println("   [reqURL] =" + (String)object);
                    System.out.println("   [ctime]  =" + System.currentTimeMillis());
                    System.out.println("   [reqUser]=" + string6);
                }
                if (!((String)object).endsWith(string4) || System.currentTimeMillis() - l >= 0L || stringArray == null || stringArray.length <= 0) break block18;
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!"*".equals(stringArray[i]) && !string6.equals(stringArray[i])) continue;
                    bl = true;
                    if (this.isDebug) {
                        System.out.println("  check OK");
                    }
                    break;
                }
            }
            catch (RuntimeException runtimeException) {
                if (this.isDebug) {
                    String string7 = "\u30c1\u30a7\u30c3\u30af\u30a8\u30e9\u30fc\u3002  checkKey=" + string3 + " " + runtimeException.getMessage();
                    System.out.println(string7);
                    System.err.println(ThrowUtil.ogStackTrace((Throwable)runtimeException));
                }
                bl = false;
            }
        }
        return bl;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(200).append("UrlCheckFilter").append("filename=[").append(this.filename).append("],").append("isDecode=[").append(this.isDecode).append(']');
        return stringBuilder.toString();
    }
}

