<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" useChartJS="true" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />


	<!-- ﾁｬｰﾄ情報の取得 -->
	<og:query>
		SELECT ENAME LABELS
			,SAL VAL1
			,COMM VAL2
			,COMM * 1.5 VAL3
		FROM BONUS
		order by 1
	</og:query>
	
	<!-- 注：optOptions属性にscales項目を設定すると、
	jsChartﾀｸﾞのmax,min,0ｽﾀｰﾄ(beginAtZero）がﾘｾｯﾄされるため、
	optOptions内で再設定する必要があります -->
	<og:jsChart
		chartType	= "bar"
		height		= "{@height}"
		width		= "{@width}"
		labelColumn	= "LABELS"
		optOptions = ""
		debug="{@debug}"
	>
	<og:jsChartData
			chartColumn			= "VAL1"
			label				= "給料"
			type				= "line"
			borderColor			= "green"
			fontColor			= "green"
			useAxis				= "true"
			beginAtZero			= "true"
			max					= "{@max}"
			min					= "{@min}"
			optDataset		= ""
			optAxis			= ""
			 />
	<!-- optOptions属性のyAxisIDと、
	jsCahrtﾀｸﾞoptOptions属性のidが紐づきます。
	yAxisIDが指定されていない場合は、1つ目の属性が設定されます。 -->
		<og:jsChartData
			chartColumn			= "VAL2"
			label				= "裁量手当"
			type				= "bar"
			borderColor			= "blue"
			fontColor			= "blue"
			useAxis				= "true"
			position			= "right"
			gridLines			= "{borderDash :[5,2]}"
			optDataset		= ""
			optAxis			= ""
		 />
		<og:jsChartData
			chartColumn			= "VAL3"
			label				= "裁量手当"
			type				= "bar"
			borderColor			= "red"
			fontColor			= "red"
			useAxis				= "true"
			position			= "right"
			gridColor			= "rgba(256,0,0,0.2)"
			optDataset		= ""
			optAxis			= ""
		 />
	</og:jsChart>
<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
