<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:c="http://java.sun.com/jsp/jstl/core"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" useChartJS="true" >
<!--
	<script>
		window.onload = function() {
			// ダブルクリックでズームリセット
			$('#chart1').dblclick(function(){
				window.chart_chart1.resetZoom();
			});
		}
	</script>
-->
</og:head>
<jsp:directive.include file="/jsp/custom/result_info.jsp" />

	<!-- ﾁｬｰﾄ情報の取得 -->
	<og:query maxRowCount="0">
--		select substr(DYSET,1,8) as CDATE , 
		select SYSTEM_ID,USERID,substr(DYSET,1,8) as CDATE , 
				USED_TIME,CNT_ACCESS,CNT_READ,TM_TOTAL_QUERY
	--			abs(MOD(DBMS_RANDOM.RANDOM(),1000))  as NUM , 
	--			abs(MOD(DBMS_RANDOM.RANDOM(),1000))  as NUM2
		from GE15
		order by DYSET,SYSTEM_ID,USERID
	</og:query>

<!---->
<og:tableFilter classId="SKIPROW" selectedAll="true"
	keys="GROUP_KEY,DT_SKIP,VAL_CLMS"
	vals='"SYSTEM_ID,USERID",36,"USED_TIME,CNT_ACCESS,CNT_READ,TM_TOTAL_QUERY"'
/>

<og:text>{@DB.COUNT}</og:text>

<!-- idとonClickでズームリセットを実装。チャートのオブジェクト名はchart_[id名] -->
	<og:jsChart
		id					= "chart1"
		chartType			= "{@chartType}"
		xmax				= "{@xmax}"
		xmin				= "{@xmin}"
		xstepSize			= "{@xstepSize}"
		height				= "{@height}"
		width				= "800"
		barWidthPer			= "{@barWidthPer}"
		labelColumn			= "CDATE"
		title				= "{@title}"
		titlePosition		= "{@titlePosition}"
		xlabel				= "{@xlabel}"
		legendDisplay		= "{@legendDisplay}"
		legendPosition		= "{@legendPosition}"
		xscaleType			= "{@xscaleType}"
		useZoom				= "true"
		debug				= "{@debug}"
	>

<!--
		onClick				= "window.chart_chart1.resetZoom();"
		optOptions	= "
zoom:{
	enabled: true,
	drag: false,
	sensitivity: 10000,
	mode: 'xy'
},
pan:{
	enabled: true,
	speed: 2000,
threshold: 1000,
	mode: 'xy'

} "
-->
	<c:forTokens items="USED_TIME,CNT_ACCESS,CNT_READ,TM_TOTAL_QUERY" delims="," var="C_KEY" >
		<og:jsChartData
			chartColumn			= "{@C_KEY}"
			ylabel				= "{@ylabel}"
			type				= "{@type}"
			max					= "{@max}"
			min					= "{@min}"
			stepSize			= "{@stepSize}"
			label				= "{@C_KEY}"
			categoryList		= "{@categoryList}"
			fill				= "{@fill}"
			tension				= "{@tension}"
			optDataset		= ""
			optAxis			= ""
		/>
	  </c:forTokens>
	</og:jsChart>
	<ul>
		<li>ﾎｲｰﾙでxy軸の拡大、縮小</li>
		<li>canvasをクリックでzoomリセットの関数を設定しています。</li>
		<li>ｸﾘｯｸした状態で移動で、ﾊﾟﾝ動作</li>
		<li>数値(日付)ｽｹｰﾙの方向のみ可能です※公式ｻｲﾄに記載</li>
	</ul>
<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
