<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system   = "GE:エンジンサンプル"
	pgid     = "REP03"
	title    = "レイアウトテーブル"
	date     = "2007/12/12"
	author   = "K.HASEGAWA"
	text     = "ZZZZ"
	version  = "001"
/>

<!-- 変更はここからです。 -->
<og:equals val1="{@SYS.VER4_COMPATIBLE_MODE}" val2="true">
	<og:value command="SET" key="C_CLM" value="A.COLUMN_NAME" />
</og:equals>
<og:equals val1="{@SYS.VER4_COMPATIBLE_MODE}" val2="true" notEquals="true">
	<og:value command="SET" key="C_CLM" value="A.CLM" />
</og:equals>

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<!-- 入力チェックを行います。 -->
<!-- 入力内容がNULLの場合にエラーを返したい場合は、nullCheck属性を追加して下さい。-->
<og:columnCheck command = "{@command}" />

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command = "{@command}" />

<!-- DBを検索するための SQL文を記述します。 debug="true" で画面からSQL文を確認できます。 -->
<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
		select
			A.LISTID,A.KBTEXT,{@C_CLM} CLM,B.NAME_JA,A.SEQ,A.START_POS,A.USE_LENGTH,A.FGUSE,A.SYSTEM_ID,
			A.RDC_CODE,A.RELEASE_NOTES,A.FGJ,A.DYSET,A.DYUPD,A.USRSET,A.USRUPD,A.PGUPD,
			B.SYSTEM_ID as SYSID
		from GE52 A left outer join GEA03 B
--				on  B.SYSTEM_ID in ( A.SYSTEM_ID , '**' )
				on  B.SYSTEM_ID = A.SYSTEM_ID
				and A.CLM       = B.CLM
				and B.FGJ       = '1'
	<!-- 検索条件でWhereTagを使用すれば{@xxxx}がNULLの場合、その条件は無視されます。 -->
	<og:where>
		<og:and value = "A.SYSTEM_ID	= '{@SYSTEM_ID}'"	/>
		<og:and value = "A.LISTID		LIKE '{@LISTID}'"	/>
		<og:and value = "A.KBTEXT		= '{@KBTEXT}'"		/>
		<og:and value = "A.CLM		LIKE '{@CLM}'"		/>
		<og:and value = "A.FGJ		in ('0','1')"		/>
		<og:and value = "A.FGUSE		= '{@FGUSE}'"		/>
		<jsp:directive.include file="/jsp/custom/releaseNotesWhereA.jsp" />
	</og:where>
	<!-- ORDER BY句でAppearTagを使用すれば{@ORDER_BY}がNULLの場合、ORDER BY句は無視されます。 -->
	<!-- また、{@ORDER_BY}がNULLの場合に、defaultVal属性を指定すれば、その値でORDER BY表示されます。 -->
	<og:appear startKey="order by" value="{@ORDER_BY}" defaultVal="A.SYSTEM_ID,A.LISTID,A.KBTEXT,A.SEQ" />
</og:query>

<!-- ColumnEditorTagを使用すると、登録画面の入力フィールドで、入力の必須状態を表したり(must="true"を使用)、 -->
<!-- DBからの検索結果を、コンボボックスでプルダウン表示させる(editor="DBMENU"を使用)ことが可能となります。 -->
<og:columnEditor columns="SYSTEM_ID,LISTID,KBTEXT,CLM"    must="true" />

<og:viewMarker command="{@command}">
	<og:columnMarker column="NAME_JA" onMark="[SYSID]" markList="**">
		<font color="blue" title="SYSTEM_ID=**">[NAME_JA]</font>
	</og:columnMarker>
</og:viewMarker>

<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">

<!-- 追加、複写、変更、削除ボタンを作成します。 -->
<og:writeCheck>
	<og:submit  action="COPY"    columnWritable="SYSTEM_ID,LISTID,KBTEXT,CLM,SEQ,USE_LENGTH,FGUSE,RELEASE_NOTES" />
	<og:submit  action="MODIFY"  columnWritable="SEQ,USE_LENGTH,FGUSE,RELEASE_NOTES"  />
	<og:submit  action="DELETE"  columnWritable="null" />
	<br />
</og:writeCheck>

<!-- DB検索結果を表示させます。 -->
<og:view
	viewFormType = "HTMLTable"
	command		= "{@command}"
	noDisplay	= "SYSID"
	checked		= "{@checked}"
	startNo		= "{@startNo}"
	pageSize	= "{@pageSize}"
/>

</form>

<!-- 変更はここまでです。 -->

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
