<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GE:エンジン"
	pgid	= "MAIL01"
	title	= "定型文マスタ管理"
	date	= "2009/04/01"
	author	= "S.Li"
	text	= ""
	version	= "001"
/>

<og:equals val1="{@SYS.VER4_COMPATIBLE_MODE}" val2="true">
	<og:value command="SET" key="C_CONTENTS" value="CONTENT" />
</og:equals>
<og:equals val1="{@SYS.VER4_COMPATIBLE_MODE}" val2="true" notEquals="true">
	<og:value command="SET" key="C_CONTENTS" value="CONTENTS" />
</og:equals>

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<!-- 入力チェック -->
<!-- nullCheckの記述は不要です。columnのチェックを行う場合は、個別に記述する必要があります -->
<og:columnCheck
	command   = "{@command}"
	columns   = "PTN_ID,MAIL_TITLE,CONTENTS,FROM_ID,TO_ID,CC,BCC,DYSET_FROM,DYSET_TO,DYUPD_FROM,DYUPD_TO"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command="{@command}" />

<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->
<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
	<!-- DB登録時に使用する USRSET カラムを、DBTableModel に設定しておきます。-->
		SELECT	 SYSTEM_ID
				,PTN_ID
				,'' PUP
				,TITLE MAIL_TITLE
				,{@C_CONTENTS} CONTENTS
				,FROM_ID
				,TO_ID
				,CC_ID
				,BCC_ID
				,JOKEN <!-- 5.6.6.0 -->
				,DYSET
				,USRSET
				,DYUPD
				,USRUPD
				,PGUPD
				,UNIQ
		FROM	GE31
	<og:where>
		<og:and value = "SYSTEM_ID 	=		'{@SYSTEM_ID}'" />		
		<og:and value = "PTN_ID		=		'{@PTN_ID}'"	/>		
		<og:and value = "TITLE			LIKE	'%{@MAIL_TITLE}'"	/>	
		<og:and value = "FROM_ID		=		'{@FROM_ID}'"	/>		
		<og:and value = "TO_ID			LIKE	'%{@TO_ID}'"	/>		
		<og:and value = "CC_ID			LIKE	'%{@CC_ID}'"	/>		
		<og:and value = "BCC_ID		LIKE 	'%{@BCC_ID}'"	/>		
		<og:and value = "COALESCE(FGJ,'0')	!=		'9'"			/>		
		<og:and value = "DYSET			&gt;= '{@DYSET_FROM}'"/>		
		<og:and value = "DYSET			&lt;= '{@DYSET_TO}'"  />		
		<og:and value = "DYUPD			&gt;= '{@DYUPD_FROM}'"/>		
		<og:and value = "DYUPD			&lt;= '{@DYUPD_TO}'"  />		
	</og:where>
		order by PTN_ID
</og:query>

<!-- ColumnEditorTag は、指定のカラム属性を設定しなおします。 以下は、must属性を true にしています。 -->
<og:columnEditor columns="PTN_ID"    must="true" />
<og:columnEditor columns="FROM_ID"   must="true" />
<og:columnEditor column="CONTENTS"    must="true" editor="TEXTAREA" param="10,80" />
<og:columnEditor column="MAIL_TITLE" must="true" size="103"   />

<og:columnEditor column="TO_ID" renderer="SLABEL" />
<og:columnEditor column="CC_ID" renderer="SLABEL" />
<og:columnEditor column="BCC_ID" renderer="SLABEL" />

<og:viewLink command="{@command}">
	<og:link column="JOKEN" gamenId="MAIL08" href="index.jsp" target="CONTENTS"
		keys="command,SYSTEM_ID,JOKEN" vals="NEW,[SYSTEM_ID],[JOKEN]" />
</og:viewLink>

<og:viewMarker command="{@command}">
    <og:popup column="PUP" href="showPtn.jsp" lbl="DETAILS" style="size:10px;" 
               keys="command,SYSTEM_ID,PTN_ID" vals="NEW,{@SYSTEM_ID},[PTN_ID]" />
</og:viewMarker>

<!-- formタグでリクエストフィールドを囲います。oneClick()関数は、２重押し防止JavaScriptです。 -->
<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">

<!-- 複写、変更、削除ボタンを作成します。value属性+.jspの画面に制御が移ります。 -->
<!-- このとき、command=(value属性の値の大文字)が設定されます。 command属性で設定しなおすことも出来ます。-->
<!-- ここでは、すべてを、update.jsp に転送している為、command属性を設定しています。-->
<og:writeCheck>
	<og:submit value="copy"   command="COPY"   lbl="COPY"   accesskey="C" keys="SYSTEM_ID" vals="{@SYSTEM_ID}" />
	<og:submit value="modify" command="MODIFY" lbl="MODIFY" accesskey="M" />
	<og:submit value="delete" command="DELETE" lbl="DELETE" accesskey="Z" />
<br />
</og:writeCheck>

<!-- DB検索結果を表示させます。 -->
<og:view
	viewFormType = "HTMLTable" 
	command      = "{@command}" 
	noDisplay    = "UNIQ,SYSTEM_ID"
	selectedType = "checkbox"/>
</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
