/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.taglib;

import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.opengion.fukurou.system.LogWriter;
import org.opengion.fukurou.util.FileUtil;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.ToString;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.taglib.CommonTagSupport;

public class TextTag
extends CommonTagSupport {
    private static final String VERSION = "7.0.1.3 (2018/11/12)";
    private static final long serialVersionUID = 701320181112L;
    private String value;
    private boolean useInclude;
    private boolean usePrintOut;
    private boolean xssCheck = HybsSystem.sysBool("USE_XSS_CHECK");
    private boolean useStop;

    @Override
    public int doStartTag() {
        return this.useTag() && !this.useInclude && this.value == null ? 2 : 0;
    }

    @Override
    public int doAfterBody() {
        try {
            this.useXssCheck(this.xssCheck);
            this.value = this.getBodyString();
        }
        catch (HybsSystemException hybsSystemException) {
            this.value = this.getBodyContent().getString();
        }
        return 0;
    }

    @Override
    public int doEndTag() {
        if (this.usePrintOut) {
            System.out.println("TextTag=" + this.value);
        } else {
            this.debugPrint();
            if (this.useTag()) {
                this.jspPrint(this.value);
            } else {
                return 6;
            }
        }
        return this.useStop ? 5 : 6;
    }

    @Override
    protected void release2() {
        super.release2();
        this.value = null;
        this.useInclude = false;
        this.usePrintOut = false;
        this.xssCheck = HybsSystem.sysBool("USE_XSS_CHECK");
        this.useStop = false;
    }

    public void setValue(String string) {
        if (!this.useInclude) {
            try {
                this.value = this.getRequestParameter(string);
            }
            catch (HybsSystemException hybsSystemException) {
                this.value = string;
                LogWriter.log((String)("val=" + string + " [" + hybsSystemException.getMessage() + "]"));
            }
        }
    }

    public void setInclude(String string) {
        this.useInclude = true;
        String string2 = this.getRequestParameter(string);
        String string3 = this.getContextRelativePath(this.getRequest(), string2);
        String string4 = HybsSystem.url2dir(string3.substring(1));
        this.value = FileUtil.getValue((String)string4, (String)"UTF-8");
    }

    public void setUsePrintOut(String string) {
        this.usePrintOut = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.usePrintOut);
    }

    public void setXssCheck(String string) {
        this.xssCheck = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.xssCheck);
    }

    public void setUseStop(String string) {
        this.useStop = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useStop);
    }

    @Override
    public String toString() {
        return ToString.title((String)((Object)((Object)this)).getClass().getName()).println("VERSION", (Object)VERSION).println("useTag", (Object)this.useTag()).println("value", (Object)this.value).println("Other...", (Object)this.getAttributes().getAttribute()).fixForm().toString();
    }

    private String getContextRelativePath(ServletRequest servletRequest, String string) {
        if (StringUtil.startsChar((CharSequence)string, (char)'/') || !(servletRequest instanceof HttpServletRequest)) {
            return string;
        }
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        String string2 = (String)servletRequest.getAttribute("javax.servlet.include.servlet_path");
        if (string2 != null && string2.lastIndexOf(47) >= 0) {
            String string3 = (String)servletRequest.getAttribute("javax.servlet.include.path_info");
            if (string3 == null) {
                string2 = string2.substring(0, string2.lastIndexOf(47));
            }
        } else {
            string2 = httpServletRequest.getServletPath();
            if (string2.lastIndexOf(47) >= 0) {
                string2 = string2.substring(0, string2.lastIndexOf(47));
            }
        }
        return string2 + '/' + string;
    }
}

