/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.model;

import java.util.Arrays;
import org.opengion.fukurou.model.DataModel;
import org.opengion.fukurou.util.StringUtil;

public class DataModelSorter {
    private DataModel<String> table;
    private Integer[] idx;
    private int sortClmNo = -1;
    private boolean ascending = true;
    private boolean isNumType;

    public void setModel(DataModel<String> dataModel) {
        this.table = dataModel;
    }

    public void sortColumn(int n, boolean bl) {
        boolean bl2 = this.sortClmNo == n ? !this.ascending : true;
        this.sortColumn(n, bl, bl2);
    }

    public void sortColumn(int n3, boolean bl, boolean bl2) {
        this.sortClmNo = n3;
        this.isNumType = bl;
        this.ascending = bl2;
        this.reallocateIndexes();
        Arrays.sort(this.idx, (n, n2) -> this.compareColumn((int)n, (int)n2));
    }

    private void reallocateIndexes() {
        int n = this.table.getRowCount();
        this.idx = new Integer[n];
        for (int i = 0; i < n; ++i) {
            this.idx[i] = i;
        }
    }

    private int compareColumn(int n, int n2) {
        int n3;
        String string = this.table.getValue(n, this.sortClmNo);
        String string2 = this.table.getValue(n2, this.sortClmNo);
        if (string.isEmpty() || string2.isEmpty()) {
            n3 = string.length() - string2.length();
        } else if (this.isNumType) {
            if (string.charAt(0) == '_') {
                string = string.substring(1);
            }
            if (string2.charAt(0) == '_') {
                string2 = string2.substring(1);
            }
            double d = StringUtil.parseDouble(string);
            double d2 = StringUtil.parseDouble(string2);
            n3 = Double.compare(d, d2);
        } else {
            n3 = string.compareTo(string2);
        }
        return n3 == 0 ? 0 : (this.ascending ? n3 : -n3);
    }

    public int[] getIndexes() {
        int n = this.idx.length;
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = this.idx[i];
        }
        return nArray;
    }

    public boolean isAscending() {
        return this.ascending;
    }
}

