/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.taglib;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.servlet.jsp.tagext.Tag;
import org.opengion.fukurou.util.HybsDateUtil;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.ToString;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.resource.CalendarData;
import org.opengion.hayabusa.resource.CalendarFactory;
import org.opengion.hayabusa.taglib.CommonTagSupport;
import org.opengion.hayabusa.taglib.ViewFormTag;

public class GanttHeaderTag
extends CommonTagSupport {
    private static final String VERSION = "6.4.2.0 (2016/01/29)";
    private static final long serialVersionUID = 642020160129L;
    private static final String SPACE = "                                   ";
    private static final String[] DAY_OF_WEEK_JA = new String[]{" ", "\u65e5 ", "\u6708 ", "\u706b ", "\u6c34 ", "\u6728 ", "\u91d1 ", "\u571f "};
    private static final int TIME_PIXEL = 48;
    private static final int MONTH_DATE_LIMITER = 20;
    private static final boolean USE_MONTH_DATE = HybsSystem.sysBool("USE_GANTTHEADER_MONTH_DATE");
    private static final String BLUE_COLOR = "<span style=\"color:Blue;\">";
    private static final String RED_COLOR = "<span style=\"color:Red;\">";
    private static final String TODAY_CLASS = "gntToday";
    private static final String HOLIDAY_CLASS = "gntHoliday";
    private static final String END_SPAN = "</span>";
    private static final String BR = "<br>";
    private static final String DIV_ZOOMWEEK_START = "<div class=\"zoomWeekBlock\">";
    private static final String DIV_ZOOMEVENCOLOR = "<div class=\"zoomHeaderDiv evenColor\">";
    private static final String DIV_ZOOMODDCOLOR = "<div class=\"zoomHeaderDiv oddColor\">";
    private static final String DIV_ZOOMHEADER2 = "<div class=\"zoomHeaderDiv zoomHeaderDiv2\">";
    private static final String DIV_ZOOMWEEKDAY = "<div class=\"zoomWeekDay\">";
    private static final String END_DIV = "</div>";
    private static final boolean USE_MD_HEADER = HybsSystem.sysBool("USE_MDHEADER_ONTIME");
    private String startDate;
    private String endDate;
    private String daySpan = "0700-2000";
    private int zoom = 2;
    private String breakTimes;
    private String breakTimeStyle = "top:20px;background-color:yellow;filter:alpha(opacity=60);opacity:0.60;";
    private String calDB;
    private String arg1;
    private String arg2;
    private String arg3;
    private String arg4;
    private boolean skipHoliday = HybsSystem.sysBool("USE_GANTTHEADER_SKIP_HOLIDAY");
    private String calStr;
    private boolean useMultiClm = HybsSystem.sysBool("USE_GANTTHEADER_MULTIPLE_COLUMN");
    private String baseTimes;
    private String baseTimeStyle = "top:20px;background-color:transparent;border-left:2px dashed red;";

    @Override
    public int doEndTag() {
        this.debugPrint();
        if (this.startDate == null || this.endDate == null || this.startDate.length() < 8 || this.endDate.length() < 8) {
            String string = "\u958b\u59cb\u65e5\u3068\u7d42\u4e86\u65e5\u306f\u3001\u3069\u3061\u3089\u3082 yyyyMMdd \u5f62\u5f0f\u3067\u3001\u5fc5\u9808\u3067\u3059\u3002 startDate=[" + this.startDate + "] endDate=[" + this.endDate + "]";
            throw new HybsSystemException(string);
        }
        String string = "";
        String string2 = USE_MONTH_DATE ? "MM   " : "MM/dd";
        switch (this.zoom) {
            case 0: {
                string = this.makeZoom("MM/   ", "dd(EE)", 1, false);
                break;
            }
            case 1: {
                string = this.makeZoom("MM/", "dd ", 1, false);
                break;
            }
            case 2: {
                string = this.makeZoom2(1);
                break;
            }
            case 3: {
                string = this.makeZoom("yyyy/  ", "MM/dd  ", 7, false);
                break;
            }
            case 4: {
                string = this.makeZoom("yyyy/  ", "MM/dd  ", 14, false);
                break;
            }
            case 5: {
                string = this.makeZoom("yyyy/     ", string2 + "     ", 30, USE_MONTH_DATE);
                break;
            }
            case 6: {
                string = this.makeZoom("yyyy/ ", string2 + " ", 30, USE_MONTH_DATE);
                break;
            }
            case 7: {
                string = this.makeZoom("yyyy/     ", string2 + "     ", 90, USE_MONTH_DATE);
                break;
            }
            case 8: {
                string = this.makeZoom("yyyy/     ", string2 + "     ", 180, USE_MONTH_DATE);
                break;
            }
            case 9: {
                string = this.makeZoom("yyyy/ ", string2 + " ", 180, USE_MONTH_DATE);
                break;
            }
            case 10: {
                string = this.makeZoom("ww'W'", "'<span title=\"'MM/dd'\">'dd '</span>'", 7, false);
                break;
            }
            case 13: {
                string = this.makeZoom3("yyyy/MM", "dd", "EE", 1);
                break;
            }
            case 20: {
                string = this.makeZoomTime(48, 1, true);
                break;
            }
            case 21: {
                string = this.makeZoomTime(24, 1, false);
                break;
            }
            case 22: {
                string = this.makeZoomTime(48, 2, true);
                break;
            }
            case 23: {
                string = this.makeZoomTime(24, 2, false);
                break;
            }
            case 24: {
                string = this.makeZoomTime(48, 4, true);
                break;
            }
            case 25: {
                string = this.makeZoomTime(24, 4, false);
                break;
            }
            case 26: {
                string = this.makeZoomTime(48, 6, true);
                break;
            }
            case 27: {
                string = this.makeZoomTime(24, 6, false);
                break;
            }
            case 28: {
                string = this.makeZoomTime(48, 8, true);
                break;
            }
            case 29: {
                string = this.makeZoomTime(24, 8, false);
                break;
            }
            case 30: {
                string = this.makeZoomTime(48, 12, true);
                break;
            }
            case 31: {
                string = this.makeZoomTime(24, 12, false);
                break;
            }
            case 40: {
                string = this.makeZoomStack("MM/   ", "dd(EE)", 1, false);
                break;
            }
            case 41: {
                string = this.makeZoomStack("ww'W'   ", "MM/dd ", 7, false);
                break;
            }
            case 42: {
                string = this.makeZoomStack("yyyy/     ", "MM        ", 1, true);
                break;
            }
        }
        this.jspPrint(string);
        this.jspPrint(this.makeHeaderData());
        return 6;
    }

    @Override
    protected void release2() {
        super.release2();
        this.startDate = null;
        this.endDate = null;
        this.daySpan = "0700-2000";
        this.zoom = 2;
        this.calDB = null;
        this.arg1 = null;
        this.arg2 = null;
        this.arg3 = null;
        this.arg4 = null;
        this.breakTimes = null;
        this.breakTimeStyle = "top:20px;background-color:yellow;filter:alpha(opacity=60);opacity:0.60;";
        this.skipHoliday = HybsSystem.sysBool("USE_GANTTHEADER_SKIP_HOLIDAY");
        this.calStr = null;
        this.baseTimes = null;
        this.baseTimeStyle = "top:20px;background-color:transparent;border-left:2px dashed red;";
        this.useMultiClm = HybsSystem.sysBool("USE_GANTTHEADER_MULTIPLE_COLUMN");
    }

    private String makeZoom(String string, String string2, int n, boolean bl) {
        boolean bl2 = string.startsWith("MM");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string, Locale.JAPAN);
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat(string2, Locale.JAPAN);
        Calendar calendar = HybsDateUtil.getCalendar((String)this.startDate);
        Calendar calendar2 = HybsDateUtil.getCalendar((String)this.endDate);
        if (this.zoom == 10) {
            calendar.setMinimalDaysInFirstWeek(7);
            simpleDateFormat.setCalendar(calendar);
            simpleDateFormat2.setCalendar(calendar);
        }
        StringBuilder stringBuilder = new StringBuilder(200);
        StringBuilder stringBuilder2 = new StringBuilder(200);
        StringBuilder stringBuilder3 = new StringBuilder(200);
        CalendarData calendarData = CalendarFactory.getCalendarData(this.calDB, this.arg1, this.arg2, this.arg3, this.arg4);
        boolean bl3 = false;
        int n2 = 0;
        if (bl2) {
            stringBuilder.append(DIV_ZOOMWEEK_START);
        }
        boolean bl4 = true;
        while (calendar.compareTo(calendar2) <= 0) {
            boolean bl5;
            boolean bl6 = bl5 = 2 == calendar.get(7);
            if (bl2 && bl5) {
                stringBuilder.append(stringBuilder2.toString()).append(END_DIV);
                stringBuilder2.setLength(0);
                ++n2;
                bl4 = true;
                stringBuilder.append(DIV_ZOOMWEEK_START);
            }
            Date date = calendar.getTime();
            if (bl && calendar.get(5) >= 20) {
                Calendar calendar3 = (Calendar)calendar.clone();
                calendar3.set(5, 1);
                calendar3.add(2, 1);
                date = calendar3.getTime();
            }
            if (calendarData.isContainedToday(calendar, n)) {
                stringBuilder2.append(BLUE_COLOR);
                stringBuilder3.append('0');
                bl3 = true;
            }
            if (!bl3 && n == 1 && calendarData.isHoliday(calendar)) {
                stringBuilder2.append(RED_COLOR);
                stringBuilder3.append('1');
                bl3 = true;
            }
            if (bl2 && !bl4) {
                stringBuilder.append(SPACE.substring(0, string.length()));
            } else {
                if (bl2) {
                    if (n2 % 2 == 0) {
                        stringBuilder.append(DIV_ZOOMEVENCOLOR);
                    } else {
                        stringBuilder.append(DIV_ZOOMODDCOLOR);
                    }
                } else {
                    stringBuilder.append(DIV_ZOOMHEADER2);
                }
                stringBuilder.append(simpleDateFormat.format(date));
                stringBuilder.append(END_DIV);
                bl4 = false;
            }
            stringBuilder2.append(DIV_ZOOMHEADER2);
            stringBuilder2.append(simpleDateFormat2.format(date));
            stringBuilder2.append(END_DIV);
            if (bl3) {
                stringBuilder2.append(END_SPAN);
                bl3 = false;
            } else {
                stringBuilder3.append('0');
            }
            calendar.add(5, n);
        }
        this.calStr = stringBuilder3.toString();
        if (bl2) {
            stringBuilder.append((CharSequence)stringBuilder2).append(END_DIV);
        } else {
            stringBuilder.append(BR).append((CharSequence)stringBuilder2);
        }
        stringBuilder2.setLength(0);
        return stringBuilder.toString();
    }

    private String makeZoom2(int n) {
        Calendar calendar = HybsDateUtil.getCalendar((String)this.startDate);
        Calendar calendar2 = HybsDateUtil.getCalendar((String)this.endDate);
        StringBuilder stringBuilder = new StringBuilder(200);
        StringBuilder stringBuilder2 = new StringBuilder(200);
        StringBuilder stringBuilder3 = new StringBuilder(200);
        StringBuilder stringBuilder4 = new StringBuilder(200);
        CalendarData calendarData = CalendarFactory.getCalendarData(this.calDB, this.arg1, this.arg2, this.arg3, this.arg4);
        boolean bl = false;
        int n2 = 0;
        int n3 = 0;
        stringBuilder.append(DIV_ZOOMWEEK_START).append(DIV_ZOOMEVENCOLOR);
        int n4 = 0;
        while (calendar.compareTo(calendar2) <= 0) {
            boolean bl2;
            int n5 = calendar.get(2) + 1;
            int n6 = calendar.get(5);
            boolean bl3 = bl2 = 2 == calendar.get(7);
            if (bl2) {
                stringBuilder.append(END_DIV).append(stringBuilder2.toString()).append(BR).append(stringBuilder3.toString()).append(END_DIV);
                stringBuilder2.setLength(0);
                stringBuilder3.setLength(0);
                n3 = 0;
                stringBuilder.append(DIV_ZOOMWEEK_START);
                if (++n2 % 2 == 0) {
                    stringBuilder.append(DIV_ZOOMEVENCOLOR);
                } else {
                    stringBuilder.append(DIV_ZOOMODDCOLOR);
                }
            }
            if (calendarData.isContainedToday(calendar, n)) {
                stringBuilder2.append(BLUE_COLOR);
                stringBuilder3.append(BLUE_COLOR);
                stringBuilder4.append('0');
                bl = true;
            }
            if (!bl && n == 1 && calendarData.isHoliday(calendar)) {
                stringBuilder2.append(RED_COLOR);
                stringBuilder3.append(RED_COLOR);
                stringBuilder4.append('1');
                bl = true;
            }
            switch (n3++) {
                case 0: {
                    n4 = n5;
                    stringBuilder.append(n5 / 10);
                    break;
                }
                case 1: {
                    stringBuilder.append(n4 % 10);
                    break;
                }
                case 2: {
                    stringBuilder.append('/');
                    break;
                }
                default: {
                    stringBuilder.append(' ');
                }
            }
            stringBuilder2.append(DIV_ZOOMHEADER2).append(n6 / 10).append(END_DIV);
            stringBuilder3.append(DIV_ZOOMHEADER2).append(n6 % 10).append(END_DIV);
            if (bl) {
                stringBuilder2.append(END_SPAN);
                stringBuilder3.append(END_SPAN);
                bl = false;
            } else {
                stringBuilder4.append('0');
            }
            calendar.add(5, n);
        }
        stringBuilder.append(END_DIV).append(stringBuilder2.toString()).append(BR).append(stringBuilder3.toString()).append(END_DIV);
        stringBuilder2.setLength(0);
        stringBuilder3.setLength(0);
        this.calStr = stringBuilder4.toString();
        return stringBuilder.toString();
    }

    private String makeZoom3(String string, String string2, String string3, int n) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string, Locale.JAPAN);
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat(string2, Locale.JAPAN);
        SimpleDateFormat simpleDateFormat3 = new SimpleDateFormat(string3, Locale.JAPAN);
        StringBuilder stringBuilder = new StringBuilder(200);
        StringBuilder stringBuilder2 = new StringBuilder(200);
        StringBuilder stringBuilder3 = new StringBuilder(200);
        StringBuilder stringBuilder4 = new StringBuilder(200);
        Calendar calendar = HybsDateUtil.getCalendar((String)this.startDate);
        Calendar calendar2 = HybsDateUtil.getCalendar((String)this.endDate);
        CalendarData calendarData = CalendarFactory.getCalendarData(this.calDB, this.arg1, this.arg2, this.arg3, this.arg4);
        int n2 = string3.length();
        int n3 = 0;
        int n4 = calendar.get(2) + 1;
        String string4 = null;
        stringBuilder.append(DIV_ZOOMWEEK_START);
        while (calendar.compareTo(calendar2) <= 0) {
            int n5;
            Date date = calendar.getTime();
            if (string4 == null) {
                string4 = simpleDateFormat.format(date);
            }
            if ((n5 = calendar.get(5)) == 1 && n3 > 0) {
                this.makeHeaderYM(stringBuilder, n3 * n2, n4++, string4);
                stringBuilder.append((CharSequence)stringBuilder2).append(BR).append((CharSequence)stringBuilder3).append(END_DIV);
                stringBuilder2.setLength(0);
                stringBuilder3.setLength(0);
                stringBuilder.append(DIV_ZOOMWEEK_START);
                n3 = 0;
                string4 = simpleDateFormat.format(date);
            }
            ++n3;
            String string5 = null;
            if (calendarData.isHoliday(calendar)) {
                string5 = HOLIDAY_CLASS;
                stringBuilder4.append('1');
            } else {
                stringBuilder4.append('0');
            }
            if (calendarData.isContainedToday(calendar, n)) {
                String string6 = string5 = string5 == null ? TODAY_CLASS : string5 + " " + TODAY_CLASS;
            }
            if (string5 != null) {
                stringBuilder2.append("<span class=\"").append(string5).append("\">");
                stringBuilder3.append("<span class=\"").append(string5).append("\">");
            }
            stringBuilder2.append(DIV_ZOOMHEADER2);
            stringBuilder3.append(DIV_ZOOMHEADER2);
            stringBuilder2.append(simpleDateFormat2.format(date));
            stringBuilder3.append(simpleDateFormat3.format(date));
            stringBuilder2.append(END_DIV);
            stringBuilder3.append(END_DIV);
            if (string5 != null) {
                stringBuilder2.append(END_SPAN);
                stringBuilder3.append(END_SPAN);
            }
            calendar.add(5, n);
        }
        this.makeHeaderYM(stringBuilder, n3 * n2, n4, string4);
        stringBuilder.append((CharSequence)stringBuilder2).append(BR).append((CharSequence)stringBuilder3).append(END_DIV);
        stringBuilder2.setLength(0);
        stringBuilder3.setLength(0);
        this.calStr = stringBuilder4.toString();
        return stringBuilder.toString();
    }

    private StringBuilder makeHeaderYM(StringBuilder stringBuilder, int n, int n2, String string) {
        if (n2 % 2 == 0) {
            stringBuilder.append(DIV_ZOOMEVENCOLOR);
        } else {
            stringBuilder.append(DIV_ZOOMODDCOLOR);
        }
        if (n < string.length()) {
            stringBuilder.append(SPACE.substring(0, n));
        } else {
            int n3 = (n - string.length()) / 2;
            int n4 = n - n3 - string.length();
            stringBuilder.append(SPACE.substring(0, n3));
            stringBuilder.append(string);
            stringBuilder.append(SPACE.substring(0, n4));
        }
        stringBuilder.append(END_DIV);
        return stringBuilder;
    }

    private String makeZoomTime(int n, int n2, boolean bl) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd(EE)", Locale.JAPAN);
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("MM/dd", Locale.JAPAN);
        StringBuilder stringBuilder = new StringBuilder(200);
        StringBuilder stringBuilder2 = new StringBuilder(200);
        StringBuilder stringBuilder3 = new StringBuilder(200);
        StringBuilder stringBuilder4 = new StringBuilder(200);
        StringBuilder stringBuilder5 = new StringBuilder(200);
        String string = null;
        int n3 = 0;
        int n4 = 2;
        if (bl) {
            n4 = 4;
        }
        int n5 = this.daySpan.indexOf(45);
        int n6 = GanttHeaderTag.hm2int(this.daySpan.substring(0, n5));
        int n7 = GanttHeaderTag.hm2int(this.daySpan.substring(n5 + 1));
        BreakTimes breakTimes = new BreakTimes(n / n2, this.breakTimes, this.breakTimeStyle, n6, n7);
        BreakTimes breakTimes2 = new BreakTimes(n / n2, this.baseTimes, this.baseTimeStyle, n6, n7);
        Calendar calendar = Calendar.getInstance();
        calendar.add(12, 5);
        int n8 = calendar.get(11);
        boolean bl2 = this.isDebug();
        if (bl2) {
            System.out.println("startDate=" + this.startDate);
            System.out.println("endDate  =" + this.endDate);
        }
        Calendar calendar2 = HybsDateUtil.getCalendar((String)this.startDate);
        Calendar calendar3 = HybsDateUtil.getCalendar((String)this.endDate);
        CalendarData calendarData = CalendarFactory.getCalendarData(this.calDB, this.arg1, this.arg2, this.arg3, this.arg4);
        int n9 = (int)((double)n * Math.ceil((double)(n7 - n6) / 100.0 / (double)n2));
        int n10 = 0;
        int n11 = (int)((double)(n / n2 * (n6 - (int)((double)(calendar2.get(11) * 100) + (double)calendar2.get(12) * 10.0 / 6.0))) / 100.0);
        String string2 = bl ? "h " : "";
        boolean bl3 = false;
        int n12 = 0;
        StringBuilder stringBuilder6 = new StringBuilder(200);
        while (calendar2.before(calendar3)) {
            int n13;
            if (bl2) {
                System.out.println("Calendar str =" + calendar2.getTime());
            }
            int n14 = calendar2.get(5);
            String string3 = (n14 >= 10 ? Integer.valueOf(n14) : "0" + n14) + (bl ? DAY_OF_WEEK_JA[calendar2.get(7)] : "");
            if (calendarData.isHoliday(calendar2)) {
                stringBuilder4.append('1');
            } else {
                stringBuilder4.append('0');
            }
            if (calendarData.isHoliday(calendar2) && this.skipHoliday) {
                if (bl2) {
                    System.out.println("Holiday =" + calendar2.getTime());
                }
                calendar2.add(5, 1);
                continue;
            }
            String string4 = "class=\"GNT_" + n12 % 2 + " zoomHeaderDiv2\"";
            Date date = calendar2.getTime();
            String string5 = simpleDateFormat.format(date);
            stringBuilder2.append("<div ").append(string4).append(" title=\"").append(string5).append("\">");
            if (string != null && n3 > 0) {
                this.makeHeaderMD(stringBuilder5, n3 * n4, 0, string);
                n3 = 0;
            }
            string = simpleDateFormat2.format(date);
            if (bl2) {
                System.out.println("title =" + string5);
            }
            if (n12 > 0) {
                stringBuilder6.append(DIV_ZOOMWEEK_START);
                if (USE_MD_HEADER) {
                    stringBuilder6.append((CharSequence)stringBuilder5);
                }
                stringBuilder6.append((CharSequence)stringBuilder3);
                stringBuilder5.setLength(0);
                stringBuilder3.setLength(0);
            }
            if (this.useMultiClm) {
                if (n12 % 2 == 0) {
                    stringBuilder3.append(DIV_ZOOMEVENCOLOR);
                } else {
                    stringBuilder3.append(DIV_ZOOMODDCOLOR);
                }
            }
            ++n12;
            boolean bl4 = calendarData.isContainedToday(calendar2, 1);
            int n15 = n13 = n6 / 100;
            boolean bl5 = false;
            for (int i = n6; i < n7; i += 100) {
                Object object;
                if (bl2) {
                    System.out.println("hour =" + i);
                    System.out.println("tmHd =" + n13);
                }
                boolean bl6 = bl5 = bl5 || bl4 && n13 == n8;
                if ((n15 - n13) % n2 != 0) {
                    ++n13;
                    continue;
                }
                ++n3;
                if (n13 >= 24) {
                    n13 = 0;
                    object = new Date(calendar2.getTimeInMillis() + 86400000L);
                    string5 = simpleDateFormat.format((Date)object);
                    stringBuilder2.append(END_DIV).append("<div ").append(string4).append(" title=\"").append(string5).append("\">");
                }
                if (bl5) {
                    stringBuilder2.append(BLUE_COLOR);
                    stringBuilder3.append(BLUE_COLOR);
                    bl3 = true;
                    bl5 = false;
                } else if (calendarData.isHoliday(calendar2) && !this.skipHoliday) {
                    stringBuilder2.append(RED_COLOR);
                    stringBuilder3.append(RED_COLOR);
                    bl3 = true;
                }
                object = breakTimes.makeSpan(n10 * n9 - n11, calendar2, i, n2);
                if (object != null) {
                    stringBuilder.append((String)object);
                }
                if ((object = breakTimes2.makeSpan(n10 * n9 - n11, calendar2, i, n2)) != null) {
                    stringBuilder.append((String)object);
                }
                stringBuilder2.append(DIV_ZOOMWEEKDAY);
                if (n13 < 10) {
                    stringBuilder2.append('0');
                }
                stringBuilder2.append(n13).append(string2).append(END_DIV);
                if (this.useMultiClm) {
                    if (n15 == n13) {
                        stringBuilder3.append(string3);
                    } else if (bl) {
                        stringBuilder3.append("    ");
                    } else {
                        stringBuilder3.append("  ");
                    }
                }
                if (bl3) {
                    stringBuilder2.append(END_SPAN);
                    stringBuilder3.append(END_SPAN);
                    bl3 = false;
                }
                ++n13;
            }
            if (this.useMultiClm) {
                stringBuilder3.append(END_DIV);
            }
            stringBuilder3.append(stringBuilder2.toString()).append(END_DIV);
            stringBuilder2.setLength(0);
            calendar2.add(5, 1);
            ++n10;
            if (!this.useMultiClm) continue;
            stringBuilder3.append(END_DIV);
        }
        this.calStr = stringBuilder4.toString();
        if (string != null && n3 > 0) {
            this.makeHeaderMD(stringBuilder5, n3 * n4, 0, string);
            n3 = 0;
        }
        stringBuilder6.append(DIV_ZOOMWEEK_START);
        if (USE_MD_HEADER) {
            stringBuilder6.append((CharSequence)stringBuilder5);
        }
        stringBuilder6.append((CharSequence)stringBuilder3);
        stringBuilder5.setLength(0);
        stringBuilder3.setLength(0);
        return stringBuilder.append((CharSequence)stringBuilder6).toString();
    }

    private StringBuilder makeHeaderMD(StringBuilder stringBuilder, int n, int n2, String string) {
        if (n2 % 2 == 0) {
            stringBuilder.append(DIV_ZOOMEVENCOLOR);
        } else {
            stringBuilder.append(DIV_ZOOMODDCOLOR);
        }
        if (n < string.length()) {
            stringBuilder.append(StringUtil.stringXFill((String)" ", (int)n));
        } else {
            stringBuilder.append(StringUtil.stringXFill((String)string, (int)n));
        }
        stringBuilder.append(END_DIV);
        return stringBuilder;
    }

    private String makeZoomStack(String string, String string2, int n, boolean bl) {
        Object object;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string, Locale.JAPAN);
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat(string2, Locale.JAPAN);
        SimpleDateFormat simpleDateFormat3 = new SimpleDateFormat("yyyyMMdd", Locale.JAPAN);
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        String[] stringArray = new String[3];
        Calendar calendar = HybsDateUtil.getCalendar((String)this.startDate);
        Calendar calendar2 = HybsDateUtil.getCalendar((String)this.endDate);
        if (this.zoom == 41) {
            calendar.setMinimalDaysInFirstWeek(7);
            simpleDateFormat.setCalendar(calendar);
            simpleDateFormat2.setCalendar(calendar);
        }
        if (bl) {
            calendar.set(5, 1);
            this.startDate = new SimpleDateFormat("yyyyMMdd", Locale.JAPAN).format(calendar.getTime());
        }
        StringBuilder stringBuilder = new StringBuilder(200);
        StringBuilder stringBuilder2 = new StringBuilder(200);
        StringBuilder stringBuilder3 = new StringBuilder(200);
        CalendarData calendarData = CalendarFactory.getCalendarData(this.calDB, this.arg1, this.arg2, this.arg3, this.arg4);
        boolean bl2 = false;
        while (calendar.compareTo(calendar2) <= 0) {
            object = calendar.getTime();
            stringArray[0] = simpleDateFormat3.format((Date)object);
            if (calendarData.isContainedToday(calendar, n)) {
                stringBuilder.append(BLUE_COLOR);
                stringBuilder2.append(BLUE_COLOR);
                stringBuilder3.append('0');
                stringArray[1] = "0";
                bl2 = true;
            }
            if (!bl2 && n == 1 && calendarData.isHoliday(calendar) && !bl) {
                stringBuilder.append(RED_COLOR);
                stringBuilder2.append(RED_COLOR);
                stringBuilder3.append('1');
                stringArray[1] = "1";
                bl2 = true;
            }
            stringBuilder.append(DIV_ZOOMHEADER2);
            stringBuilder2.append(DIV_ZOOMHEADER2);
            stringBuilder.append(simpleDateFormat.format((Date)object));
            stringBuilder2.append(simpleDateFormat2.format((Date)object));
            stringBuilder.append(END_DIV);
            stringBuilder2.append(END_DIV);
            if (bl2) {
                stringBuilder.append(END_SPAN);
                stringBuilder2.append(END_SPAN);
                bl2 = false;
            } else {
                stringBuilder3.append('0');
                stringArray[1] = "0";
            }
            if (bl) {
                calendar.add(2, n);
            } else {
                calendar.add(5, n);
            }
            object = calendar.getTime();
            stringArray[2] = simpleDateFormat3.format((Date)object);
            arrayList.add((String[])stringArray.clone());
        }
        object = (ViewFormTag)GanttHeaderTag.findAncestorWithClass((Tag)this, ViewFormTag.class);
        ((ViewFormTag)((Object)object)).setViewArrayList(arrayList);
        this.calStr = stringBuilder3.toString();
        return stringBuilder.toString() + BR + stringBuilder2.toString();
    }

    private String makeHeaderData() {
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append(CR).append("<ganttHeader style='display:none' id='ganttHeaderData' class='ganttHeaderData' ").append("startDate='").append(this.startDate).append("' endDate='").append(this.endDate).append("' zoom='").append(this.zoom).append("' daySpan='").append(this.daySpan).append("' calDB='").append(this.calStr).append("' breakTimes='").append(this.breakTimes).append("' baseTimes='").append(this.baseTimes).append("' skipHoliday='").append(this.skipHoliday).append("' useMultiClm='").append(this.useMultiClm).append("' />");
        return stringBuilder.toString();
    }

    public void setStartDate(String string) {
        this.startDate = StringUtil.nval((String)this.getRequestParameter(string), (String)this.startDate);
    }

    public void setEndDate(String string) {
        this.endDate = StringUtil.nval((String)this.getRequestParameter(string), (String)this.endDate);
    }

    public void setDaySpan(String string) {
        String string2;
        String string3;
        this.daySpan = StringUtil.nval((String)this.getRequestParameter(string), (String)this.daySpan);
        if (this.daySpan.length() == 5 && this.daySpan.charAt(2) == '-') {
            string3 = this.daySpan.substring(0, 2) + "00";
            string2 = this.daySpan.substring(3) + "00";
        } else if (this.daySpan.length() == 9 && this.daySpan.charAt(4) == '-') {
            string3 = this.daySpan.substring(0, 2) + "00";
            string2 = this.daySpan.substring(5);
        } else {
            String string4 = "\uff11\u65e5\u306e\u958b\u59cb\u7d42\u4e86\u6642\u9593\u306f24\u6642\u9593\u5236\u3067(HHmm-HHmm \u307e\u305f\u306f HH-HH)\u5f62\u5f0f\u3067\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002 value=[" + string + "] daySpan=[" + this.daySpan + "]";
            throw new HybsSystemException(string4);
        }
        if (string3.compareTo(string2) >= 0) {
            string2 = String.valueOf(Integer.parseInt(string2) + 2400);
        }
        this.daySpan = string3 + "-" + string2;
    }

    public void setZoom(String string) {
        String string2 = StringUtil.nval((String)this.getRequestParameter(string), null);
        this.zoom = "DAY".equalsIgnoreCase(string2) ? 40 : ("WEEK".equalsIgnoreCase(string2) ? 41 : ("MONTH".equalsIgnoreCase(string2) ? 42 : StringUtil.nval((String)string2, (int)this.zoom)));
        if (this.zoom < 0 || 13 < this.zoom && this.zoom < 20 || 31 < this.zoom && this.zoom < 40 || 42 < this.zoom) {
            String string3 = "\u30ba\u30fc\u30e0\u5909\u6570\u306f\u3001(0\uff5e9,10,11,12,20\uff5e31,40\uff5e42)\u306e\u7bc4\u56f2\u3067\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002 zoom=[" + string + "]";
            throw new HybsSystemException(string3);
        }
    }

    public void setCalDB(String string) {
        this.calDB = StringUtil.nval((String)this.getRequestParameter(string), (String)this.calDB);
    }

    public void setBreakTimes(String string) {
        this.breakTimes = StringUtil.nval((String)this.getRequestParameter(string), null);
    }

    public void setBreakTimeStyle(String string) {
        this.breakTimeStyle = StringUtil.nval((String)this.getRequestParameter(string), (String)this.breakTimeStyle);
    }

    public void setBaseTimes(String string) {
        this.baseTimes = StringUtil.nval((String)this.getRequestParameter(string), null);
    }

    public void setBaseTimeStyle(String string) {
        this.baseTimeStyle = StringUtil.nval((String)this.getRequestParameter(string), (String)this.baseTimeStyle);
    }

    public void setArg1(String string) {
        this.arg1 = StringUtil.nval((String)this.getRequestParameter(string), (String)this.arg1);
    }

    public void setArg2(String string) {
        this.arg2 = StringUtil.nval((String)this.getRequestParameter(string), (String)this.arg2);
    }

    public void setArg3(String string) {
        this.arg3 = StringUtil.nval((String)this.getRequestParameter(string), (String)this.arg3);
    }

    public void setArg4(String string) {
        this.arg4 = StringUtil.nval((String)this.getRequestParameter(string), (String)this.arg4);
    }

    public void setSkipHoliday(String string) {
        this.skipHoliday = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.skipHoliday);
    }

    public void setUseMultiClm(String string) {
        this.useMultiClm = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useMultiClm);
    }

    private static int hm2int(String string) {
        int n = -1;
        if (string != null) {
            int n2 = string.length();
            String string2 = null;
            String string3 = null;
            if (n2 == 4 || n2 == 6) {
                string2 = string.substring(0, 2);
                string3 = string.substring(2, 4);
            } else if (n2 == 12 || n2 == 14) {
                string2 = string.substring(8, 10);
                string3 = string.substring(10, 12);
            } else {
                String string4 = "\u6307\u5b9a\u3067\u304d\u308b\u6642\u9593\u5f62\u5f0f\u306f\u3001HHmm \u3001HHmmss \u3001yyyyMMddHHmm \u3001yyyyMMddHHmmss \u3067\u3059\u3002" + CR + "hm2int=[" + string + "]";
                throw new HybsSystemException(string4);
            }
            n = (int)((double)(Integer.parseInt(string2) * 100) + (double)Integer.parseInt(string3) * 10.0 / 6.0);
        }
        return n;
    }

    @Override
    public String toString() {
        return ToString.title((String)((Object)((Object)this)).getClass().getName()).println("VERSION", (Object)VERSION).println("startDate", (Object)this.startDate).println("endDate", (Object)this.endDate).println("daySpan", (Object)this.daySpan).println("zoom", (Object)this.zoom).println("breakTimes", (Object)this.breakTimes).println("breakTimeStyle", (Object)this.breakTimeStyle).println("baseTimes", (Object)this.baseTimes).println("baseTimeStyle", (Object)this.baseTimeStyle).println("calDB", (Object)this.calDB).println("arg1", (Object)this.arg1).println("arg2", (Object)this.arg2).println("arg3", (Object)this.arg3).println("arg4", (Object)this.arg4).println("skipHoliday", (Object)this.skipHoliday).println("TIME_PIXEL", (Object)48).println("Other...", (Object)this.getAttributes().getAttribute()).fixForm().toString();
    }

    private static final class BreakTimes {
        private final List<BreakTimeData> timeList = new ArrayList<BreakTimeData>();
        private final int hourOfPixcel;
        private final String breakTimeStyle;
        private final int viewStartTime;
        private final int viewEndTime;

        BreakTimes(int n, String string, String string2, int n2, int n3) {
            this.hourOfPixcel = n;
            this.breakTimeStyle = string2 == null ? "" : string2;
            this.viewStartTime = n2;
            this.viewEndTime = n3;
            boolean bl = this.viewEndTime > 2400;
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd", Locale.JAPAN);
            for (String string3 : StringUtil.csv2Array((String)string)) {
                int n4;
                int n5;
                String string4;
                String string5;
                String string6;
                if (string3 == null) continue;
                int n6 = string3.indexOf(45);
                if (n6 > 0) {
                    string6 = string3.substring(0, n6);
                    String string7 = string3.substring(n6 + 1);
                    string5 = string6.length() >= 8 ? string6.substring(0, 8) : null;
                    string4 = string7.length() >= 8 ? string7.substring(0, 8) : null;
                    n5 = GanttHeaderTag.hm2int(string6);
                    n4 = GanttHeaderTag.hm2int(string7);
                } else {
                    string6 = string3;
                    string5 = string6.length() >= 8 ? string6.substring(0, 8) : null;
                    string4 = null;
                    n5 = GanttHeaderTag.hm2int(string6);
                    n4 = n5 + 1;
                }
                Calendar calendar = null;
                Calendar calendar2 = null;
                if (string5 != null) {
                    calendar = HybsDateUtil.getCalendar((String)string5);
                }
                if (string4 != null) {
                    calendar2 = HybsDateUtil.getCalendar((String)string4);
                }
                if (bl) {
                    if (n5 < this.viewEndTime - 2400) {
                        if (calendar != null) {
                            calendar.add(5, -1);
                            string5 = simpleDateFormat.format(calendar.getTime());
                        }
                        n5 += 2400;
                    }
                    if (n4 <= this.viewEndTime - 2400) {
                        if (calendar2 != null) {
                            calendar2.add(5, -1);
                            string4 = simpleDateFormat.format(calendar2.getTime());
                        }
                        n4 += 2400;
                    }
                }
                if (n5 < this.viewStartTime) {
                    n5 = this.viewStartTime;
                }
                if (n5 > this.viewEndTime) {
                    n5 = this.viewEndTime;
                }
                if (n4 < this.viewStartTime) {
                    n4 = this.viewStartTime;
                }
                if (n4 > this.viewEndTime) {
                    n4 = this.viewEndTime;
                }
                int n7 = n4 - n5;
                String string8 = string3;
                if (n7 >= 0 && (string4 == null || string5 != null && string5.equals(string4))) {
                    n7 = n4 - n5;
                    this.timeList.add(new BreakTimeData(string5, n5, n7, string8));
                    continue;
                }
                n7 = this.viewEndTime - n5;
                this.timeList.add(new BreakTimeData(string5, n5, n7, string8));
                n7 = n4 - this.viewStartTime;
                this.timeList.add(new BreakTimeData(string4, this.viewStartTime, n7, string8));
                n7 = this.viewEndTime - this.viewStartTime;
                if (calendar == null || calendar2 == null) continue;
                calendar.add(5, 1);
                while (calendar.before(calendar2)) {
                    Date date = calendar.getTime();
                    string6 = simpleDateFormat.format(date);
                    this.timeList.add(new BreakTimeData(string6, this.viewStartTime, n7, string8));
                    calendar.add(5, 1);
                }
            }
        }

        String makeSpan(int n, Calendar calendar, int n2, int n3) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd", Locale.JAPAN);
            String string = simpleDateFormat.format(calendar.getTime());
            StringBuilder stringBuilder = new StringBuilder(200);
            int n4 = this.timeList.size();
            for (int i = 0; i < n4; ++i) {
                BreakTimeData breakTimeData = this.timeList.get(i);
                if (!breakTimeData.startsWith(string, n2, n3)) continue;
                stringBuilder.append(breakTimeData.getBreakTime(n, this.hourOfPixcel, this.breakTimeStyle));
            }
            String string2 = null;
            if (stringBuilder.length() > 0) {
                string2 = stringBuilder.toString();
            }
            return string2;
        }
    }

    private static final class BreakTimeData {
        private final String startDay;
        private final int startTime;
        private final int timeSpan;
        private final String viewTime;

        BreakTimeData(String string, int n, int n2, String string2) {
            this.startDay = string;
            this.startTime = n;
            this.timeSpan = n2;
            this.viewTime = string2;
        }

        boolean startsWith(String string, int n, int n2) {
            return this.timeSpan > 0 && n <= this.startTime && this.startTime < n + 100 * n2 && (this.startDay == null || string.equals(this.startDay));
        }

        String getBreakTime(int n, int n2, String string) {
            int n3 = n + this.startTime * n2 / 100;
            int n4 = this.timeSpan * n2 / 100;
            if (n4 == 0) {
                n4 = 2;
            }
            return "<span class=\"breaktime\" title=\"" + this.viewTime + "\" style=\"position:absolute;z-index:100;height:500000px;left:" + n3 + "px;width:" + n4 + "px;" + string + "\" ></span>" + CommonTagSupport.CR;
        }
    }
}

