﻿/**
	CLEditorのカスタマイズ
	下記の処理を実施
	・ツールバーの日本語化
	・ツールバー空白箇所のツールチップ表示
	・特殊文字のエンコード
*/

(function($)
{
	// アイコンツールチップの日本語化
	$.cleditor.buttons.bold.title = '太字';
	$.cleditor.buttons.size.title = 'フォントサイズ';
	$.cleditor.buttons.color.title = 'フォントの色';
	$.cleditor.buttons.highlight.title = '背景色';
	$.cleditor.buttons.removeformat.title = '書式の削除';
	$.cleditor.buttons.undo.title = '元に戻す'
	$.cleditor.buttons.redo.title = 'やり直し'
	$.cleditor.buttons.italic.title = '斜体'
	$.cleditor.buttons.underline.title = '下線'
	$.cleditor.buttons.strikethrough.title = '打ち消し線'
	$.cleditor.buttons.style.title = 'スタイル'
	$.cleditor.buttons.bullets.title = '箇条書き'
	$.cleditor.buttons.numbering.title = '段落番号'
	$.cleditor.buttons.outdent.title = 'インデントを減らす'
	$.cleditor.buttons.indent.title = 'インデントを増やす'
	$.cleditor.buttons.alignleft.title = '左揃え'
	$.cleditor.buttons.center.title = '中央揃え'
	$.cleditor.buttons.alignright.title = '右揃え'
	$.cleditor.buttons.justify.title = '両端揃え'
	$.cleditor.buttons.link.title = 'リンク'
	$.cleditor.buttons.unlink.title = 'リンクを削除'
	$.cleditor.buttons.source.title = 'ソース表示';
	$.cleditor.buttons.cut.title = '切り取り';
	$.cleditor.buttons.copy.title = 'コピー';
	$.cleditor.buttons.paste.title = '貼り付け';
	$.cleditor.buttons.print.title = '印刷';

    // メニューツールチップの表示
	$(function(){
		$('div.cleditorToolbar').attr('title','IEでの改行：Ctrl+Enter');
	});


	// 特殊文字のエンコード
	$.cleditor.defaultOptions.updateTextArea = function(html)
	{
		return $.cleditor.convertHTMLtoTextArea(html);
	}

	$.cleditor.convertHTMLtoTextArea = function(html)
	{
		$.each([
				[/</g, "&lt;"],
				[/>/g, "&gt;"]
			],
			function(index, item)
			{
				// Keep running the replace untill all matches are
				// replaced. Needed for the nested bbcodes.
				var oldHtml=html;

				while((html = html.replace(item[0],item[1])) != oldHtml)
					oldHtml=html;
			});

		return html;
	}
})(jQuery);