<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" useRealTimeCheck="false" >
	<!-- 2017/04/20 MOD ﾘｸｴｽﾄﾊﾟﾗﾒｰﾀに[&GAMENID=21_WHTSNEWV]を追加 -->
	<script type="text/javascript">//<![CDATA[
	function popup_window(arg1){
		tmp = "meisai.jsp?command=NEW&GAMENID=21_WHTSNEWV&UNIQ=" + arg1;
		window.open(tmp, '', 'width=830,height=400,scrollbars=yes');
		return false;
	}
	//]]>
	</script>
</og:head>

<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GE:エンジン標準"
	pgid	= "WHTSNEW"
	title	= "標準(新着情報登録)"
	date	= "2012/01/10"
	author	= "Son.I"
	text	= ""
	version	= "001"
/>

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<!-- 入力チェック -->
<!-- nullCheckの記述は不要です。columnのチェックを行う場合は、個別に記述する必要があります -->
<og:columnCheck command = "{@command}" />

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command="{@command}" />

<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->
<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}" dbid="RESOURCE">
	<!-- DB登録時に使用する USRSET カラムを、DBTableModel に設定しておきます。-->
		SELECT	 SYSTEM_ID												<!-- ｼｽﾃﾑID-->
				,SYSCODE												<!-- ｼｽﾃﾑｺｰﾄﾞ-->
				,UNIQ													<!-- 文書番号-->
				,CDDEG													<!-- 重要度-->
				,TITLE													<!-- ﾀｲﾄﾙ-->
				,{@DBF.SUBSTR}(NAIYO,1,100)	GAIYO							<!-- 概要-->
				,NAIYO													<!-- 内容-->
				,BUSHOD													<!-- 掲載部署-->
				,MAND													<!-- 掲載者-->
				,DYSTRD													<!-- 掲載開始日-->
				,DYENDD													<!-- 掲載終了日-->
				,FGJ													<!-- (非表示)状況-->
				,TEL													<!-- (非表示)電話番号-->
				,MAILAD													<!-- (非表示)ﾒｰﾙｱﾄﾞﾚｽ-->
				,FILE1													<!-- (非表示)ﾌｧｲﾙ1-->
				,FILE2													<!-- (非表示)ﾌｧｲﾙ2-->
				,FILE3													<!-- (非表示)ﾌｧｲﾙ3-->
				,TAG													<!-- (非表示)ﾀｸﾞｷｰﾜｰﾄﾞ-->
				,FILEPATH												<!-- (非表示)ﾌｧｲﾙﾊﾟｽ-->
		FROM	GE81
	<og:where>
		<og:and value = "SYSTEM_ID	=	'{@SYS.SYSTEM_ID}'"			/>	<!-- GE81》ｼｽﾃﾑID = 画面》ｼｽﾃﾑID		-->
		<og:and value = "SYSCODE	IN	('{@USER.SYSCODE}','*')"			/>	<!-- GE81》ｼｽﾃﾑｺｰﾄﾞ = ﾕｰｻﾞｰ》ｼｽﾃﾑｺｰﾄﾞ	-->
		<og:and value = "CDDEG		=	'{@CDDEG}'"					/>	<!-- GE81》重要度 = 画面》重要度		-->
		<og:and value = "BUSHOD		LIKE	'{@BUSHOD}'"			/>	<!-- GE81》掲載部門	LIKE %画面》掲載部門%-->
		<og:and value = "FGJ	IN		('0','1')"					/>	<!-- GE81》状況 IN ('0','1')-->
		<og:equals val1="{@CHECK}" val2="1">
			<og:and value = "DYENDD &gt;= '{@USER.YMD}'"			/>	<!-- GE81》掲載完了日 ≧ ｼｽﾃﾑ日付-->
		</og:equals>
		<og:and value = "TITLE				LIKE	'{@TITLE}'"		/>	<!-- GE81》ﾀｲﾄﾙ LIKE %画面》ﾀｲﾄﾙ%-->
		<og:and value = "DYENDD				&gt;=	'{@DYKEIF}'"	/>	<!-- GE81》掲載開始日 ≧ 画面》掲載日(FROM)-->
		<og:and value = "DYSTRD				&lt;=	'{@DYKEIT}'"	/>	<!-- GE81》掲載開始日 ≦ 画面》掲載日(TO)-->
		<og:and value = "MAND				LIKE	'{@MAND}'"		/>	<!-- GE81》掲載者 LIKE %画面》掲載者%-->
		<og:and value = "(TITLE				LIKE	'{@KEYWORD}'	OR
						  NAIYO				LIKE	'{@KEYWORD}'	OR
						  TAG				LIKE	'{@KEYWORD}')"	/>	<!-- GE81》ﾀｲﾄﾙ､内容､ﾀｸﾞｷｰﾜｰﾄﾞ LIKE %画面》ｷｰﾜｰﾄﾞ%-->
	</og:where>
	<og:appear startKey = "ORDER BY" value = "{@ORDER_BY}"
				defaultVal = "DYSTRD DESC,UNIQ DESC" />						<!-- 掲載開始日(降順),UNIQ(降)	-->
</og:query>

<!-- ColumnEditorTag は、指定のカラム属性を設定しなおします。 -->
<og:columnEditor columns="UNIQ" label="MSG0081"/>
<og:columnEditor columns="FILE1,FILE2,FILE3" size="10"/>
<!-- <og:columnEditor columns="NAIYO" renderer="SLABEL" param="20" /> -->
<og:columnEditor columns="GAIYO" renderer="SLABEL" param="20" label="GAIYO1"/>
<og:columnEditor columns="TAG" editor="INDBMENU" dbid="RESOURCE"
	param="SELECT TAG,TAG NAME_A FROM GE81 WHERE FGJ IN ('0','1') AND TAG IS NOT NULL GROUP BY TAG"/>

<!-- ﾀｲﾄﾙ-->
<!--
<og:viewLink command="{@command}">
	<og:link column="TITLE" gamenId="21_WHTSNEWV" href="meisai.jsp" target="_blank"
		keys="command,UNIQ"	vals="NEW,[UNIQ]" />
</og:viewLink>
-->
<!-- ﾀｲﾄﾙ -->
<og:viewMarker command="NEW">
	<og:columnMarker column="TITLE">
		<og:link column="TITLE" href="#" onClick="popup_window([UNIQ]);"/>
	</og:columnMarker>
</og:viewMarker>

<!-- formタグでリクエストフィールドを囲います。oneClick()関数は、２重押し防止JavaScriptです。 -->
<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">

<!-- 複写、変更、削除ボタンを作成します。value属性+.jspの画面に制御が移ります。 -->
<!-- このとき、command=(value属性の値の大文字)が設定されます。 command属性で設定しなおすことも出来ます。-->
<!-- ここでは、すべてを、update.jsp に転送している為、command属性を設定しています。-->
<og:writeCheck>
	<og:submit	action="COPY"	noWritable="UNIQ" />
	<og:submit	action="MODIFY"	noWritable="UNIQ" />
	<og:submit	action="DELETE"	columnWritable="null" />
<br />
</og:writeCheck>

<!-- DB検索結果を表示させます。 -->
<!-- checked="true" で、チェック済みの状態で表示できます。 -->
<!-- selectedType="checkbox(デフォルト)/radio/hidden" から、選べます。-->
<og:view
	viewFormType = "HTMLTable" 
	command		 = "{@command}" 
	noDisplay	 = "SYSTEM_ID,SYSCODE,FGJ,NAIYO,MAILAD,TEL,FILE1,FILE2,FILE3,TAG,FILEPATH"
	selectedType = "radio"  />
<og:hidden name="SYSCODE" defaultVal="*" value="{@USER.SYSCODE}" />

</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
