/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.taglib;

import java.util.Set;
import javax.servlet.jsp.tagext.Tag;
import org.opengion.fukurou.util.ArraySet;
import org.opengion.fukurou.util.ColorMap;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.ToString;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.io.JsChartData;
import org.opengion.hayabusa.taglib.CommonTagSupport;
import org.opengion.hayabusa.taglib.JsChartTag;

public class JsChartDataTag
extends CommonTagSupport {
    private static final String VERSION = "6.9.9.2 (2018/09/18)";
    private static final long serialVersionUID = 699220180918L;
    private static final Set<String> TYPE_BOOLEAN = new ArraySet((Object[])new String[]{"true", "false"});
    private String chartColumn;
    private String label;
    private String fill = "false";
    private String tension = "0.4";
    private String borderColor;
    private String borderWidth;
    private String backgroundColor;
    private String pointStyle;
    private String pointRadius;
    private String showLine;
    private String optionAttributes;

    @Override
    public int doEndTag() {
        this.debugPrint();
        if (!this.useTag()) {
            return 6;
        }
        JsChartTag jsChartTag = (JsChartTag)JsChartDataTag.findAncestorWithClass((Tag)this, JsChartTag.class);
        if (jsChartTag == null) {
            throw new HybsSystemException("jsChart \u30bf\u30b0\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
        }
        if (this.borderColor == null || this.borderColor.isEmpty()) {
            int n = jsChartTag.getJsChartDataSize();
            String[] stringArray = ColorMap.getColorKeys();
            this.borderColor = stringArray[n % stringArray.length];
        }
        if (this.backgroundColor == null || this.backgroundColor.isEmpty()) {
            this.backgroundColor = this.borderColor;
        }
        JsChartData jsChartData = new JsChartData();
        jsChartData.setChartColumn(this.chartColumn);
        jsChartData.setLabel(this.label);
        jsChartData.setFill(this.fill);
        jsChartData.setTension(this.tension);
        jsChartData.setBorderColor(this.borderColor);
        jsChartData.setBorderWidth(this.borderWidth);
        jsChartData.setBackgroundColor(this.backgroundColor);
        jsChartData.setPointStyle(this.pointStyle);
        jsChartData.setPointRadius(this.pointRadius);
        jsChartData.setShowLine(this.showLine);
        jsChartData.setOptionAttributes(this.optionAttributes);
        jsChartTag.addJsChartData(jsChartData);
        return 6;
    }

    @Override
    protected void release2() {
        super.release2();
        this.chartColumn = null;
        this.label = null;
        this.fill = "false";
        this.tension = "0.4";
        this.borderColor = null;
        this.borderWidth = null;
        this.backgroundColor = null;
        this.pointStyle = null;
        this.pointRadius = null;
        this.showLine = null;
        this.optionAttributes = null;
    }

    public void setChartColumn(String string) {
        this.chartColumn = StringUtil.nval((String)this.getRequestParameter(string), (String)this.chartColumn);
    }

    public void setLabel(String string) {
        this.label = StringUtil.nval((String)this.getRequestParameter(string), (String)this.label);
    }

    public void setFill(String string) {
        this.fill = StringUtil.nval((String)this.getRequestParameter(string), (String)this.fill);
        this.checkPara(this.fill, TYPE_BOOLEAN, "fill");
    }

    public void setTension(String string) {
        this.tension = StringUtil.nval((String)this.getRequestParameter(string), (String)this.tension);
    }

    public void setBorderColor(String string) {
        this.borderColor = StringUtil.nval((String)this.getRequestParameter(string), (String)this.borderColor);
    }

    public void setColorNo(String string) {
        String string2;
        if (this.borderColor == null && (string2 = StringUtil.nval((String)this.getRequestParameter(string), null)) != null) {
            try {
                int n = Integer.parseInt(string2);
                String[] stringArray = ColorMap.getColorKeys();
                this.borderColor = stringArray[n % stringArray.length];
            }
            catch (NumberFormatException numberFormatException) {
                String string3 = "colorNo \u3092\u6570\u5024\u306b\u5909\u63db\u3067\u304d\u307e\u305b\u3093\u3002colorNo=" + string2;
                throw new HybsSystemException(string3, numberFormatException);
            }
        }
    }

    public void setBorderWidth(String string) {
        this.borderWidth = StringUtil.nval((String)this.getRequestParameter(string), (String)this.borderWidth);
    }

    public void setBackgroundColor(String string) {
        this.backgroundColor = StringUtil.nval((String)this.getRequestParameter(string), (String)this.backgroundColor);
        if ("PASTEL".equalsIgnoreCase(this.backgroundColor)) {
            this.backgroundColor = "['" + String.join((CharSequence)"','", ColorMap.getPastelColorKeys()) + "']";
        }
    }

    public void setPointStyle(String string) {
        this.pointStyle = StringUtil.nval((String)this.getRequestParameter(string), (String)this.pointStyle);
    }

    public void setPointRadius(String string) {
        this.pointRadius = StringUtil.nval((String)this.getRequestParameter(string), (String)this.pointRadius);
    }

    public void setShowLine(String string) {
        this.showLine = StringUtil.nval((String)this.getRequestParameter(string), (String)this.showLine);
    }

    public void setOptionAttributes(String string) {
        this.optionAttributes = StringUtil.nval((String)this.getRequestParameter(string), (String)this.optionAttributes);
    }

    private void checkPara(String string, Set<String> set, String string2) {
        if (string != null && string.length() > 0 && !this.check(string, set)) {
            StringBuilder stringBuilder = new StringBuilder(200).append("\u6307\u5b9a\u306e").append(string2).append("\u306f\u6307\u5b9a\u3067\u304d\u307e\u305b\u3093\u3002").append(CR).append(string2).append("=[").append(string).append(']').append(CR);
            for (String string3 : set) {
                stringBuilder.append(" | ").append(string3);
            }
            throw new HybsSystemException(stringBuilder.toString());
        }
    }

    @Override
    public String toString() {
        return ToString.title((String)((Object)((Object)this)).getClass().getName()).println("VERSIION", (Object)VERSION).println("chartColumn", (Object)this.chartColumn).println("label", (Object)this.label).println("fill", (Object)this.fill).println("tension", (Object)this.tension).println("borderColor", (Object)this.borderColor).println("borderWidth", (Object)this.borderWidth).println("backgroundColor", (Object)this.backgroundColor).println("optionAttributes", (Object)this.optionAttributes).fixForm().toString();
    }
}

