/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.io;

import java.awt.Color;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jfree.data.Range;
import org.jfree.data.category.DefaultCategoryDataset;
import org.opengion.fukurou.db.ResultSetValue;
import org.opengion.fukurou.system.HybsConst;
import org.opengion.fukurou.system.LogWriter;
import org.opengion.fukurou.util.ColorMap;
import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.hayabusa.io.HybsDataset;

public class HybsCategoryDataset
extends DefaultCategoryDataset
implements HybsDataset {
    private static final long serialVersionUID = 602220141003L;
    private final Set<String> cateCheck = new HashSet<String>();
    private final int hsCode = Long.valueOf(System.nanoTime()).hashCode();
    private String[] seriesLabels;
    private boolean isColorCategory;
    private boolean isParetoData;
    private Number[][] numdata;
    private Color[] categoryColor;
    private Range range = new Range(0.0, 0.0);

    @Override
    public void initParam(String[] stringArray, boolean bl, boolean bl2) {
        if (stringArray != null) {
            this.seriesLabels = (String[])stringArray.clone();
        }
        this.isColorCategory = bl;
        this.isParetoData = bl2;
    }

    @Override
    public void execute(Connection connection, String string) throws SQLException {
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.NEGATIVE_INFINITY;
        double d3 = 0.0;
        ArrayList<Serializable> arrayList = null;
        try (Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery(string);){
            statement.setFetchSize(251);
            ResultSetValue resultSetValue = new ResultSetValue(resultSet);
            int n = resultSetValue.getColumnCount() - 1;
            if (this.isColorCategory) {
                arrayList = new ArrayList<Serializable>();
                --n;
            }
            if (n < 1) {
                String string2 = "JDBCCategoryDataset.executeQuery() : insufficient columns returned from the database. \n SQL=" + string;
                throw new SQLException(string2);
            }
            if (this.seriesLabels != null && this.seriesLabels.length < n) {
                String string3 = "seriesLabels \u3092\u4f7f\u7528\u3059\u308b\u5834\u5408\u306f\u3001\u5fc5\u305a\u30b7\u30ea\u30fc\u30ba\u6570\u4ee5\u4e0a\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002" + HybsConst.CR + " seriesLabels=" + Arrays.toString(this.seriesLabels) + HybsConst.CR + " seriesLabels.length=" + this.seriesLabels.length + " dataSize=" + n + HybsConst.CR;
                throw new IllegalArgumentException(string3);
            }
            String[] stringArray = new String[n];
            String[] stringArray2 = resultSetValue.getNames();
            for (int i = 0; i < n; ++i) {
                stringArray[i] = this.seriesLabels == null || this.seriesLabels[i] == null ? stringArray2[i + 1] : this.seriesLabels[i];
            }
            ArrayList<Number[]> arrayList2 = new ArrayList<Number[]>();
            while (resultSetValue.next()) {
                Serializable serializable;
                Number[] numberArray = new Number[n];
                String string4 = this.uniqCategory(resultSet.getString(1));
                for (int i = 0; i < n; ++i) {
                    serializable = null;
                    try {
                        serializable = resultSetValue.getNumber(i + 1);
                    }
                    catch (SQLException sQLException) {
                        LogWriter.log((Throwable)sQLException);
                    }
                    catch (RuntimeException runtimeException) {
                        LogWriter.log((Throwable)runtimeException);
                    }
                    numberArray[i] = serializable;
                    this.addValue((Number)serializable, (Comparable)((Object)stringArray[i]), (Comparable)((Object)string4));
                    if (serializable == null) continue;
                    double d4 = ((Number)serializable).doubleValue();
                    if (this.isParetoData) {
                        d3 += d4;
                        continue;
                    }
                    if (d4 < d) {
                        d = d4;
                    }
                    if (!(d2 < d4)) continue;
                    d2 = d4;
                }
                arrayList2.add(numberArray);
                if (!this.isColorCategory) continue;
                String string5 = resultSetValue.getValue(n + 1);
                serializable = ColorMap.getColorInstance((String)string5);
                arrayList.add(serializable);
            }
            if (arrayList2.isEmpty()) {
                return;
            }
            this.numdata = (Number[][])arrayList2.toArray((T[])new Number[n][arrayList2.size()]);
        }
        if (this.isColorCategory && arrayList != null) {
            this.categoryColor = arrayList.toArray(new Color[arrayList.size()]);
        }
        if (this.isParetoData) {
            this.changeParetoData(d3);
            d = 0.0;
            d2 = 100.0;
        }
        this.range = new Range(d, d2);
    }

    @Override
    public void execute(DBTableModel dBTableModel) {
        if (dBTableModel == null || dBTableModel.getRowCount() == 0) {
            return;
        }
        int n = dBTableModel.getColumnCount();
        int n2 = dBTableModel.getRowCount();
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.NEGATIVE_INFINITY;
        double d3 = 0.0;
        int n3 = n - 1;
        ArrayList<Object> arrayList = null;
        if (this.isColorCategory) {
            arrayList = new ArrayList<Object>();
            --n3;
        }
        this.numdata = new Number[n2][n];
        for (int i = 0; i < n2; ++i) {
            Object object;
            String string = this.uniqCategory((String)dBTableModel.getValue(i, 0));
            String[] stringArray = (String[])dBTableModel.getValues(i);
            for (int j = 0; j < n3; ++j) {
                object = stringArray[j + 1];
                double d4 = object == null || ((String)object).isEmpty() ? 0.0 : Double.parseDouble((String)object);
                this.addValue(d4, (Comparable)((Object)this.seriesLabels[j]), (Comparable)((Object)string));
                this.numdata[i][j] = d4;
                if (this.isParetoData) {
                    d3 += d4;
                    continue;
                }
                if (d4 < d) {
                    d = d4;
                }
                if (!(d2 < d4)) continue;
                d2 = d4;
            }
            if (!this.isColorCategory) continue;
            String string2 = stringArray[n3 + 1];
            object = ColorMap.getColorInstance((String)string2);
            arrayList.add(object);
        }
        if (this.isColorCategory && arrayList != null) {
            this.categoryColor = arrayList.toArray(new Color[arrayList.size()]);
        }
        if (this.isParetoData) {
            this.changeParetoData(d3);
            d = 0.0;
            d2 = 100.0;
        }
        this.range = new Range(d, d2);
    }

    public Number getValue(int n, int n2) {
        return this.numdata[n2][n];
    }

    @Override
    public Range getRange() {
        return this.range;
    }

    private void changeParetoData(double d) {
        if (this.numdata == null || this.numdata.length == 0 || this.numdata[0].length == 0 || d == 0.0) {
            return;
        }
        int n = this.numdata[0].length;
        int n2 = this.numdata.length;
        for (int i = 0; i < n; ++i) {
            double d2 = 0.0;
            for (int j = 0; j < n2; ++j) {
                Number number = this.numdata[j][i];
                if (number != null) {
                    d2 += number.doubleValue();
                }
                this.numdata[j][i] = (double)Math.round(d2 * 1000.0 / d) / 10.0;
            }
        }
    }

    @Override
    public Color[] getCategoryColor() {
        return this.categoryColor == null ? null : (Color[])this.categoryColor.clone();
    }

    private String uniqCategory(String string) {
        Object object = string;
        int n = 0;
        while (!this.cateCheck.add((String)object)) {
            object = string + "(" + n++ + ")";
        }
        return object;
    }

    public boolean equals(Object object) {
        return super.equals(object) && this.hsCode == ((HybsCategoryDataset)object).hsCode;
    }

    public int hashCode() {
        return this.hsCode;
    }
}

