/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.hayabusa.html;

import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.hayabusa.resource.ResourceManager;



/**
 * JSONをテーブルモデルに変換するJsonReader_xxxのインタフェイスです。
 *
 *
 * @og.group 画面表示
 * @og.rev 5.9.21.0 (2017/06/02) 新規作成
 *
 * @version  4.0
 * @author	 Takahashi Masakazu
 * @since    JDK5.0,
 */
public interface JsonReader {
	
	/**
	 * JSON文字列からDBTableModelを作成します。
	 *
	 *
	 * @param   json JSON文字列
	 */
	void readDBTable( final String json ) ;
	
	/**
	 * リソースマネージャーをセットします。
	 * これは、言語(ロケール)に応じた DBColumn をあらかじめ設定しておく為に
	 * 必要です。
	 * リソースマネージャーが設定されていない、または、所定のキーの DBColumn が
	 * リソースに存在しない場合は、内部で DBColumn オブジェクトを作成します。
	 *
	 *
	 * @param  resource リソースマネージャー
	 */
	void setResourceManager( final ResourceManager resource ) ;
	
	/**
	 * 内部の DBTableModel を返します。
	 *
	 * @return	テーブルモデル
	 */
	 DBTableModel getDBTableModel();
	
	/**
	 * DBTableModelのデータとして登録する最大件数をこの値に設定します。
	 * サーバーのメモリ資源と応答時間の確保の為です。
	 *
	 * @return  最大検索件数
	 */
	int getMaxRowCount() ;

	/**
	 * DBTableModelのデータとして登録する最大件数をこの値に設定します。
	 * サーバーのメモリ資源と応答時間の確保の為です。
	 *
	 * @param   maxRowCount 最大検索件数
	 */
	void setMaxRowCount( final int maxRowCount ) ;
	
	/**
	 * データの読み飛ばし件数を設定します。
	 *
	 * JSON形式の場合、通常は読み飛ばし不要です。
	 *
	 *
	 * @param	count 読み始めの初期値
	 */
	void setSkipRowCount( final int count ) ;

	/**
	 * 読取処理でラベルをコードリソースに逆変換を行うかどうかを指定します。
	 *
	 * 
	 * ここでは、コードリソースのカラムに対して、ラベルからコードを求める逆変換を行うことで、
	 * Renderer 系で出力したデータを取り込むことができるようにします。
	 * 通常は利用しません。
	 *
	 *
	 * @param	useRenderer	コードリソースのラベル逆変換を行うかどうかを指定
	 */
	void setUseRenderer( final boolean useRenderer ) ;
	
	/**
	 * デバッグ情報を出力するかどうかを指定します。
	 *
	 * 
	 * 初期値は、false:デバッグ情報を出力しない です。
	 *
	 *
	 * @param	useDebug	デバッグ情報を出力するかどうかを指定
	 */
	void setDebug( final boolean useDebug ) ;
	
	/**
	 * 文字列をオプションで渡せるようにしておきます。
	 * 
	 * @param strings オプション文字列
	 * 
	 */
	void setOptions( final String... strings ) ;
}
