<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />
<jsp:directive.page errorPage="/jsp/common/error.jsp" />

<og:head headType="init" >
	<link rel="stylesheet" type="text/css" href="{@SYS.JSP}/menu/matrixMenu.css?v={@USER.YMDH}" />
	<style type="text/css">
		<og:equals val1="{@group}" val2="{@group}">
			table.MTRIX_GRP td.{@group} { background-color:linen; }
		</og:equals>

		<og:equals val1="{@group}" nullCheck="true" >
			table.MTRIX_GRP td.GUI_ALL { background-color:linen; }
		</og:equals>

		div.BOX_STYLE { width:210px; height:200px; vertical-align:top; }

	</style>
</og:head>

<body oncontextmenu="return false">

<jsp:directive.include file="/jsp/custom/matrix_info.jsp" />

<!-- ボタンメニューは、ここでjspInit(セッションタイムアウト対策) -->
<og:equals val1="{@menuType}" nullCheck="true">
	<og:jspInit />
</og:equals>

<!-- メニューのタイプ分け -->
<og:value command="SET" key="menuType" value="matrix" scope="session" />

<!-- グループ部分 -->
<table class="MTRIX_GRP" summary="Matrix Menu Group" >
	<og:topMenu 
		menuType	= "GROUP"
		href		= "matrixMenu.jsp" 
		target		= "_top" 
		imageOnly	= "false"
		sideCount	= "8"
		cache		= "{@cache}"
		match		= "{@match}"
		unmatch		= "{@unmatch}"
	/>
</table>

<table>
  <tr>
	<td valign="top">
		<div class="BOX_STYLE">
	<!--	<jsp:directive.include file="../custom/whats_new_top.jsp" />	-->
			<jsp:directive.include file="../common/gamen/21_WHTSNEW/top_menu.jsp" />
		</div>
		<div class="BOX_STYLE">
			<jsp:directive.include file="order_and_delivery.jsp" />
		</div>
	</td>
	<td valign="top">
		<table class="MTRIX_BTN" summary="Matrix Menu Group">
		  <og:topMenu
			menuType	= "MATRIX2"
			href		= "matrixMenu.jsp"
			target		= "_top"
			imageOnly	= "false"
			sideCount	= "6"
			cache		= "{@cache}"
			match		= "{@match}"
			unmatch		= "{@unmatch}"
			minCellCount= "4"
			maxCellCount= "20"
			groups		= "{@group}"
		  />
		</table>
	</td>
  </tr>
</table>

<jsp:directive.include file="/jsp/custom/menu_end.jsp" />

</body>
</jsp:root>
