<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:c="http://java.sun.com/jsp/jstl/core"
	xmlns:fn="http://java.sun.com/jsp/jstl/functions"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= ""
	title	= "DB相関"
	date	= "2017/04/07"
	author	= "T.OTA"
	text	= ""
	version	= "001"
/>

<jsp:directive.include file="sqlValues.jsp" />

<!-- 入力チェック -->
<og:columnCheck
	command   = "{@command}"
/>

<!--  COLUMNの連結 -->
<og:value key="COLUMN_NAME_LIST" action="APPEND" value="{@COLUMN_NAME}" />

<!-- ｶﾗﾑ(CSV)をｶﾗﾑ名(CSV)に変換 -->
<c:forEach var="str" items="${fn:split(requestScope.COLUMN_NAME_LIST,',')}">
	<c:if test="${!empty COLUMN_LABEL_LIST}">
		<og:value key="COLUMN_LABEL_LIST" value="{@COLUMN_LABEL_LIST}," />
	</c:if>
	<og:value key="COLUMN_LABEL_LIST" value="{@COLUMN_LABEL_LIST}{@LBL.${str}}" />
</c:forEach>

<!-- ｶﾗﾑ名が2つ以上選択されているかのﾁｪｯｸ -->
<og:dataCheck
	command			= "NEW"
	lbl				= "ERR0046"
	lblParamKeys	= "{@LBL.COLUMN_NAME},2">
	"{@COLUMN_NAME_LIST}".indexOf(",") >= 0
</og:dataCheck>

<!-- ﾚｺｰﾄﾞが2件以上登録されているかのﾁｪｯｸ -->
<og:dataCheck
	command			="NEW"
	lbl				= "ERR0047"
	lblParamKeys	= "2" 
	exist   		= "true">
	select DECODE(count(*),1,0,count(*))
	from {@TABLE_NAME}
</og:dataCheck>

<!-- ﾃｰﾌﾞﾙﾃﾞｰﾀを取得 -->
<og:query command="NEW" maxRowCount="0" debug="{@debug}">
	select {@COLUMN_NAME_LIST}
	from {@TABLE_NAME}
</og:query>

<!-- 相関ﾋｰﾄﾏｯﾌﾟの出力 -->
<og:bizLogic logics="gf.GFX028A" keys="COLUMN_NAME_LIST,COLUMN_LABEL_LIST" vals="{@COLUMN_NAME_LIST},{@COLUMN_LABEL_LIST}" selectedAll="true" />
<og:text>{@RETURN}</og:text>

<!-- ﾃｰﾌﾞﾙﾃﾞｰﾀの出力 -->
<!--<og:view height="200px" />-->

<!-- ダブルクリックでGFX029に遷移させる -->
<og:text>
<script>
	$('td').dblclick(function(){
			var clm = this.id.split("__");
			window.location.href="../GFX029/result.jsp?GAMENID=GFX029&amp;command=NEW&amp;TABLE_NAME={@TABLE_NAME}&amp;COLUMN_NAME1="+clm[0]+"&amp;COLUMN_NAME2="+clm[1]+"&amp;METHOD_CALC=1";
		});
		
</script>
</og:text>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
