/****************************************************************************/
/* GE38 ( ﾌｧｲﾙ種別ﾏｽﾀ )                                                     */
/*                                                                          */
/* Created : 2018/05/02 11:51:56                                            */
/****************************************************************************/
CREATE TABLE GE38 (
   SYSTEM_ID    VARCHAR2 (   10 )                   NOT NULL            /*  10 ｼｽﾃﾑID       */
 , SYFILE       VARCHAR2 (  100 )                   NOT NULL            /*  20 ﾌｧｲﾙ種別     */
 , SYNAME       VARCHAR2 (  200 )                                       /*  30 種別名称     */
 , DESCRIPTION  VARCHAR2 ( 4000 )                                       /*  40 概要説明     */
 , HINAGATA     VARCHAR2 (  300 )                                       /*  50 雛形ﾌｧｲﾙ     */
 , SAVE_FOLDER  VARCHAR2 (  300 )                                       /*  60 保管ﾌｫﾙﾀﾞ    */
 , FILE_URL     VARCHAR2 (  300 )                                       /*  70 ﾌｧｲﾙURL      */
 , ICON_URL     VARCHAR2 (  300 )                                       /*  80 ｱｲｺﾝURL      */
 , ROLES        VARCHAR2 (  500 )                                       /*  90 ﾛｰﾙｽﾞ        */
 , SU_LMT       NUMBER   (    5 )       DEFAULT 0   NOT NULL            /* 100 閲覧制限数   */
 , DY_LMT       NUMBER   (    5 )       DEFAULT 0   NOT NULL            /* 110 閲覧期日     */
 , SIZE_LMT     NUMBER   (    9 )       DEFAULT 0   NOT NULL            /* 120 ｻｲｽﾞ制限     */
 , SUFFIX_LMT   VARCHAR2 (  200 )                                       /* 130 拡張子制限   */
 , FGANGO       VARCHAR2 (    1 )       DEFAULT '0' NOT NULL            /* 140 暗号化FG     */
 , FGZIP        VARCHAR2 (    1 )       DEFAULT '0' NOT NULL            /* 150 圧縮FG       */
 , UNIQ         NUMBER   (    9 )       DEFAULT 0   NOT NULL            /* 800 ﾕﾆｰｸｷｰ       */
 , FGJ          VARCHAR2 (    1 )       DEFAULT '1' NOT NULL            /* 810 状態ﾌﾗｸﾞ     */
 , DYSET        VARCHAR2 (   14 )                                       /* 820 登録日時     */
 , PGSET        VARCHAR2 (   10 )                                       /* 830 作成PG       */
 , PGPSET       VARCHAR2 (   10 )                                       /* 840 作成親PG     */
 , USRSET       VARCHAR2 (   10 )                                       /* 850 作成社員     */
 , DYUPD        VARCHAR2 (   14 )                                       /* 860 更新日時     */
 , PGUPD        VARCHAR2 (   10 )                                       /* 870 更新PG       */
 , PGPUPD       VARCHAR2 (   10 )                                       /* 880 更新親PG     */
 , USRUPD       VARCHAR2 (   10 )                                       /* 890 更新者       */
)
TABLESPACE GETBL01
STORAGE( INITIAL 16K NEXT 16K );

CREATE SEQUENCE GE38S00 
  INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;

CREATE OR REPLACE TRIGGER GE38T00 
  BEFORE INSERT ON GE38
  FOR EACH ROW 
  BEGIN 
    SELECT GE38S00.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
  END; 
/
