/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.gbp.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.google.common.base.MoreObjects;
import java.util.List;
import org.openstack4j.model.gbp.Direction;
import org.openstack4j.model.gbp.PolicyClassifier;
import org.openstack4j.model.gbp.Protocol;
import org.openstack4j.model.gbp.builder.PolicyClassifierBuilder;
import org.openstack4j.openstack.common.ListResult;

@JsonRootName(value="policy_classifier")
public class GbpPolicyClassifier
implements PolicyClassifier {
    private static final long serialVersionUID = 1L;
    private String name;
    @JsonProperty(value="tenant_id")
    private String tenantId;
    private String id;
    private String description;
    private String direction;
    @JsonProperty(value="port_range")
    private String portRange;
    private String protocol;
    private Boolean shared;

    @Override
    public PolicyClassifierBuilder toBuilder() {
        return new PolicyClassifierConcreteBuilder(this);
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Direction getDirection() {
        return Direction.forValue(this.direction);
    }

    @Override
    public String getPortRange() {
        return this.portRange;
    }

    @Override
    public Protocol getProtocol() {
        return Protocol.forValue(this.protocol);
    }

    @Override
    public boolean isShared() {
        return this.shared == null ? false : this.shared;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("id", (Object)this.id).add("name", (Object)this.name).add("desription", (Object)this.description).add("tenantId", (Object)this.tenantId).add("portRange", (Object)this.portRange).add("protocol", (Object)this.protocol).add("shared", (Object)this.shared).toString();
    }

    public static PolicyClassifierBuilder builder() {
        return new PolicyClassifierConcreteBuilder();
    }

    public static class PolicyClassifierConcreteBuilder
    implements PolicyClassifierBuilder {
        private GbpPolicyClassifier policyClassfier;

        public PolicyClassifierConcreteBuilder(GbpPolicyClassifier gbpPolicyClassifier) {
            this.policyClassfier = gbpPolicyClassifier;
        }

        public PolicyClassifierConcreteBuilder() {
            this(new GbpPolicyClassifier());
        }

        @Override
        public PolicyClassifier build() {
            return this.policyClassfier;
        }

        @Override
        public PolicyClassifierBuilder from(PolicyClassifier in) {
            this.policyClassfier = (GbpPolicyClassifier)in;
            return this;
        }

        @Override
        public PolicyClassifierBuilder name(String name) {
            this.policyClassfier.name = name;
            return this;
        }

        @Override
        public PolicyClassifierBuilder description(String description) {
            this.policyClassfier.description = description;
            return this;
        }

        @Override
        public PolicyClassifierBuilder portRangeMin(int min) {
            String range = "";
            range = this.policyClassfier.portRange != null && !this.policyClassfier.portRange.isEmpty() ? min + ":" + this.policyClassfier.portRange : "" + min;
            this.policyClassfier.portRange = range;
            return this;
        }

        @Override
        public PolicyClassifierBuilder portRangeMax(int max) {
            String range = "";
            range = this.policyClassfier.portRange != null && !this.policyClassfier.portRange.isEmpty() ? this.policyClassfier.portRange + ":" + max : "" + max;
            this.policyClassfier.portRange = range;
            return this;
        }

        @Override
        public PolicyClassifierBuilder direction(Direction direction) {
            this.policyClassfier.direction = direction.value();
            return this;
        }

        @Override
        public PolicyClassifierBuilder protocol(Protocol protocol) {
            this.policyClassfier.protocol = protocol.value();
            return this;
        }

        @Override
        public PolicyClassifierBuilder shared(boolean shared) {
            this.policyClassfier.shared = shared;
            return this;
        }
    }

    public static class PolicyClassifiers
    extends ListResult<GbpPolicyClassifier> {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="policy_classifiers")
        private List<GbpPolicyClassifier> policyClassfiers;

        @Override
        protected List<GbpPolicyClassifier> value() {
            return this.policyClassfiers;
        }
    }
}

