<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" useRealTimeCheck="false"/>

<og:comment
	system	= "GE:エンジン標準"
	pgid	= "WHTSNEW"
	title	= "標準(新着情報登録)"
	date	= "2012/01/10"
	author	= "Son.I"
	text	= ""
	version	= "001"
/>
<!-- 明細ｽﾀｲﾙ指定-->
<style type="text/css">
body{ background-color:Beige;}
div.menu {
			width:100%;
			 background-color:Beige;
			 margin:0;
			 padding:0;
			 border:0;
			 border-spacing:0px;
			 font-size:small;
}
.menu .lapper{
	width:100%;
	height:100%;
	position:relative;
	padding-top:2px;
}
.lapper .leftside{
	height:100%;
	display:inline;
}
.lapper .rightside{
	position:absolute;
	top:0px;
	right:0px;
}
.lapper .center{
	height:100%;
	display:inline;
	margin-left:10px;
}
 
.CDDEG1	{
	color:#2a4073;
}
.CDDEG2	{
	color:#f39800;
}
.CDDEG3	{
	color:#e2041b;
}
.TITLE_CDDEG3	{
	font-weight: bold;
}
.TODAY{
	color:#e2041b;
}

.EXPAND1{
	display:none;
}
</style>


<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->
<og:query command="NEW" debug="{@debug}" maxRowCount="{@maxRowCount}" dbid="RESOURCE">
	<!-- DB登録時に使用する USRSET カラムを、DBTableModel に設定しておきます。-->
		SELECT		X.*
				,case when ROWNUM &lt;= 7 then 'EXPAND0' else 'EXPAND1' end EXPAND
		FROM
			(
			SELECT	 SYSTEM_ID												<!-- ｼｽﾃﾑID-->
					,SYSCODE												<!-- ｼｽﾃﾑｺｰﾄﾞ-->
					,CDDEG													<!-- 属性-->
					,TITLE													<!-- ﾀｲﾄﾙ-->
					,{@DBF.SUBSTR}(NAIYO,1,100)	GAIYO1							<!-- 概要-->
					,NAIYO					NAIYO							<!-- 内容-->
					,MAND													<!-- 掲載者-->
					,DYSTRD													<!-- 掲載開始日-->
					,DYENDD													<!-- 掲載終了日-->
					,FGJ													<!-- (非表示)状況-->
					,UNIQ													<!-- (非表示)ﾕﾆｰｸ-->
					,BUSHOD													<!-- (非表示)掲載部署-->
					,TEL													<!-- (非表示)電話番号-->
					,MAILAD													<!-- (非表示)ﾒｰﾙｱﾄﾞﾚｽ-->
					,FILE1													<!-- (非表示)ﾌｧｲﾙ1-->
					,FILE2													<!-- (非表示)ﾌｧｲﾙ2-->
					,FILE3													<!-- (非表示)ﾌｧｲﾙ3-->
					,'●'		HEAD_PAT	
					,'{@SYS.REAL_PATH}'{@DBF.CON}FILEPATH				PARENT	<!-- (非表示)ﾌｧｲﾙ保管場所-->
			FROM	GE81
		<og:where>
			<og:and value = "SYSTEM_ID	=	'{@SYS.SYSTEM_ID}'"			/>	
			<og:and value = "SYSCODE	IN	('{@USER.SYSCODE}','*')"	/>	
			<og:and value = "DYSTRD &lt;= '{@USER.YMD}'"/>
			<og:and value = "DYENDD &gt;= '{@USER.YMD}'"/>
			<og:and value = "FGJ	IN	('0','1')"/>		
		</og:where>
		ORDER BY DYSTRD DESC,UNIQ DESC,TITLE
			) X
		WHERE	ROWNUM	&lt;= 20
	<og:appear startKey = "ORDER BY" value = "{@ORDER_BY}"
				defaultVal = "DYSTRD DESC,UNIQ DESC,TITLE" />						<!-- 掲載開始日(降順),ﾀｲﾄﾙ	-->
</og:query>
<og:columnEditor columns="TITLE" renderer="SLABEL" param="20"/>
<og:columnEditor columns="MAND"  renderer="SLABEL" param="6"/>
<og:columnEditor column="DYSTRD" renderer="MD" />

<og:viewLink command="NEW">
	<!-- 添付ﾌｧｲﾙ1-->
	<og:link column="FILE1" href="{@SYS.JSP}/fileDownload" useGamenId="false" keys="file,name" vals="[PARENT]/[FILE1],[FILE1]"/>
	<!-- 添付ﾌｧｲﾙ2-->
	<og:link column="FILE2" href="{@SYS.JSP}/fileDownload" useGamenId="false" keys="file,name" vals="[PARENT]/[FILE2],[FILE2]"/>
	<!-- 添付ﾌｧｲﾙ3-->
	<og:link column="FILE3" href="{@SYS.JSP}/fileDownload" useGamenId="false" keys="file,name" vals="[PARENT]/[FILE3],[FILE3]"/>
	<!-- ﾀｲﾄﾙ -->
	<og:link column="TITLE" href="meisai.jsp" gamenId="21_WHTSNEW" keys="command,UNIQ" vals="NEW,[UNIQ]" target="_blank"/>
</og:viewLink>

<!-- ViewMarkerTag	-->
<og:viewMarker command="NEW">
	<og:columnMarker column="TITLE" markList="[CDDEG]" onMark="1">
		<span class="CDDEG1">[TITLE]</span>
	</og:columnMarker>
	<og:columnMarker column="TITLE" markList="[CDDEG]" onMark="2">
		<span class="CDDEG2">[TITLE]</span>
	</og:columnMarker>
	<og:columnMarker column="TITLE" markList="[CDDEG]" onMark="3">
		<span class="CDDEG3">[TITLE]</span>
	</og:columnMarker>
	<og:columnMarker column="TITLE" markList="[CDDEG]" onMark="1">
		<span class="TITLE_CDDEG1">[TITLE]</span>
	</og:columnMarker>
	<og:columnMarker column="TITLE" markList="[CDDEG]" onMark="2">
		<span class="TITLE_CDDEG2">[TITLE]</span>
	</og:columnMarker>
	<og:columnMarker column="TITLE" markList="[CDDEG]" onMark="3">
		<span class="TITLE_CDDEG3">[TITLE]</span>
	</og:columnMarker>
	<og:columnMarker column="DYSTRD" markList="[DYSTRD]" onMark="{@USER.YMD}">
		<span class="TODAY">[DYSTRD]</span>
	</og:columnMarker>
</og:viewMarker>

<div class="menu">
	<div class="lapper" style="background-color:#19448e;color: white;font-style: italic;">
		<span class="leftside"><og:message lbl="21_WHTSNEW"/></span>
		<div class="rightside" style="position:absolute;right:3px;">
			<og:link href="#" onClick="location.reload();return false;" useGamenId="false">
					<og:img  src="{@SYS.JSP}/image/reload.png" alt="reload"/>
			</og:link>
				<og:link href="index.jsp" gamenId="21_WHTSNEW" target="_blank" keys="command,CHECK" vals="NEW,1">
					<og:img src="{@SYS.JSP}/image/EditFile.gif" alt="edit" />
				</og:link>
		</div>
	</div>
	<og:view
		viewFormType = "CustomData" 
		command      = "NEW" 
		writable     = "false"
		useAfterHtmlTag  = "false"
		loadMarker ="true"
		useHilightRow ="false"
		noDisplay    = "">

		<og:tbody rowspan="0">
			<div class="lapper  [$EXPAND]">
				<div class="leftside">[$HEAD_PAT][$DYSTRD]</div>							<!-- 日 -->
				<div class="center">[$TITLE]</div>												<!-- 概要 -->
				<div class="rightside" style="position:absolute;right:3px;">[$MAND]</div>			<!-- 掲載者-->
			</div>
		</og:tbody>
</og:view>
	<div class="lapper">
		<span class="leftside">
			<span style="font-size:x-small;padding:0;margin:0;border:0;">
				<og:link href="index.jsp" gamenId="21_WHTSNEW" keys="command" vals="INIT" target="_blank" lbl="MSG0082" />
			</span>
		</span>
		<div class="rightside" style="position:absolute;right:3px;">
		<og:link href="#" onClick="$('.EXPAND1, .EXPIMG').toggle(300);return false;" useGamenId="false">
			<og:img  src="{@SYS.JSP}/image/down.png" alt="expand" clazz="EXPIMG"/>
			<og:img  src="{@SYS.JSP}/image/up.png" alt="expand"   clazz="EXPIMG" style="display:none"/>
		</og:link>
		</div>
	</div>
</div>
<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
