/************************************************************************************/
/* 旧 hilightRow.js の内容を移植 5.2.1.0 (2010/10/01) 								*/
/*																					*/
/* 3.8.6.0 (2006/09/29)																*/
/* Common Function																	*/
/* Modified: 2009/02/09 Hard-coded Highlight background color						*/
/* Modified: 2009/05/14 Extend to Firefox											*/
/* Revision: $Id$																	*/
/************************************************************************************/
var csHilightBGColor = "rgb(160,230,200)";

function getParentByTagName( oOneChild, sTagName, sInTagName ) {
	var oParent = oOneChild;
	while( oParent ) {
		if( sTagName == oParent.tagName ) { break; }
		if( sInTagName && ( oParent.tagName == sInTagName ) ) {
			oParent = null;
			break;
		}
		oParent = oParent.parentNode;
	}
	return oParent;
}

function getRowClicked( oOneChild ) {
	var l_sTagName , oParent ;

	oParent = oOneChild;
	while( oParent ) {
		l_sTagName = oParent.tagName;
		if( ( ( "TR" == l_sTagName ) || ( "TBODY" == l_sTagName ) ) && oParent.className.indexOf( "row_" ) > -1 ) {
			break;
		}
		oParent = oParent.parentNode;
	}
	return oParent;
}

function getTable( oOneChild ) {
	return getParentByTagName( oOneChild, "TABLE" );
}

function IsTextField( oClicked ) {
	var bRet = false;
	switch( oClicked.tagName ) {
		case "TD"		:
		case "CENTER"	:
		case "SPAN"		:
		case "DIV"		:
		case "PRE"		:
		case "STYLE"	:
		case "FONT"		:
		case "B"		:
		case "STRONG"	:
		case "A"		: // 4.3.6.6 (2009/05/15)
			bRet = true;
			break;
		default:
			break;
	}
	return bRet;
}

// Simplified currentStyle
function getCurrentStyle( element, property, pseudo ) {
	var prop = property;
	if( element.currentStyle ) {  //IE or Opera
		prop = prop.replace(/\-(\w)/g, function(all, letter){
			return letter.toUpperCase();
		});
		return element.currentStyle[ prop ];
	}
	else if( getComputedStyle ) { //Mozilla or Opera
		prop = prop.replace( /([A-Z])/g, "-$1" ).toLowerCase();
		return getComputedStyle( element, pseudo || null ).getPropertyValue( prop );
	}

	return "";
}

// +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// +  Hilight Row																	 +
// +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// var csHybsCheckMarker = "h_rowSelected";
var csHybsCheckMarker = "h_rowSel";

function getHybsChkFromTBody(oTBody) {
	var oCheck , oChecks , nIndexUp ;

	oCheck = null;
	oChecks  = oTBody.getElementsByTagName( "INPUT" );
	for( nIndexUp = 0; nIndexUp < oChecks.length ; nIndexUp++ ) {
		if( csHybsCheckMarker == oChecks[nIndexUp].name ) {
			oCheck		= oChecks[nIndexUp];
			break;
		}
	}
    return oCheck;
}

function hilightRow( evt, isCheckOnly ) {
	var oClicked , bShiftKey , evnt , bProcess , oTBody , oInnerTbls , oRadio , bRadioType , oTable , oOldTBody , oRunTBody , oEndTBody , oRunRadio , bTBodyIsAfter , nPosMark ;

	oClicked = null;
	bShiftKey = false;
	evnt = ( evt ) ? evt : ( ( window.event ) ? window.event : null );
	if( evnt ) {
		oClicked = ( evnt.target ) ? evnt.target : ( ( evnt.srcElement ) ? evnt.srcElement : null );
		bShiftKey = ("undefined" != typeof evnt.shiftKey) ? evnt.shiftKey : (evnt.modifiers && (evnt.modifiers & Event.SHIFT_MASK));
	}

	if( oClicked ) {
		bProcess = true;

		// 4.3.7.0 (2009/06/01)
		if( isCheckOnly && oClicked.name != csHybsCheckMarker ) {
			bProcess = false;
		}

		if( ( "INPUT" == oClicked.tagName ) && ( "submit" == oClicked.type ) ) {
			bProcess = false;
		}

		//var oTBody =getTBody( oClicked );
		oTBody = getRowClicked( oClicked );
		oInnerTbls = oClicked.getElementsByTagName( "TABLE" );
		// 5.1.6.0 (2010/05/01)
//		if( bProcess && oInnerTbls.length <= 0 && oTBody && oTBody.className  != "row_h" ) {
		if( bProcess && oInnerTbls.length <= 0 && oTBody && oTBody.className && oTBody.className.indexOf( "row_h" ) < 0 ) {
			oRadio = getHybsChkFromTBody(oTBody);
			if(oRadio) bRadioType	= ( "radio" == oRadio.type || "A" == oClicked.tagName );  // 4.3.6.6 (2009/05/15) リンク対応

			oTable = getTable( oTBody );
			if( bRadioType ) {
                // 2009/02/09 in radio button table : oldTBody -> oldTBody2
				if( !( oTable.oldTBody2 && oTable.oldTBody2 == oTBody ) ) {
					 if( oTable.oldTBody2 ) {
						 //oTable.oldTBody.className	= oTable.oldClassName;
						 oTable.oldTBody2.style.backgroundColor	= oTable.oldBGColor;
						 oTable.oldRadio.checked	= false;
					 }
					oTable.oldTBody2 	= oTBody;
					//oTable.oldClassName = oTBody.className;
					//oTable.oldBGColor	= oTBody.currentStyle.backgroundColor;
					oTable.oldBGColor	= getCurrentStyle(oTBody, "background-color");
					oTable.oldRadio 	= oRadio;
					//oTBody.className	= "row_hilight";
					oTBody.style.backgroundColor	= csHilightBGColor;
					oRadio.checked		= true;
				}
			}
			else {
				if(bShiftKey) {
					oOldTBody = oTable.oldTBody || oTBody;

//					var bTBodyIsAfter; // 2009/05/14
					if(document.documentElement.compareDocumentPosition) { // FireFox
						nPosMark = oOldTBody.compareDocumentPosition(oTBody);
						bTBodyIsAfter = ((4 == nPosMark) || (0 == nPosMark));
					}
					else { // IE
						bTBodyIsAfter = (oOldTBody.sourceIndex <=  oTBody.sourceIndex);
					}

					//if(oOldTBody.sourceIndex <=  oTBody.sourceIndex) {
					if(bTBodyIsAfter) {
						oRunTBody = oOldTBody;
						oEndTBody = oTBody;
					}
					else {
						oRunTBody = oTBody;
						oEndTBody = oOldTBody;
					}
					while(true) {
						//if(!oRunTBody.oldClassName) {
						if(!oRunTBody.oldBGColor) {
							//oRunTBody.oldClassName	= oRunTBody.className	;
							//oRunTBody.className		= "row_hilight";
							//oRunTBody.oldBGColor	= oRunTBody.currentStyle.backgroundColor;
							oRunTBody.oldBGColor	= getCurrentStyle(oRunTBody, "background-color");
							oRunTBody.style.backgroundColor	= csHilightBGColor;
						}
						oRunRadio = getHybsChkFromTBody(oRunTBody);
						if(oRunRadio && !oRunRadio.checked) oRunRadio.checked	= true;

						if(oRunTBody == oEndTBody) break;

						do { oRunTBody = oRunTBody.nextSibling; }
						while( oRunTBody && oRunTBody.nodeType != 1 );
					}
					oTable.oldTBody 	= oTBody;
				}
				else {
					// 4.1.0.0（2008/01/17）行選択及びハイライト処理を行う。
					// 5.0.0.3 (2009/09/22)
					// チェックボックスの状態で行ハイライトを行うかどうかを判定する
					// イベント発行元が、行チェックの場合、イベント発行後の状態で判定
					// する必要があるため、通常の場合と条件が判定している
					//if( oTBody.oldClassName ) {
					// 5.0.1.1 (2009/10/02)
					// チェックボックスが存在しない行でハイライトができないバグを修正
					if( ( oRadio && ( ( oClicked.name == csHybsCheckMarker && !oRadio.checked )
								   || ( oClicked.name != csHybsCheckMarker && oRadio.checked ) ) )
						||
						( !oRadio && oTBody.oldBGColor )
					) {
						if( (oClicked == oRadio) || IsTextField( oClicked ) ) {
							//oTBody.className	= oTBody.oldClassName;
							//oTBody.oldClassName	= "";
							oTBody.style.backgroundColor = oTBody.oldBGColor;
							oTBody.oldBGColor	= "";
							if( oRadio ) { 
								oRadio.checked	= false;
							}
							oTable.oldTBody 	= oTBody;
						}
					}
					else {
						//oTBody.oldClassName	= oTBody.className;
						//oTBody.className	= "row_hilight";
						//oTBody.oldBGColor	= oTBody.currentStyle.backgroundColor;
						oTBody.oldBGColor	= getCurrentStyle(oTBody, "background-color");
						oTBody.style.backgroundColor = csHilightBGColor;
						if( oRadio ) { 
							oRadio.checked	= true; 
						}
						oTable.oldTBody 	= oTBody;
					}
				}
			}
		}
	}
}

/****************************************************************************/
/* 旧 bulkSet.js の内容を移植 5.2.1.0 (2010/10/01) 							*/
/*																			*/
/* 特殊なカラムに入力された値をタブで分割して個々に設定する。				*/
/* カラム名は、h_XXXX とし、この値をタブで分割し、XXXX__0 から順番に		*/
/* 設定する。元の値がプルダウン等の場合は、同じ値が設定される。 			*/
/* onChange = "bulkSet(this);" でアクセスされることを想定。 				*/
/* ラジオボタンに関しては、制御側でMENUに変換して使用している。				*/
/*																			*/
/* @og.rev 5.2.1.0 (2010/10/01) 新規追加									*/
/* @og.rev 5.2.3.0 (2010/12/01) カンマ文字列対応、select、checkbox対応		*/
/* @og.rev 5.5.0.0 (2012/03/01) checkbox外し時対応							*/
/* @og.rev 5.7.5.0 (2014/04/04) 区切り文字をタブに戻す。					*/
/* @og.rev 5.9.5.0 (2016/02/05) changeイベント								*/
/* Revision: $Id$															*/
/****************************************************************************/
function bulkSet( obj ) {
	var cbVal , hkey , vals , frm , eles , el , i , j , k ;

	cbVal = obj.value ;
	hkey  = obj.name.substring(2) + '__' ;
	
	// 5.5.0.0 (2012/03/01) checkboxを外した時、かつCtrlC等を行っていないと思われる場合
	if( obj.type == "checkbox" && cbVal == "1") {
		cbVal = obj.checked ? "1"  : "0"; 
	}

// まともにラジオボタン対応をすると、下記の様になる。
//if( obj.name != null ) {
//  cbVal = obj.value ;
//  hkey = obj.name.substring(2) + '__' ;
//}
//else {
//  if( obj.tagName == "PRE" && obj.className == "RADIO" ) {
//    var x1 = obj.getElementsByTagName("INPUT");
//    if( x1.length > 0 ) {
//      for( var m=0; m<x1.length; m++ ) {
//        if( x1[m].checked ) {
//          cbVal = x1[m].value ;
//          hkey  = x1[m].name.substring(2) + '__' ;
//          break;
//        }
//      }
//    }
//  }
//}

	// 文字列の設定："\t"(タブ)があれば、分割して個々に設定する。
	vals = cbVal.split("\t");	// 5.7.5.0 (2014/04/04) タブに戻す。
//	vals = cbVal.split(",");	// 5.2.3.0 (2010/12/01) カンマで分割する

	frm = document.getElementsByTagName("FORM");
	if (frm != null) {
		for( k=0; k<frm.length; k++ ) {
			eles = frm[k].elements ;

			j = 0;
			for ( i=0; i<eles.length; i++ ){
				el = eles[i];
//				if ( (el.name).indexOf( hkey ) == 0 ) {		// 先頭一致
//				if ( (el.name).indexOf( hkey ) == 0 && el.type != "hidden" ) {		// 先頭一致 && hidden でない
				if ( el.name && (el.name).indexOf( hkey ) == 0 && el.type != "hidden" ) {		// 5.4.4.0 先頭一致 && hidden でない nameがある
					// 5.2.3.0 (2010/12/01) チェックボックス対応(エンジンでは、hidden も同時に出すため、checkbox のみ処理)
					if( el.type == "checkbox" ) {
						el.checked = ( vals[j] == "1" ); 
					}
					// select は、値リストの内、":" より前方の値のみセットする。
					else if( el.type == "select-one" ) {
						el.value = vals[j].split(":")[0] ;
					}
					// radio は、値が合致する箇所の checked 属性を true に変更する。
					else if( el.type == "radio" ) {
						if( el.value == vals[j] ) { el.checked = true ; }
						else { continue; }	// 無関係な radio なので、continue する。( j++ しないで、vals[j] はそのまま使う)
					}
					else {
						el.value = vals[j] ;
					}
					if( j<vals.length-1 ) { j++ ; }
					$(el).change(); // 5.9.5.0 (2016/02/05) changeイベントを発生させる
				}
			}
		}
	}
}

/************************************************************************/
/* 指定のカラム列の複数の値を、タブで連結して特殊なカラムに設定する。	*/
/* カラム名は、h_XXXX とし、XXXX__0 から順番に値をタブで連結して、		*/
/* この特殊なカラム(h_XXXX)に設定する。 								*/
/* ondblclick = "bulkPaste(this);" でアクセスされることを想定。 		*/
/* ラジオボタンに関しては、制御側でMENUに変換して使用している。 		*/
/*																		*/
/* @og.rev 5.2.1.0 (2010/10/01) 新規追加								*/
/* @og.rev 5.2.3.0 (2010/12/01) カンマ文字列対応、select、checkbox対応	*/
/* @og.rev 5.7.5.0 (2014/04/04) 区切り文字をタブに戻す。				*/
/* @og.rev 5.7.8.1 (2014/07/18) 最後の区切り文字は削除しない。			*/
/************************************************************************/
function bulkPaste( obj ) {
	var hkey , frm ,  eles , vals , el , k , i , m ;

	hkey = obj.name.substring(2) + '__' ;

// まともにラジオボタン対応をすると、下記の様になる。
//if( obj.name != null ) { hkey = obj.name.substring(2) + '__' ; }
//else {
//  if( obj.tagName == "PRE" && obj.className == "RADIO" ) {
//    var x1 = obj.getElementsByTagName("INPUT");
//    if( x1.length > 0 ) {
//      hkey = x1[0].name.substring(2) + '__' ;
//    }
//  }
//}

	var SP = "\t" ;		// 5.7.5.0 (2014/04/04) 区切り文字をタブに戻す。

	frm = document.getElementsByTagName("FORM");
	if (frm != null) {
		for( k=0; k<frm.length; k++ ) {
			eles = frm[k].elements ;
			vals = "";

			for ( i=0; i<eles.length; i++ ){
				el = eles[i];

//				if ( (el.name).indexOf( hkey ) == 0 ) {		// 先頭一致
//				if ( (el.name).indexOf( hkey ) == 0 && el.type != "hidden" ) {		// 先頭一致 && hidden でない
				if ( el.name && (el.name).indexOf( hkey ) == 0 && el.type != "hidden" ) {		// 先頭一致 && hidden でない 5.4.4.0
					// 5.2.3.0 (2010/12/01) チェックボックス対応(エンジンでは、hidden も同時に出すため、checkbox のみ処理)
					if( el.type == "checkbox" ) {
//						vals += ( el.checked ) ? "1," : "0," ;
						vals += ( el.checked ) ? "1" : "0" ;
					}
					// select は、選択されている option の値を取り出す。
					else if( el.type == "select-one" ) {
						// 値だけなら、el.value で選択された値が取れるが、見えるようにラベルも取得する。
						vals += el.options[el.selectedIndex].value + ":" +
//								el.options[el.selectedIndex].text + "," ;
								el.options[el.selectedIndex].text  ;
					}
					// radio は、checked == true の箇所の値を取得する。
					else if( el.type == "radio" ) {
						if( el.checked ) {
//							vals += el.value + "," ;
							vals += el.value ;
						}
					}
					else {
//						vals += el.value + "\t" ;				// タブで連結する。
//						vals += el.value + "," ;				// 5.2.3.0 (2010/12/01) カンマで連結する。
						vals += el.value ;
					}
					vals += SP ;								// 5.7.5.0 (2014/04/04) 区切り文字を連結する。
				}
			}

			// 最後の余計な区切り文字を取り除いて、引数オブジェクトに値をセットする。
			// 5.7.8.1 (2014/07/18) 最後の余計な区切り文字の取り除きは行わない。
	//		vals = vals.substring(0,vals.length-1) ;

			// select は、最後に選択された option を追加する。
			if( obj.type == "select-one" ) {
				// 5.4.4.0 ヘッダ固定時を考えて、同一名でオブジェクト違いのものが存在すればそれにもセットする
				var objs = document.getElementsByName(obj.name);
					if(objs && objs.length > 1){
						for ( l=0; l<objs.length; l++ ){
//							obj.length++;
//							obj.options[obj.length - 1].value = vals
//							obj.options[obj.length - 1].text  = "Ctrl-C";
//							obj.selectedIndex = obj.length - 1 ;
							objs[l].length++;
							objs[l].options[obj.length - 1].value = vals
							objs[l].options[obj.length - 1].text  = "Ctrl-C";
							objs[l].selectedIndex = obj.length - 1 ;
						}
					}
			}
			else {
				obj.value = vals;
			}
		}
		// 5.4.4.0 ヘッダ固定対応リサイズ処理( IE互換モード＋小さなプルダウンメニュー)
		if( isEndInitEvent() ) {
			$('table#viewTable').resizeView();
		}
	}
}

/************************************************************************/
/* 指定のカラム列の複数の値を、タブで連結して特殊なカラムに設定する。	*/
/* カラム名は、h_XXXX とし、XXXX__0 から順番に値をタブで連結して、		*/
/* この特殊なカラム(h_XXXX)に設定する。 								*/
/* ondblclick = "bulkPaste(this);" でアクセスされることを想定。 		*/
/* ラジオボタンに関しては、制御側でMENUに変換して使用している。 		*/
/*																		*/
/* @og.rev 5.2.1.0 (2010/10/01) 新規追加								*/
/* @og.rev 5.2.3.0 (2010/12/01) カンマ文字列対応、select、checkbox対応	*/
/* @og.rev 5.7.5.0 (2014/04/04) 区切り文字をタブに戻す。				*/
/* @og.rev 5.7.8.1 (2014/07/18) 最後の区切り文字は削除しない。			*/
/************************************************************************/
function bulkPasteBox( obj ) {
	var hkey , frm ,  eles , vals , el , k , i , m ;

//	hkey = obj.name.substring(2) + '__' ;

	var SP = "\t" ;		// 5.7.5.0 (2014/04/04) 区切り文字をタブに戻す。

	frm = document.getElementsByTagName("FORM");
	if (frm != null) {
		for( k=0; k<frm.length; k++ ) {
			eles = frm[k].elements ;
			vals = "";

			var bksufix = null;		// "__" 以降の数字のブレイク判定
			var isStart = false;	// 処理の開始
			for ( i=0; i<eles.length; i++ ){

				el = eles[i];
				if( el.name && el.type != "hidden" ) {
					var idx = (el.name).indexOf( "__" ) ;
					if( idx < 0 ) { continue; }

					var sufix = (el.name).substring( idx+2,(el.name).length );
					if( sufix != bksufix ) {
						if( bksufix != null ) { vals += ";" ; }	// 最初でなければ、改行マーカー
						bksufix = sufix ;
					}

					// 5.2.3.0 (2010/12/01) チェックボックス対応(エンジンでは、hidden も同時に出すため、checkbox のみ処理)
					if( el.type == "checkbox" ) {
//						vals += ( el.checked ) ? "1," : "0," ;
						vals += ( el.checked ) ? "1" : "0" ;
					}
					// select は、選択されている option の値を取り出す。
					else if( el.type == "select-one" ) {
						// 値だけなら、el.value で選択された値が取れるが、見えるようにラベルも取得する。
						vals += el.options[el.selectedIndex].value + ":" +
//								el.options[el.selectedIndex].text + "," ;
								el.options[el.selectedIndex].text ;
					}
					// radio は、checked == true の箇所の値を取得する。
					else if( el.type == "radio" ) {
						if( el.checked ) {
//							vals += el.value + "," ;
							vals += el.value ;
						}
					}
					else {
//						vals += el.value + "\t" ;				// タブで連結する。
//						vals += el.value + "," ;				// 5.2.3.0 (2010/12/01) カンマで連結する。
						vals += el.value  ;
					}
					vals += SP ;								// 5.7.5.0 (2014/04/04) 区切り文字を連結する。
				}
			}

			// 最後の余計なカンマを取り除いて、引数オブジェクトに値をセットする。
			// 5.7.8.1 (2014/07/18) 最後の余計な区切り文字の取り除きは行わない。
	//		vals = vals.substring(0,vals.length-1) ;

			// select は、最後に選択された option を追加する。
			if( obj.type == "select-one" ) {
				// 5.4.4.0 ヘッダ固定時を考えて、同一名でオブジェクト違いのものが存在すればそれにもセットする
				var objs = document.getElementsByName(obj.name);
					if(objs && objs.length > 1){
						for ( l=0; l<objs.length; l++ ){
//							obj.length++;
//							obj.options[obj.length - 1].value = vals
//							obj.options[obj.length - 1].text  = "Ctrl-C";
//							obj.selectedIndex = obj.length - 1 ;
							objs[l].length++;
							objs[l].options[obj.length - 1].value = vals
							objs[l].options[obj.length - 1].text  = "Ctrl-C";
							objs[l].selectedIndex = obj.length - 1 ;
						}
					}
			}
			else {
				obj.value = vals;
			}
		}
		// 5.4.4.0 ヘッダ固定対応リサイズ処理( IE互換モード＋小さなプルダウンメニュー)
		if( isEndInitEvent() ) {
			$('table#viewTable').resizeView();
		}
	}
}

/*************************************************************************/
/* 指定の特殊なカラム に、Ctrl-C と Ctrl-V 、Ctrl-X の動作を設定します。 */
/* Ctrl-C ： bulkPaste(obj); を呼び出し、h_XXXX に列情報を設定します。   */
/* Ctrl-V ： bulkSet(obj); を呼び出し、h_XXXX の情報を列に設定します。   */
/* Ctrl-B ： bulkPasteBox(obj); を呼び出し、全入力欄の配列を取得します。 */
/* Ctrl-X ： h_XXXX のカラムの値をクリアします。                         */
/* onkeydown = "ctrlCV(this);" でアクセスされることを想定。              */
/*                                                                       */
/* @og.rev 5.2.1.0 (2010/10/01) 新規追加                                 */
/* @og.rev 5.2.3.0 (2010/12/01) カンマ文字列対応                         */
/* @og.rev 5.6.5.3 (2013/06/28) Ctrl-V はTabを無視、Ctrl-B を新規追加    */
/* @og.rev 5.7.5.0 (2014/04/04) 区切り文字をタブに戻す。				 */
/*************************************************************************/
function ctrlCV( obj ) {

	var keycode , ctrl , vals;

	// Mozilla(Firefox, NN) and Opera
//	if (e != null) {
//		keycode = e.which;
//		ctrl	= typeof e.modifiers == 'undefined' ? e.ctrlKey : e.modifiers & Event.CONTROL_MASK;
//		shift	= typeof e.modifiers == 'undefined' ? e.shiftKey : e.modifiers & Event.SHIFT_MASK;
//		// イベントの上位伝播を防止
//		e.preventDefault();
//		e.stopPropagation();
//	// Internet Explorer
//	} else {
		keycode = event.keyCode;
		ctrl	= event.ctrlKey;

		// イベントの上位伝播を防止
	//	event.returnValue = false;
	//	event.cancelBubble = true;
//	}

	var SP = "\t" ;		// 5.7.5.0 (2014/04/04) 区切り文字をタブに戻す。

	// キーコードの文字を取得
	keychar = String.fromCharCode(keycode).toUpperCase();

	// Ctrl同時押しの場合
	if( ctrl && obj != null ) {
		// イベントの上位伝播を防止
		event.returnValue = false;
		event.cancelBubble = true;

		if( keychar == "C" ) {
			bulkPaste( obj );
			window.clipboardData.setData( "text", replaceAll( obj.value, "\t", "\r\n" ) );		// 5.7.5.0 (2014/04/04) タブに戻す。
//			window.clipboardData.setData( "text", replaceAll( obj.value, ",", "\r\n" ) );		// 5.2.3.0 (2010/12/01) カンマ文字列対応
		}
		else if( keychar == "B" ) {
			bulkPasteBox( obj );
//			window.clipboardData.setData( "text", replaceAll( replaceAll( obj.value, ",", "\t" ), ";", "\r\n" ) );		// 5.2.3.0 (2010/12/01) カンマ文字列対応
			window.clipboardData.setData( "text", replaceAll( obj.value , ";", "\r\n" ) );								// 5.7.5.0 (2014/04/04) タブに戻す。
		}
		else if( keychar == "V") {
//			obj.value = replaceAll( window.clipboardData.getData( "text" ) , "\r\n", "\t" );
//			vals = replaceAll( window.clipboardData.getData( "text" ) , "\r\n", "," );			// 5.2.3.0 (2010/12/01) カンマ文字列対応
			vals = replaceAll( window.clipboardData.getData( "text" ) , "\r\n", SP );			// 5.7.5.0 (2014/04/04) タブに戻す(区切り文字適用)。

			// 5.6.5.3 (2013/06/28) Ctrl-V はTabを無視
//			vals = replaceAll( vals , "\t", "," );	// 改行区切り以外に、タブ区切りも分割できるようにする。

			// 5.2.3.0 (2010/12/01) select は、最後に選択された option を追加する。
			if( obj.type == "select-one" ) {
				// 5.4.4.0 ヘッダ固定時を考えて、同一名でオブジェクト違いのものが存在すればそれにもセットする
				var objs = document.getElementsByName(obj.name);
					if(objs && objs.length > 1){
						for ( i=0; i<objs.length; i++ ){
//						obj.length++;
//						obj.options[obj.length - 1].value = vals
//						obj.options[obj.length - 1].text  = "Ctrl-V";
//						obj.selectedIndex = obj.length - 1 ;
//						obj.value = vals;
						objs[i].length++;
						objs[i].options[obj.length - 1].value = vals
						objs[i].options[obj.length - 1].text  = "Ctrl-V";
						objs[i].selectedIndex = obj.length - 1 ;
						objs[i].value = vals;
					}
					// 5.4.4.0 ヘッダ固定対応リサイズ処理( IE互換モード＋小さなプルダウンメニュー)
					if( isEndInitEvent() ) {
						$('table#viewTable').resizeView();
					}
				}
			}
			else {
				obj.value = vals;
			}
			bulkSet( obj );
		}
		else if( keychar == "X") {
			obj.value = "";
			bulkSet( obj );
		}
	}
}

/*************************************************************************/
/* 文字列置換の簡易メソッド  (replaceAll)                                */
/* val  ： 置換される元の文字列                                          */
/* org  ： 置換元の文字列。                                              */
/* dest ： 置換後の文字列                                                */
/* return : 置換された結果の文字列                                       */
/* @og.rev 5.2.1.0 (2010/10/01) 新規追加                                 */
/*************************************************************************/
function replaceAll(val, org, dest){
	return val.split(org).join(dest);
}

/************************************************************************************/
/* 旧 printLine.js の内容を移植 5.2.1.0 (2010/10/01) 								*/
/*																					*/
/*	3.6.0.5 (2004/10/18)                                                            */
/*	When printing, the ruled line is added to system View table.                    */
/*                                                                                  */
/*	3.8.0.4 (2005/08/08)                                                            */
/*	The phenomenon of the header's shifting is corrected.                           */
/* Revision: $Id$																	*/
/************************************************************************************/

window.onbeforeprint = BeforPrint ;
window.onafterprint  = AfterPrint ;

function BeforPrint() {
	var indx , divheaders , layers , table;

	divheaders = document.getElementsByName("divheader");
	layers     = document.getElementsByName("layer");

	if( null != divheaders && null != layers ) {
		for( indx = 0; indx < divheaders.length; indx++ ) {
			divheaders[indx].style.display = "none";
		}

		for( indx = 0; indx < layers.length; indx++ ) {
			layers[indx].oldScrollTop  = layers[indx].scrollTop;		// 3.8.0.4 (2005/08/08)
			layers[indx].scrollTop	   = 0;								// 3.8.0.4 (2005/08/08)
			layers[indx].oldWidth      = layers[indx].style.width   ;
			layers[indx].style.width   = ""                  ;
			layers[indx].oldHeight     = layers[indx].style.height  ;
			layers[indx].style.height  = ""                  ;
			// 4.3.1.0 (2008/08/29) 印刷時のヘッダー固定外れない不具合対応
			// layers[indx].oldOverflow    = layers[indx].style.overflow;
			// layers[indx].style.overflow = "visible";
			layers[indx].oldOverflowX      = layers[indx].style.overflowX;
			layers[indx].style.overflowX   = "visible";
			layers[indx].oldOverflowY      = layers[indx].style.overflowY;
			layers[indx].style.overflowY   = "visible";
		}
	}

	table = document.getElementsByName("viewTable");
	if( table != null ) {
		for( indx = 0; indx < table.length; indx++ ) {
			// 4.3.1.0 (2008/08/29) セールにデータない場合枠線表示されない不具合対応
			// 印刷時の枠線を出す方法は border="1" の設定から frame="box" の設定に切替る。
			// table[indx].oldBorder      = table[indx].border
			// table[indx].border         = "1px" ;
			// table[indx].oldCellSpacing = table[indx].cellSpacing
			// table[indx].cellSpacing    = "1px" ;
			table[indx].oldFrame          = table[indx].frame;
			table[indx].frame             = "box" ;

			// 4.3.3.4 (2008/11/01) 印刷時にセール枠を二重線にならないように修正
			table[indx].oldBorderCollapse    = table[indx].style.borderCollapse;
			table[indx].style.borderCollapse = "collapse"              ;
			table[indx].oldCellspacing       = table[indx].cellspacing ;
			table[indx].cellspacing          = "0px"                   ;
		}
	}
}

function AfterPrint() {
	var indx , table , divheaders , layers ;

	// 4.3.3.4 (2008/11/01) 内側の戻す処理を先に行うように変更します。
	table = document.getElementsByName("viewTable");
	if( table != null ) {
		for( indx = 0; indx < table.length; indx++ ) {
			// 4.3.1.0 (2008/08/29) セールにデータない場合枠線表示されない不具合対応
			// 印刷時の枠線を出す方法は border="1" の設定から frame="box" の設定に切替る。
			// table[indx].border      = table[indx].oldBorder ;
			// 4.3.3.4 (2008/11/01) 印刷時にセール枠を二重線にならないように修正
			table[indx].style.borderCollapse = table[indx].oldBorderCollapse ;
			table[indx].frame                = table[indx].oldFrame          ;
			table[indx].cellspacing          = table[indx].oldCellspacing    ;
		}
	}

	divheaders = document.getElementsByName("divheader");
	layers  = document.getElementsByName("layer");
	if( null != divheaders && null != layers ) {
		for( indx = 0; indx < divheaders.length; indx++ ) {
			divheaders[indx].style.display = "block";
		}

		for( indx = 0; indx < layers.length; indx++ ) {
			// 4.3.1.0 (2008/08/29) 印刷時のヘッダー固定外れない不具合対応
			// layers[indx].style.overflow = layers[indx].oldOverflow   ;
			layers[indx].style.overflowX   = layers[indx].oldOverflowX  ;
			layers[indx].style.overflowY   = layers[indx].oldOverflowY  ;
			layers[indx].style.width       = layers[indx].oldWidth      ;
			layers[indx].style.height      = layers[indx].oldHeight     ;
			layers[indx].scrollTop	       = layers[indx].oldScrollTop  ;	// 3.8.0.4 (2005/08/08)
		}
	}
}

/************************************************************************************/
/* 旧 timeCheck.js の内容を移植 5.2.1.0 (2010/10/01) 								*/
/*																					*/
/* Revision: $Id$																	*/
/************************************************************************************/
function setPageTiming(evt) {
	var bSetIt , queryTime , viewTime ;

	if( document.attachEvent ) { bSetIt = (document.readyState=="complete" ); }
	else					   { bSetIt = true; }

	if(bSetIt) {
		if( parent.QUERY && parent.QUERY.timecheck ) {
			queryTime = document.getElementById("queryTime");
			viewTime  = document.getElementById("viewTime" );
			parent.QUERY.timecheck( queryTime, viewTime );
		}
	}
}

if(document.addEventListener) {
	if(document.getBoxObjectFor) {
		document.addEventListener("DOMContentLoaded", setPageTiming, null);		//Gecho
	}
	else {
		window.addEventListener("load", setPageTiming, false);
	}
}
else if(document.attachEvent) {
	document.attachEvent("onreadystatechange", setPageTiming);
}
else {
	window.onload = setPageTiming;
}

/********************************************************************************************/
/* 旧 rowCountReplace.js の内容を移植 5.2.1.0 (2010/10/01) 									*/
/*																							*/
/* 検索件数場所変換 4.3.8.0 (2009/08/01) 追加                                             	*/
/* 元々エンジンで直に出力していたJavaScriptを外部に移し、Headでコントロール可能にします。 	*/
/* ビューで出力される[1-4]/[4]の表示場所をヘッダ部分に移動します。                        	*/
/* （先頭と同じ文字が出力されている件数表示を削除します。件数が違う場合はそのまま）       	*/
/*																							*/
/* Revision: $Id$																			*/
/*******************************************************************************************/
$(function(){
	$('.orgRowCntMsg').filter(':gt(0)').remove().end()
								 .filter(':first').replaceAll('#rowCountMessage');
	// 下記ではうまくいかないので上記でやる。
	// $('.orgRowCntMsg').replaceAll('#rowCountMessage');
});


/********************************************************************************************/
/* VIEWのカラムマニュアル表示 5.5.4.0 (2012/07/02) 											*/
/*																							*/
/* VIEWテーブルの情報より、カラムのマニュアルを表示します。							       	*/
/* 利用変数はクロージャーで隠蔽します。														*/
/* img#viewHelpIconがヘルプのアイコンとなります												*/
/*																							*/
/* Modified: 2012/07/18 Field登録／表示の場合も項目説明が作成されるように対応				*/
/*				Scroll対応																	*/
/* Revision: $Id$																			*/
/*******************************************************************************************/
var showViewManual = (function(){
	var fgClicked = false;
	// 画面上の座標の取得
	// Modified: 2012/07/18 スクロール対応
	function getElementScreenPosition( inObj )
	{
		var html = document.documentElement;
		var rect = inObj.getBoundingClientRect();
		var scrollLeft = document.documentElement.scrollLeft || document.body.scrollLeft;
		var left =  scrollLeft > 0 ? rect.left - html.clientLeft + scrollLeft : rect.left - html.clientLeft ;
		var top  = rect.top  - html.clientTop;
		
		left = left < 0 ? 0 : left;
		top = top < 0 ? 0 :top;
		
		return { left:left, top:top };
	}
	//
	function closeDivs( inObj1 ,inObj2 ){
		inObj1.parentNode.removeChild( inObj1 );
		inObj2.parentNode.removeChild( inObj2 );
		fgClicked = false;
	}
	// ヘッダーかどうかの判定
	function isHeader( inObj ){
		if( inObj.parentNode.tagName == "TH" ){
			return true;
		}
		else if( inObj.parentNode.tagName == "BODY" ){
			return false;
		}
		else{
			return isHeader( inObj.parentNode );
		}
	}
	// ラベル（<td class="label">）の判定 2012/07/18 mod
	function isLabel( inObj ){
		if( inObj.parentNode.tagName == "TD" && inObj.parentNode.className == "label" ){
			return true;
		}
		else if( inObj.parentNode.tagName == "BODY" ){
			return false;
		}
		else{
			return isLabel( inObj.parentNode );
		}
	}
	// マニュアルの表示
	// クロージャーとして利用
	// _mode:1なら単純にヘッダがある(1)かない(0)かだけ返す。それ以外は通常実行
	return function(_mode){
		if( fgClicked == true ){ return true; }
		var objSpan   = $("span");
		var objBody   = $("body");

		var countSpan = objSpan.length;

		var spanTable = $("<table/>"); 
		spanTable.css({
					 border			:"solid black 1px"
					,borderCollapse	:"collapse"
					,cellSpacing 	:"0px"
					,cellPadding 	:"0px"
					});
		spanTable.attr("cellPadding" ,"3");
		spanTable.attr("border" ,"1");

		var spanTitle = "";
		var spanKey   = "";
		var keyList = new Object();
		var conList = new Object();
		var fgShow  = 0;
		// 項目の概要説明がない時、または概要説明と項目名称が同内容となっている時は非表示する
		for( i = 0 ;i < countSpan ;i++ ){
//			if( !isHeader( objSpan[i] )) continue;
			// Field型の表示にも、作成するように対応 2012/07/18 mod
			if( !isHeader( objSpan[i] ) && !isLabel( objSpan[i] )) continue;
			spanTitle = objSpan[i].title;
			spanKey   = $(objSpan[i]).text();
			if( spanTitle.length > 0 && spanTitle != spanKey ){
				keyList[spanKey] = spanKey;
				conList[spanKey] = spanTitle;
				fgShow = 1;
			}
		}
		
		// 判定モードの場合
		if( _mode == '1'){
			return fgShow;
		}
		
		if( fgShow == 0 ){ return true; }
		fgClicked = true;
		// 内容
		for( var keyString in keyList ){
			spanTable.append("<tr><td bgcolor='black'><font color='white'>" + keyList[keyString] + "</font></td><td>" + conList[keyString] + "</td></tr>");
		} 
		//
		var objThead     = $("#header").get(0);
		var headerLeft  ;
        var headerTop   ;
        var headerHeight;
		//
		if( objThead ){
			headerLeft   = getElementScreenPosition( objThead ).left;
			headerTop    = getElementScreenPosition( objThead ).top;
			headerHeight = objThead.offsetHeight;
		}
		else{
			headerLeft   = 0;
			headerTop    = 0;
			headerHeight = 0;
		}

		var popDiv 		 = $("<div></div>"); 


		popDiv.append( spanTable );
		popDiv.css({
					 position		:"absolute"
					,backgroundColor:"white"
					,top			:headerTop  + 2 + headerHeight
					,left 			:headerLeft + 2
					,zIndex 		:2
					});

		objBody.append( popDiv );

		// 影の作成
		var shadowDiv = $("<div></div>"); 
		shadowDiv.css({
					 position		:"absolute"
					,backgroundColor:"gray"
					,top			:headerTop  + 10 + headerHeight
					,left 			:headerLeft + 10
					,width			:popDiv.width()
					,height			:popDiv.height()
					,zIndex 		:1
					});
		objBody.append( shadowDiv );

		// 閉じるボタン
		var divClose   = $("<div></div>");
		var imgClose   = $("<img/>");
		imgClose.attr("src"     ,"../image/status_Close.png");
		imgClose.bind("click" ,function(){ closeDivs( popDiv.get(0) ,shadowDiv.get(0) ); });

		imgClose.css({
					 width  :"15px"
					,height :"15px"
					});

		divClose.append( imgClose );
		divClose.css({
					 position		:"absolute"
					,border			:"solid black 1px"
					,top			:0
					,left 			:parseInt( popDiv.offset().left ,10 ) + parseInt( popDiv.width() , 10 )
					,zIndex 		:3
					});

		popDiv.append( divClose );

		// Closeボタンの追加によるサイズ調整 2012/07/18 mod
		spanTable.width( spanTable.width() + 21 );
		shadowDiv.width( popDiv.width());

		// ポップアップのドラッグ処理
		popDiv.attr("id" ,"dragDiv");
		// uiが読み込まれてdrag可能な場合のみ実行
		if(typeof $("#dragDiv").draggable == "function"){
			$("#dragDiv").draggable({
				 opacity  : 0.5
			    ,cursor   : 'move'
				,start	 : function( event ,ui ){
					shadowDiv.css("display" ,"none");
				 }
				,stop	 : function( event ,ui ){
					shadowDiv.css({
								 left 	: parseInt( popDiv.offset().left , 10 ) + 8
								,top  	: parseInt( popDiv.offset().top  , 10 ) + 8
								,display:"block"
								})
				 }
			});
		}
	};
})();

// helpで表示する内容がなければviewHelpIconを消す。
$(function(){
	if(showViewManual('1') == '0'){
		$('img#viewHelpIcon').css('display','none');
	}
});

