<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GFX003"
	title	= "対訳"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>

<!-- 変更はここから -->

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command = "{@command}" />

<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->
<og:query command = "{@command}" debug="{@debug}">
		select GENBUN,YAKU,UNIQ,FGJ
		from   GF28 A
	<!-- 検索条件でWhereTagを使用すれば{@xxxx}がNULLの場合、その条件は無視されます。 -->
	<og:where>
		<og:and value = "exists (select 'X' from GF28 B where A.GENBUN = B.GENBUN" />
		<og:and value = "A.LANG_GEN  LIKE '{@LANG_GEN}%'"  />
		<og:and value = "A.LANG_YAKU LIKE '{@LANG_YAKU}%'" />
		<og:and value = "A.UNIQ != B.UNIQ"                 />
		<og:and value = "A.KBYAKU != '9'"                  />
		<og:and value = "B.KBYAKU != '9' )"                />
	</og:where>
		order by GENBUN,UNIQ
</og:query>

<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">

<!-- 登録、取消、リセットボタンを作成します。 -->
<og:writeCheck>
	<og:submit  value="entry"   lbl="DELETE" accesskey="Z" />
	<og:submit  value="reset"   lbl="RESET"  accesskey="R" />
	<og:input type="reset"  name="command"  lbl="MSG0011"  td="false" />
</og:writeCheck>

<!-- DB検索結果を表示させます。 -->
<og:view
	viewFormType = "HTMLFormatTable"
	command 	 = "{@command}"
	noDisplay    = "FGJ"
	checked      = "{@checked}"
	startNo      = "{@startNo}" 
	pageSize     = "{@pageSize}"
	rowspan      = "2"
>
<tr><td>[GENBUN]</td><td>[YAKU]</td><td>[UNIQ]</td></tr>

<og:hidden name="SQL" >
	delete from GF28
	where 	UNIQ = [UNIQ]
</og:hidden>
</og:view>

</form>

<!-- ここまで。 -->
	<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
