<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:c="http://java.sun.com/jsp/jstl/core"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF7206"
	title	= "折線"
	date	= "2012/05/09"
	author	= "S.Li"
	text	= ""
	version	= "001"
/>

<!-- 入力チェック -->
<og:columnCheck
	command   = "{@command}"
/>

<og:value key="plotOrientation" value="VERTICAL" />

<og:value command="SQL">
		SELECT 	 DECODE('{@plotOrientation}' ,'VERTICAL' ,500 ,count(*)*80 ) GRAPH_HEIGHT
				,DECODE('{@plotOrientation}' ,'VERTICAL' ,count(*)*80 ,500 ) GRAPH_WIDTH
		FROM EMP
		<og:where>
			<og:and value=" DEPTNO = {@SOOUID}" />
		</og:where>
</og:value>
<!--  -->
<og:chartCreate
	title			= "{@chartType}"
	width			= "{@GRAPH_WIDTH}"
	height			= "{@GRAPH_HEIGHT}"
	plotOrientation	= "{@plotOrientation}"
>
	<og:chartDataset
		chartType	= "HybsBar"  upperBound="2800"
	>
			SELECT 	 ENAME							<!-- 営業担当者 -->
					,SAL
					,SAL * 1.5  as RAND1	<!-- 乱数倍 -->
					,SAL * 2  RAND2	<!-- 乱数倍 -->
			FROM EMP
			<og:where>
				<og:and value=" DEPTNO = {@SOOUID}" />
			</og:where>
	</og:chartDataset>
	<og:chartDataset
		chartType	= "HybsLine" upperBound="3800"
	>
			SELECT 	 ENAME							<!-- 営業担当者 -->
					,SAL +100
					,SAL  * 1.5 + 200 as RAND1	<!-- 乱数倍 -->
					,SAL  * 2 + 300 as RAND2	<!-- 乱数倍 -->
			FROM EMP
			<og:where>
				<og:and value=" DEPTNO = {@SOOUID}" />
			</og:where>
	</og:chartDataset>
</og:chartCreate>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
