<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	xmlns:c="http://java.sun.com/jsp/jstl/core"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF7110"
	title	= "サンプルデータ出力"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>

<og:columnCheck
	command   = "{@command}"
/>

<!-- リクエスト変数の値を、アトリビュートとして、再設定します。 -->
<og:value command="SET" key="TABLES" value="{@TABLES}" />

<!-- 出力先のベースフォルダ -->
<og:value command="SET" key="BASE_DIR" value="{@SYS.REAL_PATH}{@SYS.FILE_URL}{@USER.ID}/sample" />

<table border="1" frame="box" rules="all" >
  <tr><th>XML File</th><th>Name</th><th width="70px">Count</th><th>Message</th></tr>
  <!-- CSVデータを、カンマで分解します。 -->
  <c:forTokens items="${TABLES}" delims="," var="TBL" >
	<og:value command="SET" key="NOT_FOUND_MSG">
		<og:query command="{@command}" debug="{@debug}" dbid="{@DBID}" maxRowCount="0">
			select * from {@TBL}
		</og:query>
	</og:value>
	<og:text>
	  <tr>
		<td>{@TBL}.xml			</td>
		<td>{@LBL.@TBL}			</td>
		<td class="S9">{@DB.COUNT}	</td>
		<td>{@NOT_FOUND_MSG}		</td>
	  </tr>
	</og:text>

	<og:writeTable
		fileURL        = "{@BASE_DIR}"
		filename       = "{@TBL}.xml"
		writerClass    = "XML"
		encode         = "UTF-8" >
		<og:writeTableParam key="TableName" value="{@TBL}" />
		<og:writeTableParam key="First" >
			delete from {@TBL}
		</og:writeTableParam>
	</og:writeTable>
  </c:forTokens>
</table>

<br />
Saved DIR:<br />
<og:text>{@BASE_DIR}</og:text>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
