<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />
<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />

<og:comment
	system	= "GE:エンジン"
	pgid	= "MAIL05"
	title	= "デーモン起動(Mail)"
	date	= "2009/04/01"
	author	= "S.Li"
	text	= ""
	version	= "001"
/>

<og:schedule
	command		= "{@CMD}"
	scope		= "request"
	timerTask	= "org.opengion.plugin.daemon.MailDaemon"
	name		= "MAIL_DAEMON_{@SYSTEM_ID}"
	comment		= "Start-up By {@USER.INFO}"
	singleton	= "true"
	delay		= "0"
	period		= "{@PERIOD}"
	fixedDelay	= "true"
	keys		= "DEBUG,SYSTEM_ID"
	vals		= "{@DEBUG},{@SYSTEM_ID}"
/>
<og:text>[DAEMON INFO]</og:text>
<og:view
	viewFormType = "HTMLTable" 
	command		= "NEW" 
	scope		= "request"
	writable	= "false"
	checked		= "{@checked}"
	startNo		= "{@startNo}" 
	pageSize	= "{@pageSize}"
	useScrollBar= "false"
	noMessage	= "true"  />
<!-- システムパラメータテーブル(GE12)への登録 -->
<!-- PARAM_ID を CONTEXT_INITIAL_CALL_URL_ で登録するとTomcat起動時に再実行されます。 -->
<og:equals val1="{@CMD}" val2="SET" >
	<og:value command="SQL">
		SELECT COUNT(*) AS CNT FROM GE12
			WHERE SYSTEM_ID = 'GE'
			AND   PARAM_ID = 'CONTEXT_INITIAL_CALL_URL_MAIL_DAEMON_{@SYSTEM_ID}'
			AND   FGJ = '1'
			AND   CONTXT_PATH = '{@SYS.HOST_URL}'
	</og:value>

	<!-- 存在しなければ、追加 -->
	<og:equals val1="{@CNT}" val2="0" >
	  <og:query command="NEW" debug="{@debug}" maxRowCount="{@maxRowCount}">
			INSERT INTO GE12
				(SYSTEM_ID,PARAM_ID,PARAM,PARAM_LVL,TITLE,CONTENTS,SEQNO,KBSAKU,
				 FGJ,DYSET,DYUPD,USRSET,USRUPD,PGUPD,CONTXT_PATH)
			VALUES
				('GE','CONTEXT_INITIAL_CALL_URL_MAIL_DAEMON_{@SYSTEM_ID}',
				'<og:link href="{@SYS.CONTEXT_URL}jsp/MAIL05/result.jsp" hrefOnly="true" useGamenId="false"
					keys="command,SYSTEM_ID,CMD,PERIOD"
					vals="NEW,{@SYSTEM_ID},SET,{@PERIOD}" />',
				 '7','','','1000','1',
				 '1','{@USER.YMDH}','{@USER.YMDH}','{@USER.ID}','{@USER.ID}','{@GUI.KEY}','{@SYS.HOST_URL}')
	  </og:query>
	</og:equals>
</og:equals>

<!-- リムーブ時は、特定のタスク名称で削除します。 -->
<og:equals val1="{@CMD}" val2="REMOVE" >
	<og:query command="NEW" debug="{@debug}" maxRowCount="{@maxRowCount}">
		DELETE FROM GE12
			WHERE SYSTEM_ID = 'GE'
			AND   PARAM_ID = 'CONTEXT_INITIAL_CALL_URL_MAIL_DAEMON_{@SYSTEM_ID}'
			AND   FGJ = '1'
			AND   CONTXT_PATH = '{@SYS.HOST_URL}'
	</og:query>
</og:equals>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
