/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.taglib;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.ToString;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.html.TabData;
import org.opengion.hayabusa.taglib.CommonTagSupport;

public class TabTableTag
extends CommonTagSupport {
    private static final String VERSION = "4.0.0.0 (2005/08/31)";
    private static final long serialVersionUID = 400020050831L;
    private static final String CR = HybsSystem.CR;
    private static final String JSV = "<script type=\"text/javascript\">ots.style.height = otab.offsetHeight ;</script>";
    private static final String JQUITAB1 = "<script type=\"text/javascript\">$('#ogjquitab').tabs(";
    private static final String JQUITAB2 = ");</script>";
    private transient List<TabData> tabList = null;
    private boolean orientation = true;
    private String height = null;
    private String width = null;
    private String style = null;
    private int selectedIndex = -1;
    private int realIndex = -1;
    private int realTabCount = -1;

    @Override
    public int doStartTag() {
        return 2;
    }

    @Override
    public int doEndTag() {
        this.debugPrint();
        if (this.tabList == null) {
            String string = "BODY\u90e8\u306b TabTag \u304c\u5fc5\u305a\u5fc5\u8981\u3067\u3059\u3002";
            throw new HybsSystemException(string);
        }
        this.jspPrint(this.makeTag());
        this.jspPrint(JQUITAB1);
        if (this.selectedIndex >= 0) {
            this.jspPrint("{ selected:" + this.selectedIndex + "}");
        }
        this.jspPrint(JQUITAB2);
        return 6;
    }

    @Override
    protected void release2() {
        super.release2();
        this.tabList = null;
        this.orientation = true;
        this.height = null;
        this.width = null;
        this.selectedIndex = -1;
        this.realIndex = -1;
        this.realTabCount = -1;
        this.style = null;
    }

    private String makeTag() {
        if (this.orientation) {
            if (this.height == null) {
                this.height = "auto";
            }
            if (this.width == null) {
                this.width = "auto";
            }
            return this.makeHorizontalTag();
        }
        if (this.height == null) {
            this.height = "auto";
        }
        if (this.width == null) {
            this.width = "auto";
        }
        return this.makeVerticalTag();
    }

    private String makeHorizontalTag() {
        TabData tabData;
        int n;
        if (this.realIndex < 0) {
            this.realIndex = 0;
        }
        StringBuilder stringBuilder = new StringBuilder(500);
        stringBuilder.append("  <div id=\"ogjquitab\" style=\"width:" + this.width + "; height:" + this.height + "\"> ");
        int n2 = this.tabList.size();
        stringBuilder.append("    <ul> ");
        for (n = 0; n < n2; ++n) {
            tabData = this.tabList.get(n);
            if (tabData.isOpen()) {
                stringBuilder.append(tabData.getTab(this.style, n)).append(CR);
                continue;
            }
            stringBuilder.append(tabData.getTab(null, n)).append(CR);
        }
        stringBuilder.append("    </ul> ");
        for (n = 0; n < n2; ++n) {
            tabData = this.tabList.get(n);
            stringBuilder.append(tabData.getTabBody(n)).append(CR);
        }
        stringBuilder.append("</div>").append(CR);
        return stringBuilder.toString();
    }

    private String makeVerticalTag() {
        return this.makeHorizontalTag();
    }

    protected void addTabData(TabData tabData) {
        if (this.tabList == null) {
            this.tabList = new ArrayList<TabData>();
        }
        this.tabList.add(tabData);
        if (this.realIndex < 0 && tabData.isOpen()) {
            this.realIndex = this.tabList.size() - 1;
        }
    }

    protected boolean isSelected() {
        ++this.realTabCount;
        return this.selectedIndex == this.realTabCount;
    }

    @Deprecated
    public void setOrientation(String string) {
        String string2 = StringUtil.nval((String)this.getRequestParameter(string), null);
        if (string2 != null && string2.length() > 0) {
            char c = string2.toUpperCase(Locale.JAPAN).charAt(0);
            if (c == 'H') {
                this.orientation = true;
            } else if (c == 'V') {
                this.orientation = false;
            } else {
                String string3 = "orientation \u306e\u6307\u5b9a\u306f\u3001H(orizontal) \u307e\u305f\u306f\u3001V(ertical) \u3067\u3059\u3002 orientation=" + string2;
                throw new HybsSystemException(string3);
            }
        }
    }

    public void setHeight(String string) {
        this.height = StringUtil.nval((String)this.getRequestParameter(string), (String)this.height);
    }

    public void setWidth(String string) {
        this.width = StringUtil.nval((String)this.getRequestParameter(string), (String)this.width);
    }

    public void setSelectedIndex(String string) {
        this.selectedIndex = StringUtil.nval((String)this.getRequestParameter(string), (int)this.selectedIndex);
    }

    @Deprecated
    public void setStyle(String string) {
        this.style = StringUtil.nval((String)this.getRequestParameter(string), (String)this.style);
    }

    @Override
    public String toString() {
        return ToString.title((String)((Object)((Object)this)).getClass().getName()).println("VERSION", (Object)VERSION).println("height", (Object)this.height).println("width", (Object)this.width).println("selectedIndex", (Object)this.selectedIndex).println("Other...", (Object)this.getAttributes().getAttribute()).fixForm().toString();
    }
}

