/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
// package org.opengion.hayabusa.common;
package org.opengion.fukurou.system;									// 6.4.2.0 (2016/01/29) package変更 fukurou.util → fukurou.system

import java.util.Date;

/**
 * このシステム全体のリリース状況を表すデータを直接コーディングしています。
 * バージョン番号は、X.X.X.X という管理体系をあらわしています。
 * バージョン変更時には、WEB-INF/lib/hayabusaX.X.X.X.jar ファイルと、
 * jsp/common フォルダ、jsp/menu フォルダ、jsp/image フォルダの変更が必要です。
 * 以前、使用していました、WEB-INF/hybs-taglib.tld ファイルは、hayabusaX.X.X.X.jar に
 * 組み込まれた為、導入する必要はなくなりました。
 * ただし、影響度合いも考慮していますので、厳密に下記の通りの変更になるとは限りません
 * ので、置換え時には、RELEASE-NOTES.txt をご確認の上、対応願います。
 *
 *<pre>
 *        X.X.X
 *        | | |_____ システム修正、変更、マイナーリリース
 *        | |_______ システム新機能追加、DBなど外部環境の変更必要
 *        |_________ システムアーキテクチャの変更（アプリケーションの修正必要）
 *
 * </pre>
 *
 * @og.rev 3.5.5.3 (2004/04/09) インターフェースを、クラスに変更します。
 * @og.rev 4.0.0.0 (2004/12/31) 項目追加
 * @og.rev 6.4.2.0 (2016/01/29) package変更 hayabusa.common → fukurou.system
 *
 * @version  0.9.0  2000/10/17
 * @author   Kazuhiko Hasegawa
 * @since    JDK1.1,
 */
public final class BuildNumber {

	/**
	 * エンジンバージョン番号。
	 * このエンジンのバージョン番号を設定します。
	 * @og.paramLevel 9:自動設定
	 */
	public static final String VERSION_NO = "6.5.0.1";

	/**
	 * エンジンビルドタイプ。
	 * このエンジンのビルドタイプを設定します。
	 * @og.paramLevel 9:自動設定
	 */
	public static final String BUILD_TYPE = "Release6 Builds (2016301)" ;

	/**
	 * エンジンバージョンNo。
	 * このエンジンのバージョン番号 + ビルドタイプ を設定します。
	 * [例： 4.0.0.0 Release4 Builds (04273)]
	 * @og.paramLevel 9:自動設定
	 */
	public static final String ENGINE_INFO = "openGion " + VERSION_NO + " " + BUILD_TYPE ;

	/**
	 * エンジンビルド時刻。
	 * このエンジンのビルド時刻を設定します。
	 * @og.paramLevel 9:自動設定
	 */
	public static final String TIMESTAMP = "2016/10/27 08:48:56" ;

	/**
	 * 稼動しているサーバーのＯＳ情報。
	 * いま、稼動しているサーバーのＯＳ情報を設定します。
	 * [例： Windows 2000 Service Pack 4]
	 *
	 * @og.rev 5.6.7.3 (2013/08/23) os.arch と、sun.arch.data.model を追加します。
	 *
	 * @og.paramLevel 9:自動設定
	 */
	public static final String OS_INFO = System.getProperty( "os.name" )
								+ " " +  System.getProperty( "sun.os.patch.level" )
								+ " " +  System.getProperty( "os.arch" )
								+ " (" +  System.getProperty( "sun.arch.data.model" ) + ")" ;

	/**
	 * JDKバージョン。
	 * いま、稼動しているJavaのバージョン情報を設定します。
	 * [例： Java HotSpot(TM) Server VM 1.4.2_05-b04 ]
	 *
	 * @og.rev 5.6.7.3 (2013/08/23) java.vm.version を、java.runtime.version に変更します。
	 *
	 * @og.paramLevel 9:自動設定
	 */
	public static final String JDK_INFO = System.getProperty( "java.vm.name" )
								+ " " + System.getProperty( "java.runtime.version" ) ;

	/**
	 * コンテキストの稼動開始時刻。
	 * このコンテキスト(システム)の稼動開始時刻(初めてロードされた時刻)を設定します。
	 * [例： 2004/09/29 17:52:31]
	 * @og.paramLevel 9:自動設定
	 */
	public static final String STARTING_TIME = String.valueOf( new Date() ) ;

	/**
	 * エンジンビルドID
	 * このエンジンのビルドIDを設定します。
	 * キャッシュコントロールを行う際のキー情報として使用します。
	 *
	 * @og.rev 4.3.5.3 (2008/02/22)
	 *
	 * @og.paramLevel 9:自動設定
	 */
	public static final String BUILD_ID = "20161027084856" ;

	/**
	 *	デフォルトコンストラクターをprivateにして、
	 *	オブジェクトの生成をさせないようにする。
	 *
	 * @og.rev 3.5.5.3 (2004/04/09) インターフェースを、クラスに変更します。
	 */
	private BuildNumber() {}
}
