<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes" />
  <xsl:template match="/">
    <xsl:apply-templates select="javadoc" />
  </xsl:template>

  <xsl:template match="javadoc">
    <xsl:variable name="version" select="version" />
    <ROWSET tableName="GF37">
      <EXEC_SQL>delete from GF37 where VERSION = '<xsl:value-of select="$version" />'</EXEC_SQL>
      <xsl:for-each select="classDoc/menber">
        <xsl:element name="ROW">
          <xsl:attribute name="num">
            <xsl:number level="any" format="1" count="name" />
          </xsl:attribute>
          <VERSION		><xsl:value-of select="$version"	/></VERSION>
          <FULLNAME		><xsl:value-of select="../fullName"	/></FULLNAME>
          <EXTENDCLASS	><xsl:value-of select="extendClass"	/></EXTENDCLASS>
          <EXTENDFLAG	><xsl:value-of select="extendFlag"	/></EXTENDFLAG>
          <MENBERTYPE	><xsl:value-of select="type"		/></MENBERTYPE>
          <MENBERNAME	><xsl:value-of select="name"		/></MENBERNAME>
          <MODIFIERS	><xsl:value-of select="modifiers"	/></MODIFIERS>
          <SIGNATURE	><xsl:value-of select="signature"	/></SIGNATURE>
          <DESCRIPTION	><xsl:value-of select="description" /></DESCRIPTION>
          <CONTENTS		><xsl:value-of select="contents"	/></CONTENTS>
          <TAGTEXT		><xsl:value-of select="tagText"		/></TAGTEXT>
          <HISTORY		><xsl:value-of select="history"		/></HISTORY>
        </xsl:element>
      </xsl:for-each>
    </ROWSET>
  </xsl:template>

</xsl:stylesheet>
