<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="init" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF6320"
	title	= "ユーザ変更"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>

<jsp:directive.page import="org.opengion.hayabusa.common.HybsSystem" />
<jsp:directive.page import="org.opengion.hayabusa.resource.UserInfo" />
<jsp:directive.page import="org.opengion.hayabusa.resource.UserInfoFactory" />

<og:columnCheck command="{@command}" minRowCount="1" />

<h2>
<og:message lbl="MSG0031" comment="ログインユーザー" />
<og:message lbl="MSG0046" comment="変更処理を行います。" /><br />
</h2>

<p>
<b>Old User name = [<og:userInfo command="GET" key="USER.INFO" />]</b>
</p>
<jsp:scriptlet>

	/* oldUser は、変更しません。最初のログインユーザーをそのまま保存しつづけます。*/
	UserInfo userInfo = (UserInfo)session.getAttribute( HybsSystem.USERINFO_KEY );
	String oldUserIdTemp = (String)session.getAttribute( HybsSystem.OLD_USERID_KEY );
	if( oldUserIdTemp == null ) { oldUserIdTemp = userInfo.getUserID(); }

	String newUserIdTemp = request.getParameter( "USERID" );
	UserInfo userInfoTemp = UserInfoFactory.newInstance( newUserIdTemp,request.getRemoteAddr(),null );

	session.setAttribute( HybsSystem.USERINFO_KEY  , userInfoTemp );
	session.setAttribute( HybsSystem.OLD_USERID_KEY, oldUserIdTemp );

</jsp:scriptlet>

<p>
<b>New User name = [<og:userInfo command="GET" key="USER.INFO" />]</b>
</p>

<h2>
<og:message lbl="MSG0060" comment="変更しました。" />
</h2>

<!-- ３秒後に先頭に戻る。  -->
<og:responseHeader refresh="3" refreshURL="../index.jsp" />

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
