<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF6140"
	title	= "テーブル結合(フィルター)"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<og:columnCheck
	command   = "{@command}"
	columns   = "CLM,NAME_JA,SYSTEM_ID"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command = "{@command}" />

<og:query command="{@command}" dbid="RESOURCE" debug="{@debug}" maxRowCount="{@maxRowCount}">
		select SYSTEM_ID,LANG,CLM,'' as NAME_JA,LABEL_NAME,KBSAKU,URL,COMMENTS,CDTAN,UNIQ
		from GF41
		where SYSTEM_ID in ( '{@SYSTEM_ID}','{@AST}' )
	<og:where startKey="and">
		<og:and value = "FGJ		=	'{@FGJ}'" 			/>
		<og:and value = "UPPER(CLM)	like UPPER('{@CLM}%')"	/>
		<og:and value = "NAME_JA	like '{@NAME_JA}%'"		/>
		<og:and value = "LABEL_NAME	like '{@LABEL_NAME}%'"	/>
		<og:and value = "KBSAKU		= 	'{@KBSAKU}'"		/>
		<og:and value = "LANG		=	'{@LANG}'"			/>
	</og:where>
	<og:appear startKey = "order by" value = "{@ORDER_BY}"
				defaultVal = "SYSTEM_ID,CLM" />
</og:query>

<og:tableFilter
	classId     = "DBSELECT"
	selectedAll = "true"
>
	select NAME_JA FROM GF41 WHERE SYSTEM_ID=[SYSTEM_ID] AND CLM=[CLM] AND LANG='ja' AND FGJ='1'
</og:tableFilter>

<og:viewLink command="{@command}">
	<og:link column="CLM" gamenId="GF9100" href="index.jsp" target="CONTENTS"
		keys="command,SYSTEM_ID,CLM,FGJ,LANG"
		vals="NEW,[SYSTEM_ID],[CLM],1,[LANG]" />
</og:viewLink>

<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">

<og:equals val1="{@ACTION}" val2="{@ACTION}">
	<og:query dbid="{@TO_DBID}" scope="request" quotCheck="false" maxRowCount="{@maxRowCount}">
		{@USER.LASTSQL}
	</og:query>
	<og:tableMerge
		action        = "{@ACTION}"
		masterScope   = "session"
		masterKeys    = "SYSTEM_ID,CLM"
		diffKeys      = "NAME_JA,KBSAKU"
		slaveScope    = "request"
		modifyClms    = "UNIQ"
		display       = "true"
	/>
</og:equals>

<og:view
	viewFormType = "HTMLTable"
	command    = "{@command}"
	noDisplay  = "UNIQ"
	checked    = "{@checked}"
	startNo    = "{@startNo}"
	pageSize   = "{@pageSize}" />
</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
