<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="init" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF2050"
	title	= "定義ファイル取込"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>

<og:columnCheck
	command   = "{@command}"
	columns   = "SYSTEM_ID,TABLE_NAME,CLM"
/>

<!-- TBLSYU='T' は、テンポラリ -->
<og:query command="{@command}" debug="{@debug}" maxRowCount="0">
		delete from GF80
		where  SYSTEM_ID = '{@SYSTEM_ID}'
		and    TBLSYU    = 'T'
		and    FGJ		 = '1'
</og:query>

<og:query command="{@command}" debug="{@debug}" maxRowCount="0">
		select SYSTEM_ID,TBLSYU,TABLE_NAME,CLM,SEQNO,NAME_JA,CLS_NAME,USE_LENGTH,
				NOT_NULL,RENDERER,EDITOR,DBTYPE,DATA_DEFAULT,FGCOM,BIKO
		from   GF05
		where  SYSTEM_ID = '{@SYSTEM_ID}'
		and    TBLSYU    = '{@TBLSYU}'
		and    FGJ		 = '1'
</og:query>

<!-- TBLSYU='T' のテンポラリに、INSERT する。 -->
<og:tableUpdate
	selectedAll = "true"
	command		= "ENTRY"
	queryType	= "JDBCTableUpdate">
		INSERT INTO GF80
			( SYSTEM_ID,TBLSYU,TABLE_NAME,CLM,SEQNO,CLM_NAME,CLS_NAME,PHY_LENGTH,USE_LENGTH,
				NOT_NULL,RENDERER,EDITOR,DBTYPE,DATA_DEFAULT,KBCLM,BIKO,
				FGJ,DYSET,DYUPD,USRSET,USRUPD,PGUPD )
		VALUES
			( [SYSTEM_ID],'T',[TABLE_NAME],[CLM],[SEQNO],[NAME_JA],[CLS_NAME],[USE_LENGTH],[USE_LENGTH],
				[NOT_NULL],[RENDERER],[EDITOR],[DBTYPE],[DATA_DEFAULT],[FGCOM],[BIKO],
				'1','{@USER.YMDH}','{@USER.YMDH}','{@USER.ID}','{@USER.ID}','{@GUI.KEY}' )
</og:tableUpdate>

<og:query command="{@command}" debug="{@debug}" maxRowCount="0">
		UPDATE GF80 A
			SET A.NAME_JA =
				(SELECT B.NAME_JA FROM GF02 B
					WHERE B.TBLSYU   = '{@TBLSYU}'
					AND B.SYSTEM_ID  = A.SYSTEM_ID
					AND B.TABLE_NAME = A.TABLE_NAME
					AND B.FGJ = '1')
		WHERE A.SYSTEM_ID 	= '{@SYSTEM_ID}'
		AND A.TBLSYU		= 'T'
</og:query>

<og:query command="{@command}" debug="{@debug}" maxRowCount="0">
		UPDATE GF80 A
			SET A.UK = (SELECT B.SEQNO FROM GF07 B
							WHERE B.TBLSYU = '{@TBLSYU}'
							AND B.TABLE_NAME = A.TABLE_NAME
							AND ( B.INDEX_NAME = A.TABLE_NAME || '_UQ' OR B.INDEX_NAME = 'PK_' || A.TABLE_NAME )
							AND B.CLM = A.CLM
							AND B.FGJ = '1'),
				A.LUK = (SELECT B.SEQNO FROM GF07 B
							WHERE B.TBLSYU = '{@TBLSYU}'
							AND B.TABLE_NAME = A.TABLE_NAME
							AND B.INDEX_NAME = A.TABLE_NAME || '_LUQ'
							AND B.CLM = A.CLM
							AND B.FGJ = '1'),
				A.IXA = (SELECT B.SEQNO FROM GF07 B
							WHERE B.TBLSYU = '{@TBLSYU}'
							AND B.TABLE_NAME = A.TABLE_NAME
							AND ( B.INDEX_NAME = A.TABLE_NAME || '_SA' OR B.INDEX_NAME = A.TABLE_NAME || '_KEY01' )
							AND B.CLM = A.CLM
							AND B.FGJ = '1'),
				A.IXB = (SELECT B.SEQNO FROM GF07 B
							WHERE B.TBLSYU = '{@TBLSYU}'
							AND B.TABLE_NAME = A.TABLE_NAME
							AND ( B.INDEX_NAME = A.TABLE_NAME || '_SB' OR B.INDEX_NAME = A.TABLE_NAME || '_KEY02' )
							AND B.CLM = A.CLM
							AND B.FGJ = '1'),
				A.IXC = (SELECT B.SEQNO FROM GF07 B
							WHERE B.TBLSYU = '{@TBLSYU}'
							AND B.TABLE_NAME = A.TABLE_NAME
							AND ( B.INDEX_NAME = A.TABLE_NAME || '_SC' OR B.INDEX_NAME = A.TABLE_NAME || '_KEY03' )
							AND B.CLM = A.CLM
							AND B.FGJ = '1'),
				A.IXD = (SELECT B.SEQNO FROM GF07 B
							WHERE B.TBLSYU = '{@TBLSYU}'
							AND B.TABLE_NAME = A.TABLE_NAME
							AND ( B.INDEX_NAME = A.TABLE_NAME || '_SD' OR B.INDEX_NAME = A.TABLE_NAME || '_KEY04' )
							AND B.CLM = A.CLM
							AND B.FGJ = '1'),
				A.IXE = (SELECT B.SEQNO FROM GF07 B
							WHERE B.TBLSYU = '{@TBLSYU}'
							AND B.TABLE_NAME = A.TABLE_NAME
							AND ( B.INDEX_NAME = A.TABLE_NAME || '_SE' OR B.INDEX_NAME = A.TABLE_NAME || '_KEY05' )
							AND B.CLM = A.CLM
							AND B.FGJ = '1'),
				A.IXF = (SELECT B.SEQNO FROM GF07 B
							WHERE B.TBLSYU = '{@TBLSYU}'
							AND B.TABLE_NAME = A.TABLE_NAME
							AND ( B.INDEX_NAME = A.TABLE_NAME || '_SF' OR B.INDEX_NAME = A.TABLE_NAME || '_KEY06' )
							AND B.CLM = A.CLM
							AND B.FGJ = '1'),
				A.IXG = (SELECT B.SEQNO FROM GF07 B
							WHERE B.TBLSYU = '{@TBLSYU}'
							AND B.TABLE_NAME = A.TABLE_NAME
							AND ( B.INDEX_NAME = A.TABLE_NAME || '_SG' OR B.INDEX_NAME = A.TABLE_NAME || '_KEY07' )
							AND B.CLM = A.CLM
							AND B.FGJ = '1'),
				A.IXH = (SELECT B.SEQNO FROM GF07 B
							WHERE B.TBLSYU = '{@TBLSYU}'
							AND B.TABLE_NAME = A.TABLE_NAME
							AND ( B.INDEX_NAME = A.TABLE_NAME || '_SH' OR B.INDEX_NAME = A.TABLE_NAME || '_KEY08' )
							AND B.CLM = A.CLM
							AND B.FGJ = '1'),
				A.IXI = (SELECT B.SEQNO FROM GF07 B
							WHERE B.TBLSYU = '{@TBLSYU}'
							AND B.TABLE_NAME = A.TABLE_NAME
							AND ( B.INDEX_NAME = A.TABLE_NAME || '_SI' OR B.INDEX_NAME = A.TABLE_NAME || '_KEY09' )
							AND B.CLM = A.CLM
							AND B.FGJ = '1'),
				A.IXJ = (SELECT B.SEQNO FROM GF07 B
							WHERE B.TBLSYU = '{@TBLSYU}'
							AND B.TABLE_NAME = A.TABLE_NAME
							AND ( B.INDEX_NAME = A.TABLE_NAME || '_SJ' OR B.INDEX_NAME = A.TABLE_NAME || '_KEY10' )
							AND B.CLM = A.CLM
							AND B.FGJ = '1'),
				A.IXK = (SELECT B.SEQNO FROM GF07 B
							WHERE B.TBLSYU = '{@TBLSYU}'
							AND B.TABLE_NAME = A.TABLE_NAME
							AND ( B.INDEX_NAME = A.TABLE_NAME || '_SK' OR B.INDEX_NAME = A.TABLE_NAME || '_KEY11' )
							AND B.CLM = A.CLM
							AND B.FGJ = '1')
		WHERE A.SYSTEM_ID 	= '{@SYSTEM_ID}'
		AND A.TBLSYU		= 'T'
</og:query>

<og:query command="{@command}" debug="{@debug}" maxRowCount="0" >
		select TABLE_NAME,NAME_JA,SEQNO,CLM_NAME,CLM,'' as DTYPE,CLS_NAME,
				PHY_LENGTH,USE_LENGTH,UK,LUK,IXA,IXB,IXC,IXD,IXE,IXF,IXG,IXH,IXI,IXJ,IXK,NOT_NULL,C_KEY,F_KEY,
				RENDERER,EDITOR,DBTYPE,DATA_DEFAULT,KBCLM,BIKO,COMMENTS
		from GF80
	<og:where>
		<og:and value = "FGJ         = '1'"                 />
		<og:and value = "SYSTEM_ID   =  '{@SYSTEM_ID}'"     />
		<og:and value = "TBLSYU      = 'T'"                 />
		<og:and value = "TABLE_NAME  like '{@TABLE_NAME}%'" />
		<og:and value = "CLM         like '{@CLM}%'"        />
		<og:and value = "BIKO        like '{@BIKO}%'"       />
	</og:where>
		order by SYSTEM_ID,TBLSYU,
					 regexp_substr( TABLE_NAME, '[A-Z]+' ),
					 to_number(regexp_substr( TABLE_NAME, '[0-9]+' )),TABLE_NAME,SEQNO
</og:query>

<og:tableFilter classId="DTYPE" />

<og:writeTable
	writerClass		= "Excel"
	fileURL			= "{@USER.ID}"
	filename		= "fileout.xls"
/>

<og:forward page="{@SYS.FILE_OUT_URL}{@USER.ID}/fileout.xls" filename="{@LBL.GF80}{@LBL.TBLSYU %C}.xls" />

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
