<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:jsp="http://java.sun.com/JSP/Page"
    xmlns:java="http://xml.apache.org/xalan/java"
	xmlns:og="hybs-taglib.tld"
	exclude-result-prefixes="xsl jsp java og" >

  <xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes"
              omit-xml-declaration="yes"   />

  <xsl:param name="SYSTEM_ID" select="" />
  <xsl:param name="TBLSYU"    select="" />
  <xsl:param name="FILEPATH"  select="" />
  <xsl:param name="ADDRESS"   select="" />
  <xsl:param name="FILENAME"  select="" />
  <xsl:param name="MODIFIED"  select="" />

  <xsl:param name="row_header" >
     <SYSTEM_ID ><xsl:value-of select="$SYSTEM_ID" /></SYSTEM_ID>
     <TBLSYU    ><xsl:value-of select="$TBLSYU"    /></TBLSYU>
     <ADDRESS   ><xsl:value-of select="$ADDRESS"   /></ADDRESS>
     <FILENAME  ><xsl:value-of select="$FILENAME"  /></FILENAME>
     <FILEPATH  ><xsl:value-of select="$FILEPATH"  /></FILEPATH>
     <MODIFIED  ><xsl:value-of select="$MODIFIED"  /></MODIFIED>
  </xsl:param>

  <xsl:template match="/">
    <xsl:apply-templates select="jsp:root/og:comment"  />
    <xsl:apply-templates select="jsp:root[not(child::og:comment)]" />
  </xsl:template>

  <xsl:template match="jsp:root/og:comment">
     <ROW>
       <xsl:copy-of select="$row_header" />
       <TAGNAME    ><xsl:value-of select="name()"  /></TAGNAME>
       <TITLE      ><xsl:value-of select="@title"   /></TITLE>
       <VERNO      ><xsl:value-of select="@version" /></VERNO>
       <MODIFYDATE ><xsl:value-of select="@date"    /></MODIFYDATE>
       <AUTHOR     ><xsl:value-of select="@author"  /></AUTHOR>
       <TEXTBODY   >
         <xsl:value-of select="@text" />
         <xsl:copy-of  select="node()"  />
       </TEXTBODY>
     </ROW>
  </xsl:template>

  <xsl:template match="jsp:root[not(child::og:comment)]" >
     <ROW>
       <xsl:copy-of select="$row_header" />
       <TAGNAME    />
       <TITLE      />
       <VERNO      />
       <MODIFYDATE />
       <AUTHOR     />
       <TEXTBODY   />
     </ROW>
  </xsl:template>

</xsl:stylesheet>
