<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GE:エンジン"
	pgid	= "MAIL02"
	title	= "グループマスタ管理"
	date	= "2009/04/01"
	author	= "S.Li"
	text	= ""
	version	= "001"
/>

<og:equals val1="{@SYS.VER4_COMPATIBLE_MODE}" val2="true">
	<og:value command="SET" key="C_KBNAME" value="NM_KBN" />
	<og:value command="SET" key="C_NAME_JA" value="NAME" />
	<og:value command="SET" key="C_ADDRESS" value="MEMBER" />
</og:equals>
<og:equals val1="{@SYS.VER4_COMPATIBLE_MODE}" val2="true" notEquals="true">
	<og:value command="SET" key="C_KBNAME" value="KBNAME" />
	<og:value command="SET" key="C_NAME_JA" value="NAME_JA" />
	<og:value command="SET" key="C_ADDRESS" value="ADDRESS" />
</og:equals>

<!-- forward.jsp から command = "COPY/MODIFY/DELETE" がセットされて遷移してきます。-->
<!-- データが選ばれていなければエラー -->
<og:columnCheck command="{@command}" >
	<jsp:directive.include file="/jsp/common/history_back.jsp" />
</og:columnCheck>

<!-- entryタグのcommandとcolumnSetのコマンドが同じ場合のみ、動作します。 -->
<og:entry command="{@command}" />
<og:message command="{@command}" /><br />

<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">

<!-- 登録、取消、リセットボタンを作成します。 -->
<og:writeCheck>
	<og:submit  value="entry"   lbl="ENTRY" accesskey="E" />
	<og:submit  value="reset"   lbl="RESET" accesskey="R" />
	<og:input   type="reset"  name="command"  lbl="MSG0011"  td="false" />
	<br />
</og:writeCheck>

<!-- DB検索結果を表示させます。 -->
<og:view
	viewFormType = "HTMLTable" 
	command      = "{@command}" 
	noDisplay    = "UNIQ,DYSET,USRSET,DYUPD,USRUPD,PGUPD"
	noWritable   = "UNIQ"
	selectedType = "checkbox"
/>

<og:hidden name="SQL" >
	INSERT INTO GE33(SYSTEM_ID
					,GROUP_ID
					,{@C_ADDRESS}
					,{@C_NAME_JA}
					,{@C_KBNAME}
					,DYSET
					,USRSET
					,PGUPD )
			VALUES(  [SYSTEM_ID]
					,[GROUP_ID]
					,[ADDRESS]
					,[NAME_JA]
					,[KBNAME]
					,'{@DATE.YMDHMS}'
					,'{@USER.ID}'
					,'{@GUI.KEY}' )
</og:hidden>

</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
