<jsp:directive.page pageEncoding="UTF-8" />
<!-- 画面：ユーザークロス集計 -->
<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
		select A.GUIKEY,A.USERID
				, sum(A.CNT_ACCESS) as ACC
				, sum(A.CNT_ERROR) AS ERR
				, sum(A.CNT_READ) AS RD
				, sum(A.CNT_WRITE) AS WT
				, sum(A.TM_TOTAL_QUERY) AS TQ
				, max(A.TM_MAX_QUERY) AS MQ
		from GE15 A left outer join GEA11 B
		on      A.SYSTEM_ID = B.SYSTEM_ID
		and     A.GUIKEY    = B.GUIKEY
		where   A.GUIKEY is not null
	<og:where startKey="and" >
		<og:and value = "A.SYSTEM_ID  =    '{@SYSTEM_ID}'"   />
		<og:and value = "A.GUIKEY     like '{@GUIKEY}%'"     />
		<og:and value = "A.USERID     =    '{@USERID}'"      />
		<og:and value = "A.DYLOGIN    like '{@DATE}%'"       /> 
	</og:where>
--	group by CUBE(A.GUIKEY,A.USERID)
	group by A.GUIKEY,A.USERID
	order by A.GUIKEY,A.USERID
</og:query>

<og:view
	viewFormType = "HTMLCrossTable"
	command    = "{@command}"
	checked    = "{@checked}"
	startNo    = "{@startNo}"
	pageSize   = "{@pageSize}"
	useParam   = "true"
  >
	<og:crossParam
		cubeXColumn    = "GUIKEY"
		cubeYColumn    = "USERID"
		sumNumber      = "6"
		shokeiLabel    = "SHOKEI"
		gokeiLabel     = "GOKEI"
		cubeSortType   = "STRING"
	/>
</og:view>
