/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.util;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;
import org.opengion.fukurou.util.HybsDateUtil;
import org.opengion.fukurou.util.LogWriter;

public abstract class HybsTimerTask
extends TimerTask
implements Comparable<HybsTimerTask> {
    private static AtomicInteger counter = new AtomicInteger();
    private final int uniqKey;
    private final long createTime = System.currentTimeMillis();
    private String name = null;
    private String comment = null;
    private Map<String, String> paramMap = null;
    private String body = null;
    private String startTime = "000000";
    private String stopTime = "000000";
    private int startStop = 0;
    private boolean aliveFlag = true;
    private int errorSleep = 0;

    public HybsTimerTask() {
        this.uniqKey = counter.getAndIncrement();
    }

    @Override
    public final void run() {
        try {
            if (this.isExecution()) {
                this.startDaemon();
            }
        }
        catch (Throwable throwable) {
            if (this.errorSleep > 0) {
                try {
                    Thread.sleep((long)this.errorSleep * 1000L);
                }
                catch (InterruptedException interruptedException) {
                    LogWriter.log(interruptedException);
                }
                System.out.println(throwable.getMessage());
            }
            this.cancel();
            throw new RuntimeException(throwable);
        }
    }

    protected abstract void startDaemon();

    public void initDaemon() {
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public String getComment() {
        return this.comment;
    }

    public int getUniqKey() {
        return this.uniqKey;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public void setParameter(Map<String, String> map) {
        if (map != null) {
            this.paramMap = new HashMap<String, String>(map);
        }
    }

    public String getValue(String string) {
        if (this.paramMap != null && string != null) {
            return this.paramMap.get(string);
        }
        return null;
    }

    public void setBody(String string) {
        this.body = string;
    }

    public String getBody() {
        return this.body;
    }

    public void setStartTime(String string) {
        if (string == null || string.length() != 6) {
            String string2 = "startTime is inaccurate.startTime=[" + string + "]";
            throw new RuntimeException(string2);
        }
        this.startTime = string;
        this.initStartStop();
    }

    public void setStopTime(String string) {
        if (string == null || string.length() != 6) {
            String string2 = "stopTime is inaccurate.stopTime=[" + string + "]";
            throw new RuntimeException(string2);
        }
        this.stopTime = string;
        this.initStartStop();
    }

    public void setErrorSleepSec(int n) {
        this.errorSleep = n;
    }

    private void initStartStop() {
        this.startStop = this.startTime == null || this.stopTime == null ? 0 : this.startTime.compareTo(this.stopTime);
    }

    private boolean isExecution() {
        boolean bl = false;
        String string = HybsDateUtil.getDate("HHmmss");
        if (this.startStop == 0) {
            bl = true;
        } else if (this.startStop < 0) {
            if (this.startTime.compareTo(string) < 0 && string.compareTo(this.stopTime) < 0) {
                bl = true;
            }
        } else if (this.startStop > 0 && (this.startTime.compareTo(string) < 0 || string.compareTo(this.stopTime) < 0)) {
            bl = true;
        }
        return bl;
    }

    @Override
    public int compareTo(HybsTimerTask hybsTimerTask) {
        int n;
        if (this.name == null && hybsTimerTask.name != null) {
            return -1;
        }
        if (this.name != null && hybsTimerTask.name == null) {
            return 1;
        }
        if (this.name != null && hybsTimerTask.name != null && (n = this.name.compareTo(hybsTimerTask.name)) != 0) {
            return n;
        }
        return this.uniqKey - hybsTimerTask.uniqKey;
    }

    public String toString() {
        return this.name + " [" + this.uniqKey + "]";
    }

    public boolean equals(Object object) {
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        HybsTimerTask hybsTimerTask = (HybsTimerTask)object;
        return this.uniqKey == hybsTimerTask.uniqKey;
    }

    public boolean isAlive() {
        return this.aliveFlag;
    }

    public int hashCode() {
        return this.uniqKey;
    }

    @Override
    public boolean cancel() {
        if (this.aliveFlag) {
            System.out.println();
            System.out.println(this.toString() + " " + new Date() + " Stoped");
            this.aliveFlag = false;
        }
        return super.cancel();
    }
}

