/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.model;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.apache.poi.xssf.model.SharedStringsTable;
import org.apache.poi.xssf.model.StylesTable;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.opengion.fukurou.model.EventReader;
import org.opengion.fukurou.model.ExcelStyleFormat;
import org.opengion.fukurou.model.POIUtil;
import org.opengion.fukurou.model.TableModelHelper;
import org.opengion.fukurou.util.Closer;
import org.opengion.fukurou.util.HybsConst;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public final class EventReader_XLSX
implements EventReader {
    private static final String VERSION = "6.2.0.0 (2015/02/27)";
    public static final String SAX_PARSER = "org.apache.xerces.parsers.SAXParser";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void eventReader(File file, TableModelHelper tableModelHelper) {
        OPCPackage oPCPackage = null;
        try {
            tableModelHelper.startFile(file);
            oPCPackage = OPCPackage.open((File)file);
            XSSFReader xSSFReader = new XSSFReader(oPCPackage);
            XMLReader xMLReader = XMLReaderFactory.createXMLReader(SAX_PARSER);
            List<SheetObj> list = EventReader_XLSX.getSheetList(xSSFReader, xMLReader);
            tableModelHelper.sheetSize(list.size());
            SharedStringsTable sharedStringsTable = xSSFReader.getSharedStringsTable();
            StylesTable stylesTable = xSSFReader.getStylesTable();
            SheetHandler sheetHandler = new SheetHandler(stylesTable, sharedStringsTable, tableModelHelper);
            xMLReader.setContentHandler(sheetHandler);
            InputStream inputStream = null;
            for (int i = 0; i < list.size(); ++i) {
                SheetObj sheetObj = list.get(i);
                if (tableModelHelper.startSheet(sheetObj.getName(), i)) {
                    try {
                        inputStream = xSSFReader.getSheet(sheetObj.getRid());
                        xMLReader.parse(new InputSource(inputStream));
                    }
                    catch (Throwable throwable) {
                        Closer.ioClose(inputStream);
                        throw throwable;
                    }
                    Closer.ioClose(inputStream);
                }
                tableModelHelper.endSheet(i);
            }
        }
        catch (OpenXML4JException openXML4JException) {
            String string = ".xlsx\u306e\u30d5\u30a1\u30a4\u30eb\u89e3\u6790\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002 filename=" + file + HybsConst.CR + openXML4JException.getMessage();
            throw new RuntimeException(string, openXML4JException);
        }
        catch (SAXException sAXException) {
            String string = "SAX \u306e\u4e00\u822c\u7684\u306a\u30a8\u30e9\u30fc\u307e\u305f\u306f\u8b66\u544a\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002 filename=" + file + HybsConst.CR + sAXException.getMessage();
            throw new RuntimeException(string, sAXException);
        }
        catch (IOException iOException) {
            String string = ".xlsx\u306e\u30d5\u30a1\u30a4\u30eb\u306e\u8aad\u307f\u53d6\u308a\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002 filename=" + file + HybsConst.CR + iOException.getMessage();
            throw new RuntimeException(string, iOException);
        }
        finally {
            if (oPCPackage != null) {
                oPCPackage.revert();
            }
            tableModelHelper.endFile(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<SheetObj> getSheetList(XSSFReader xSSFReader, XMLReader xMLReader) throws SAXException, IOException, InvalidFormatException {
        final ArrayList<SheetObj> arrayList = new ArrayList<SheetObj>();
        xMLReader.setContentHandler(new DefaultHandler(){

            @Override
            public void startElement(String string, String string2, String string3, Attributes attributes) {
                if ("sheet".equals(string3)) {
                    String string4 = attributes.getValue("name");
                    String string5 = attributes.getValue("r:id");
                    arrayList.add(new SheetObj(string4, string5));
                }
            }
        });
        InputStream inputStream = null;
        try {
            inputStream = xSSFReader.getWorkbookData();
            xMLReader.parse(new InputSource(inputStream));
        }
        finally {
            Closer.ioClose(inputStream);
        }
        return arrayList;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.err.println("Usage: java org.opengion.fukurou.model.EventReader_XLSX \u5165\u529b\u30d5\u30a1\u30a4\u30eb\u540d");
            return;
        }
        File file = new File(stringArray[0]);
        EventReader_XLSX eventReader_XLSX = new EventReader_XLSX();
        eventReader_XLSX.eventReader(file, new TableModelHelper(){

            @Override
            public boolean startSheet(String string, int n) {
                System.out.println("S[" + n + "]=" + string);
                return super.startSheet(string, n);
            }

            @Override
            public boolean value(String string, int n, int n2) {
                System.out.println("R[" + n + "],C[" + n2 + "]=" + string);
                return super.value(string, n, n2);
            }
        });
    }

    private static final class SheetObj {
        private final String name;
        private final String rid;

        public SheetObj(String string, String string2) {
            this.name = string;
            this.rid = string2;
        }

        public String getName() {
            return this.name;
        }

        public String getRid() {
            return this.rid;
        }
    }

    private static final class SheetHandler
    extends DefaultHandler {
        private final SharedStringsTable sst;
        private final TableModelHelper helper;
        private final ExcelStyleFormat format;
        private String lastContents;
        private XSSFDataType nextDataType = XSSFDataType.NUMBER;
        private String cellStyleStr;
        private int rowNo = -1;
        private int colNo = -1;
        private boolean isRowSkip;

        public SheetHandler(StylesTable stylesTable, SharedStringsTable sharedStringsTable, TableModelHelper tableModelHelper) {
            this.sst = sharedStringsTable;
            this.helper = tableModelHelper;
            this.format = new ExcelStyleFormat(stylesTable);
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) {
            if ("row".equals(string3)) {
                this.rowNo = Integer.parseInt(attributes.getValue("r")) - 1;
                this.isRowSkip = false;
            } else {
                if (this.isRowSkip) {
                    return;
                }
                if ("c".equals(string3)) {
                    String string4 = attributes.getValue("r");
                    int[] nArray = POIUtil.kigo2rowCol(string4);
                    this.colNo = nArray[1];
                    this.nextDataType = XSSFDataType.NUMBER;
                    this.cellStyleStr = attributes.getValue("s");
                    String string5 = attributes.getValue("t");
                    if ("b".equals(string5)) {
                        this.nextDataType = XSSFDataType.BOOL;
                    } else if ("e".equals(string5)) {
                        this.nextDataType = XSSFDataType.ERROR;
                    } else if ("inlineStr".equals(string5)) {
                        this.nextDataType = XSSFDataType.INLINESTR;
                    } else if ("s".equals(string5)) {
                        this.nextDataType = XSSFDataType.SSTINDEX;
                    } else if ("str".equals(string5)) {
                        this.nextDataType = XSSFDataType.FORMULA;
                    }
                }
            }
            this.lastContents = "";
        }

        @Override
        public void endElement(String string, String string2, String string3) {
            this.isRowSkip = this.helper.isSkip(this.rowNo);
            if (this.isRowSkip) {
                return;
            }
            String string4 = null;
            if ("v".equals(string3)) {
                switch (this.nextDataType) {
                    case BOOL: {
                        char c = this.lastContents.charAt(0);
                        string4 = c == '0' ? "FALSE" : "TRUE";
                        break;
                    }
                    case ERROR: {
                        string4 = "\"ERROR:" + this.lastContents + '\"';
                        break;
                    }
                    case FORMULA: {
                        string4 = '\"' + this.lastContents + '\"';
                        break;
                    }
                    case INLINESTR: {
                        string4 = new XSSFRichTextString(this.lastContents).toString();
                        break;
                    }
                    case SSTINDEX: {
                        String string5 = this.lastContents;
                        try {
                            int n = Integer.parseInt(string5);
                            string4 = new XSSFRichTextString(this.sst.getEntryAt(n)).toString();
                        }
                        catch (NumberFormatException numberFormatException) {
                            String string6 = "Failed to parse SST index [" + string5 + "]: " + numberFormatException.toString();
                            System.out.println(string6);
                        }
                        break;
                    }
                    case NUMBER: {
                        string4 = this.format.getNumberValue(this.cellStyleStr, this.lastContents);
                        break;
                    }
                    default: {
                        string4 = "(TODO: Unexpected type: " + (Object)((Object)this.nextDataType) + ")";
                    }
                }
                this.helper.value(string4, this.rowNo, this.colNo);
            }
        }

        @Override
        public void characters(char[] cArray, int n, int n2) {
            if (this.isRowSkip) {
                return;
            }
            this.lastContents = this.lastContents + new String(cArray, n, n2);
        }
    }

    private static enum XSSFDataType {
        BOOL,
        ERROR,
        FORMULA,
        INLINESTR,
        SSTINDEX,
        NUMBER;

    }
}

