/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.report2;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.report2.SOfficeProcess;

public final class SOfficeProcessTcp
extends SOfficeProcess {
    private static final boolean[] ports = new boolean[512];
    private static final Object lock = new Object();
    private final int initPort;
    private final int thisPort;

    protected SOfficeProcessTcp(String string, int n) {
        super(string);
        this.initPort = n;
        this.thisPort = this.getThisPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getThisPort() {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        int n = -1;
        Object object = lock;
        synchronized (object) {
            for (int i = 0; i < ports.length; ++i) {
                if (ports[i] || !this.checkPort(this.initPort + i)) continue;
                SOfficeProcessTcp.ports[i] = true;
                n = this.initPort + i;
                break;
            }
        }
        if (n < 0) {
            throw new HybsSystemException("TCP\u63a5\u7d9a\u30dd\u30fc\u30c8\u3092\u53d6\u5f97\u3059\u308b\u3053\u3068\u304c\u3067\u304d\u307e\u305b\u3093");
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkPort(int n) {
        boolean bl = false;
        Socket socket = null;
        try {
            socket = new Socket();
            socket.connect(new InetSocketAddress("localhost", n));
        }
        catch (IOException iOException) {
            bl = true;
        }
        finally {
            try {
                if (socket != null) {
                    socket.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return bl;
    }

    @Override
    protected String getConnParam(String string) {
        System.out.println("[INFO]OOo:TCP Connection Start,port=" + this.thisPort);
        return "uno:socket,host=localhost,tcpNoDelay=1,port=" + this.thisPort + ";urp;StarOffice.ComponentContext";
    }

    @Override
    protected String getProcParam(String string) {
        return "-accept=socket,host=localhost,port=" + this.thisPort + ";urp;";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        super.close();
        Object object = lock;
        synchronized (object) {
            SOfficeProcessTcp.ports[this.thisPort - this.initPort] = false;
        }
        System.out.println("[INFO]OOo:TCP Connection End(Release),port=" + this.thisPort);
    }
}

