/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.taglib;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.ToString;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.db.DBColumn;
import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.hayabusa.db.DBTableModelUtil;
import org.opengion.hayabusa.resource.GUIInfo;
import org.opengion.hayabusa.resource.UserInfo;
import org.opengion.hayabusa.taglib.QueryTag;

public class GuiQueryTag
extends QueryTag {
    private static final String VERSION = "5.3.3.0 (2011/03/01)";
    private static final long serialVersionUID = 533020110301L;
    private static final String[] SELECT = new String[]{"GUIKEY", "ADDRESS", "REALADDRESS", "SEQNO", "GROUPS", "CLASSIFY", "LEVEL", "NAME_JA", "SNAME", "LNAME", "ROLES", "RWMODE", "TARGET", "PARAM", "KBLINK", "DESCRIPTION", "DYUPD"};
    private static final int GUIKEY = 0;
    private static final int ADDRESS = 1;
    private static final int REALADDRESS = 2;
    private static final int SEQNO = 3;
    private static final int GROUPS = 4;
    private static final int CLASSIFY = 5;
    private static final int LEVEL = 6;
    private static final int NAME_JA = 7;
    private static final int SNAME = 8;
    private static final int LNAME = 9;
    private static final int ROLES = 10;
    private static final int RWMODE = 11;
    private static final int TARGET = 12;
    private static final int PARAM = 13;
    private static final int KBLINK = 14;
    private static final int DESCRIPTION = 15;
    private static final int DYUPD = 16;
    private String roles = null;
    private String level = null;
    private String rwmode = null;

    @Override
    public int doStartTag() {
        super.doStartTag();
        this.table = this.initDBTable();
        this.execute();
        return 0;
    }

    @Override
    protected void release2() {
        super.release2();
        this.roles = null;
        this.level = null;
        this.rwmode = null;
    }

    protected void execute() {
        UserInfo userInfo = new UserInfo("XX", "ja", "DUMMY", this.roles, null, "GF", "127.0.0.1", null);
        this.getResource().makeGUIInfos(userInfo);
        GUIInfo[] gUIInfoArray = userInfo.getGUIInfos();
        for (int i = 0; i < gUIInfoArray.length; ++i) {
            this.addGUIInfo(gUIInfoArray[i]);
        }
        this.executeCount = this.table.getRowCount();
    }

    private DBTableModel initDBTable() {
        DBTableModel dBTableModel = DBTableModelUtil.newDBTable();
        dBTableModel.init(SELECT.length);
        for (int i = 0; i < SELECT.length; ++i) {
            DBColumn dBColumn = this.getDBColumn(SELECT[i]);
            dBTableModel.setDBColumn(i, dBColumn);
        }
        return dBTableModel;
    }

    private void addGUIInfo(GUIInfo gUIInfo) {
        String string = String.valueOf(gUIInfo.getLevel());
        if (this.level != null && !this.level.equals(string)) {
            return;
        }
        String string2 = gUIInfo.getMode();
        if (this.rwmode != null && string2 != null && !string2.startsWith(this.rwmode)) {
            return;
        }
        String[] stringArray = new String[SELECT.length];
        stringArray[0] = gUIInfo.getKey();
        stringArray[1] = gUIInfo.getAddress();
        stringArray[2] = gUIInfo.getRealAddress();
        stringArray[3] = String.valueOf(gUIInfo.getSequence());
        stringArray[4] = gUIInfo.getGroups();
        stringArray[5] = this.getResource().getLabel(gUIInfo.getClassify());
        stringArray[6] = string;
        stringArray[7] = gUIInfo.getLabel();
        stringArray[8] = gUIInfo.getName();
        stringArray[9] = gUIInfo.getLongName();
        stringArray[10] = gUIInfo.getRoles();
        stringArray[11] = string2;
        stringArray[12] = gUIInfo.getTarget();
        stringArray[13] = gUIInfo.getParam();
        stringArray[14] = gUIInfo.getKblink();
        stringArray[15] = gUIInfo.getDescription();
        stringArray[16] = gUIInfo.getDyupd();
        this.table.addColumnValues(stringArray);
    }

    public void setRoles(String string) {
        this.roles = StringUtil.nval((String)this.getRequestParameter(string), (String)this.roles);
    }

    public void setLevel(String string) {
        this.level = StringUtil.nval((String)this.getRequestParameter(string), (String)this.level);
    }

    public void setRwmode(String string) {
        this.rwmode = StringUtil.nval((String)this.getRequestParameter(string), (String)this.rwmode);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }

    @Override
    public String toString() {
        return ToString.title((String)((Object)((Object)this)).getClass().getName()).println("VERSION", (Object)VERSION).println("roles", (Object)this.roles).fixForm().toString() + HybsSystem.CR + super.toString();
    }
}

