/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.io;

import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRendererState;
import org.jfree.chart.renderer.category.StackedBarRenderer;
import org.jfree.data.DataUtilities;
import org.jfree.data.Values2D;
import org.jfree.data.category.CategoryDataset;
import org.jfree.ui.GradientPaintTransformer;
import org.jfree.ui.RectangleEdge;

public class HybsStackedBarRenderer
extends StackedBarRenderer {
    private static final long serialVersionUID = 519020100801L;
    private double domainMargin = 0.0;
    private final int hsCode = Long.valueOf(System.nanoTime()).hashCode();

    public void setDomainMargin(double d) {
        this.domainMargin = d;
    }

    public void drawItem(Graphics2D graphics2D, CategoryItemRendererState categoryItemRendererState, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryDataset categoryDataset, int n, int n2, int n3) {
        CategoryItemLabelGenerator categoryItemLabelGenerator;
        double d;
        double d2;
        double d3;
        Number number = categoryDataset.getValue(n, n2);
        if (number == null) {
            return;
        }
        double d4 = number.doubleValue();
        double d5 = 0.0;
        if (this.getRenderAsPercentages()) {
            d5 = DataUtilities.calculateColumnTotal((Values2D)categoryDataset, (int)n2);
            d4 /= d5;
        }
        PlotOrientation plotOrientation = categoryPlot.getOrientation();
        double d6 = categoryAxis.getCategoryStart(n2, this.getColumnCount(), rectangle2D, categoryPlot.getDomainAxisEdge()) + this.domainMargin * categoryItemRendererState.getBarWidth() / 2.0;
        double d7 = d3 = this.getBase();
        for (int i = 0; i < n; ++i) {
            Number number2 = categoryDataset.getValue(i, n2);
            if (number2 == null) continue;
            d2 = number2.doubleValue();
            if (this.getRenderAsPercentages()) {
                d2 /= d5;
            }
            if (d2 > 0.0) {
                d3 += d2;
                continue;
            }
            d7 += d2;
        }
        RectangleEdge rectangleEdge = categoryPlot.getRangeAxisEdge();
        if (d4 >= 0.0) {
            d = valueAxis.valueToJava2D(d3, rectangle2D, rectangleEdge);
            d2 = valueAxis.valueToJava2D(d3 + d4, rectangle2D, rectangleEdge);
        } else {
            d = valueAxis.valueToJava2D(d7, rectangle2D, rectangleEdge);
            d2 = valueAxis.valueToJava2D(d7 + d4, rectangle2D, rectangleEdge);
        }
        double d8 = Math.min(d, d2);
        double d9 = Math.max(Math.abs(d2 - d), this.getMinimumBarLength());
        Rectangle2D.Double double_ = null;
        double_ = plotOrientation == PlotOrientation.HORIZONTAL ? new Rectangle2D.Double(d8, d6, d9, categoryItemRendererState.getBarWidth()) : new Rectangle2D.Double(d6, d8, categoryItemRendererState.getBarWidth(), d9);
        if (n3 == 0) {
            EntityCollection entityCollection;
            Paint paint = this.getItemPaint(n, n2);
            GradientPaintTransformer gradientPaintTransformer = this.getGradientPaintTransformer();
            if (gradientPaintTransformer != null && paint instanceof GradientPaint) {
                paint = gradientPaintTransformer.transform((GradientPaint)paint, (Shape)double_);
            }
            graphics2D.setPaint(paint);
            graphics2D.fill(double_);
            if (this.isDrawBarOutline() && categoryItemRendererState.getBarWidth() > 3.0) {
                graphics2D.setStroke(this.getItemOutlineStroke(n, n2));
                graphics2D.setPaint(this.getItemOutlinePaint(n, n2));
                graphics2D.draw(double_);
            }
            if ((entityCollection = categoryItemRendererState.getEntityCollection()) != null) {
                this.addItemEntity(entityCollection, categoryDataset, n, n2, double_);
            }
        } else if (n3 == 1 && (categoryItemLabelGenerator = this.getItemLabelGenerator(n, n2)) != null && this.isItemLabelVisible(n, n2)) {
            this.drawItemLabel(graphics2D, categoryDataset, n, n2, categoryPlot, categoryItemLabelGenerator, double_, d4 < 0.0);
        }
    }

    public boolean equals(Object object) {
        if (super.equals(object)) {
            return this.hsCode == ((HybsStackedBarRenderer)((Object)object)).hsCode;
        }
        return false;
    }

    public int hashCode() {
        return this.hsCode;
    }
}

