/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.io;

import java.awt.Color;
import java.awt.Paint;
import java.util.List;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.labels.PieToolTipGenerator;
import org.jfree.chart.labels.StandardCategoryToolTipGenerator;
import org.jfree.chart.labels.StandardPieToolTipGenerator;
import org.jfree.chart.plot.MultiplePiePlot;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.PiePlot3D;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PolarPlot;
import org.jfree.chart.plot.RingPlot;
import org.jfree.chart.plot.SpiderWebPlot;
import org.jfree.chart.urls.CategoryURLGenerator;
import org.jfree.chart.urls.PieURLGenerator;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.Dataset;
import org.jfree.data.general.PieDataset;
import org.jfree.data.xy.XYDataset;
import org.opengion.hayabusa.io.ChartCreate;
import org.opengion.hayabusa.io.ChartDataset;
import org.opengion.hayabusa.io.ChartPlot;
import org.opengion.hayabusa.io.HybsURLGenerator;

public class ChartPlot_Pie
implements ChartPlot {
    @Override
    public Plot getPlot(ChartCreate chartCreate) {
        List<ChartDataset> list = chartCreate.getDatasetList();
        ChartDataset chartDataset = list.get(0);
        Dataset dataset = chartDataset.getDataset();
        HybsURLGenerator hybsURLGenerator = chartCreate.getURLGenerator();
        boolean bl = chartCreate.isUseToolTip();
        MultiplePiePlot multiplePiePlot = null;
        String string = chartDataset.getChartType();
        if ("MultiplePie".equalsIgnoreCase(string)) {
            multiplePiePlot = new MultiplePiePlot();
            multiplePiePlot.setDataset((CategoryDataset)dataset);
        } else if ("Pie".equalsIgnoreCase(string)) {
            Color[] colorArray;
            multiplePiePlot = new PiePlot();
            ((PiePlot)multiplePiePlot).setDataset((PieDataset)dataset);
            if (hybsURLGenerator != null) {
                ((PiePlot)multiplePiePlot).setURLGenerator((PieURLGenerator)hybsURLGenerator);
            }
            if (bl) {
                ((PiePlot)multiplePiePlot).setToolTipGenerator((PieToolTipGenerator)new StandardPieToolTipGenerator());
            }
            if ((colorArray = chartDataset.getSeriesColors()) != null && colorArray.length > 0) {
                for (int i = 0; i < colorArray.length; ++i) {
                    ((PiePlot)multiplePiePlot).setSectionPaint(i, (Paint)colorArray[i]);
                }
            }
        } else if ("Pie3D".equalsIgnoreCase(string)) {
            multiplePiePlot = new PiePlot3D();
            ((PiePlot3D)multiplePiePlot).setDataset((PieDataset)dataset);
            if (hybsURLGenerator != null) {
                ((PiePlot)multiplePiePlot).setURLGenerator((PieURLGenerator)hybsURLGenerator);
            }
            if (bl) {
                ((PiePlot)multiplePiePlot).setToolTipGenerator((PieToolTipGenerator)new StandardPieToolTipGenerator());
            }
        } else if ("Ring".equalsIgnoreCase(string)) {
            multiplePiePlot = new RingPlot();
            ((RingPlot)multiplePiePlot).setDataset((PieDataset)dataset);
            if (hybsURLGenerator != null) {
                ((PiePlot)multiplePiePlot).setURLGenerator((PieURLGenerator)hybsURLGenerator);
            }
            if (bl) {
                ((RingPlot)multiplePiePlot).setToolTipGenerator((PieToolTipGenerator)new StandardPieToolTipGenerator());
            }
        } else if ("SpiderWeb".equalsIgnoreCase(string)) {
            multiplePiePlot = new SpiderWebPlot();
            ((SpiderWebPlot)multiplePiePlot).setDataset((CategoryDataset)dataset);
            if (hybsURLGenerator != null) {
                ((SpiderWebPlot)multiplePiePlot).setURLGenerator((CategoryURLGenerator)hybsURLGenerator);
            }
            if (bl) {
                ((SpiderWebPlot)multiplePiePlot).setToolTipGenerator((CategoryToolTipGenerator)new StandardCategoryToolTipGenerator());
            }
        } else if ("Polar".equalsIgnoreCase(string)) {
            multiplePiePlot = new PolarPlot();
            ((PolarPlot)multiplePiePlot).setDataset((XYDataset)dataset);
        } else if ("Meter".equalsIgnoreCase(string)) {
            multiplePiePlot = chartDataset.makeMeterPlot();
        } else if ("Thermometer".equalsIgnoreCase(string)) {
            multiplePiePlot = chartDataset.makeThermometerPlot();
        } else if ("Compass".equalsIgnoreCase(string)) {
            multiplePiePlot = chartDataset.makeCompassPlot();
        }
        return multiplePiePlot;
    }
}

