/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.html;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opengion.fukurou.model.DataModel;
import org.opengion.fukurou.model.Formatter;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.hayabusa.html.FormatterType;

public class TableFormatter {
    public static final String HYBS_ITD_MARKER = "h_itd_marker";
    private static final Pattern ptnKey = Pattern.compile("[ \t]+</td");
    private FormatterType formatType = null;
    private int[] location = null;
    private String[] format = null;
    private String formatTag = null;
    private String rowspan = " rowspan=\"2\"";
    private String trTag = null;
    private boolean noClass = false;
    private char[] type = null;
    private String usableKey = null;
    private int usableKeyNo = -1;
    private String usableList = "1";
    private String keyBreakClm = null;
    private int breakClmNo = -1;
    private String breakVal = null;
    private String itdBody = "";
    private Formatter formatter = null;

    public void setFormat(String string, boolean bl) {
        int n = string.indexOf("<table");
        int n2 = string.indexOf("<tr");
        if (n2 >= 0 && (n < 0 || n2 < n) && bl) {
            int n3 = string.indexOf(62, n2);
            this.formatTag = string.substring(n3 + 1);
            this.trTag = string.substring(0, n3 + 1);
        } else {
            this.formatTag = string;
            this.trTag = null;
        }
        Matcher matcher = ptnKey.matcher(this.formatTag);
        this.formatTag = matcher.replaceAll("</td");
    }

    public void setFormat(String string) {
        this.setFormat(string, true);
    }

    public String getFormat() {
        if (this.trTag != null) {
            return this.decodeSanitizedStr(this.trTag + this.formatTag);
        }
        return this.decodeSanitizedStr(this.formatTag);
    }

    public void makeFormat(DBTableModel dBTableModel) {
        this.formatter = new Formatter((DataModel)dBTableModel);
        this.formatter.setFormat(this.formatTag);
        this.location = this.formatter.getClmNos();
        this.format = this.formatter.getFormat();
        if (this.format != null) {
            for (int i = 0; i < this.format.length; ++i) {
                this.format[i] = this.decodeSanitizedStr(this.format[i]);
            }
        }
        this.type = this.formatter.getType();
        if (this.usableKey != null) {
            this.usableKeyNo = dBTableModel.getColumnNo(this.usableKey);
        }
        if (this.keyBreakClm != null) {
            this.breakClmNo = dBTableModel.getColumnNo(this.keyBreakClm);
            this.breakVal = null;
        }
    }

    public void setFormatType(FormatterType formatterType) {
        this.formatType = formatterType;
    }

    public FormatterType getFormatType() {
        return this.formatType;
    }

    public void setRowspan(String string) {
        this.rowspan = string == null || string.length() == 0 || string.equals("1") ? "" : " rowspan=\"" + string + "\"";
    }

    public String getRowspan() {
        return this.rowspan;
    }

    public int getLocationSize() {
        return this.location.length;
    }

    public int getLocation(int n) {
        return this.location[n];
    }

    public String getFormat(int n) {
        return this.format[n];
    }

    public String getSystemFormat(int n, int n2) {
        if (n2 == -1) {
            return String.valueOf(n);
        }
        if (n2 == -2) {
            return this.formatter.getJson(n);
        }
        String string = "\u30b7\u30b9\u30c6\u30e0\u30d5\u30a9\u30fc\u30de\u30c3\u30c8\u306f\u3001\u4e0b\u8a18\u306e\u5f62\u5f0f\u3057\u304b\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093\u3002[" + n2 + "]" + HybsSystem.CR + "  : [KEY.\u30ab\u30e9\u30e0\u540d] : \u884c\u756a\u53f7\u4ed8\u304d\u30ab\u30e9\u30e0\u540d" + HybsSystem.CR + "  : [I]            : \u884c\u756a\u53f7" + HybsSystem.CR + "  : [ROW.ID]       : \u884c\u6bce\u306e\u30c1\u30a7\u30c3\u30af\u30dc\u30c3\u30af\u30b9\u306eID" + HybsSystem.CR + "  : [ROW.JSON]     : \u884c\u6bce\u306e\u5168\u30c7\u30fc\u30bf\u306eJavaScript\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u5f62\u5f0f";
        throw new HybsSystemException(string);
    }

    public char getType(int n) {
        return this.type[n];
    }

    public String getTrTag() {
        if (this.trTag == null) {
            return "";
        }
        return this.decodeSanitizedStr(this.trTag);
    }

    public void setNoClass(String string) {
        this.noClass = StringUtil.nval((String)string, (boolean)this.noClass);
    }

    public boolean isNoClass() {
        return this.noClass;
    }

    public void setUsableKey(String string) {
        this.usableKey = string;
    }

    public void setUsableList(String string) {
        if (string != null) {
            this.usableList = string;
        }
    }

    public void setKeyBreakClm(String string) {
        this.keyBreakClm = string;
    }

    public boolean isUse(int n, DBTableModel dBTableModel) {
        String string;
        if (this.usableKeyNo < 0 && this.breakClmNo < 0) {
            return true;
        }
        if (this.usableKeyNo >= 0 && this.usableList.indexOf(string = ((String)dBTableModel.getValue(n, this.usableKeyNo)).trim()) >= 0) {
            return true;
        }
        if (this.breakClmNo >= 0 && !(string = ((String)dBTableModel.getValue(n, this.breakClmNo)).trim()).equals(this.breakVal)) {
            this.breakVal = string;
            return true;
        }
        return false;
    }

    public void setItdBody(String string) {
        if (string != null) {
            this.itdBody = string;
        }
    }

    public String getItdBody() {
        return this.itdBody;
    }

    private String decodeSanitizedStr(String string) {
        if (string != null && string.indexOf("\\]\\") >= 0) {
            return string.replace("\\]\\", "[");
        }
        return string;
    }
}

