/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.xml;

import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.opengion.fukurou.xml.TagElement;
import org.opengion.fukurou.xml.TagElementListener;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class HybsXMLHandler
extends DefaultHandler {
    private static final String CR = System.getProperty("line.separator");
    public static final String ROWSET = "ROWSET";
    public static final String ROWSET_TABLE = "tableName";
    public static final String ROW = "ROW";
    public static final String ROW_NUM = "num";
    public static final String EXEC_SQL = "EXEC_SQL";
    public static final String MERGE_SQL = "MERGE_SQL";
    private Map<String, String> defaultMap = null;
    private TagElementListener listener = null;
    private TagElement element = null;
    private String key = null;
    private StringBuilder body = null;
    private boolean bodyIn = false;
    private int level = 0;

    public void parse(Reader reader) {
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            InputSource inputSource = new InputSource(reader);
            try {
                sAXParser.parse(inputSource, (DefaultHandler)this);
            }
            catch (SAXException sAXException) {
                if (!"END".equals(sAXException.getMessage())) {
                    String string = "XML\u30d1\u30fc\u30b9\u30a8\u30e9\u30fc key=" + this.key + CR + "element=" + this.element + CR + sAXException.getMessage();
                    if (this.body != null) {
                        string = string + CR + this.body.toString();
                    }
                    throw new RuntimeException(string, sAXException);
                }
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            String string = "SAXParser \u306e\u30b3\u30f3\u30d5\u30a3\u30b0\u30ec\u30fc\u30b7\u30e7\u30f3\u304c\u69cb\u7bc9\u3067\u304d\u307e\u305b\u3093\u3002key=" + this.key + CR + parserConfigurationException.getMessage();
            throw new RuntimeException(string, parserConfigurationException);
        }
        catch (SAXException sAXException) {
            String string = "SAXParser \u304c\u69cb\u7bc9\u3067\u304d\u307e\u305b\u3093\u3002key=" + this.key + CR + sAXException.getMessage();
            throw new RuntimeException(string, sAXException);
        }
        catch (IOException iOException) {
            String string = "InputSource \u306e\u8aad\u307f\u53d6\u308a\u6642\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002key=" + this.key + CR + iOException.getMessage();
            throw new RuntimeException(string, iOException);
        }
    }

    public void setTagElementListener(TagElementListener tagElementListener) {
        this.listener = tagElementListener;
    }

    public void setDefaultMap(Map<String, String> map) {
        this.defaultMap = map;
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (!ROW.equals(this.key) && !ROWSET.equals(this.key) && n2 > 0) {
            this.body.append(cArray, n, n2);
            this.bodyIn = true;
        }
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (ROWSET.equals(string3)) {
            if (this.listener != null) {
                this.element = new TagElement(ROWSET, this.defaultMap);
                this.element.put(ROWSET_TABLE, attributes.getValue(ROWSET_TABLE));
                this.listener.actionInit(this.element);
            }
            this.element = null;
        } else if (ROW.equals(string3)) {
            this.element = new TagElement(ROW, this.defaultMap);
            String string4 = attributes.getValue(ROW_NUM);
            this.element.setRowNo(string4);
        } else if (EXEC_SQL.equals(string3)) {
            this.element = new TagElement(EXEC_SQL);
        } else if (MERGE_SQL.equals(string3)) {
            this.element = new TagElement(MERGE_SQL);
        }
        if (this.level <= 2) {
            this.key = string3;
            this.body = new StringBuilder();
        } else {
            this.body.append('<').append(string3);
            int n = attributes.getLength();
            for (int i = 0; i < n; ++i) {
                String string5 = attributes.getQName(i);
                if (string5.startsWith("xmlns:")) continue;
                this.body.append(' ');
                this.body.append(string5).append("=\"");
                this.body.append(attributes.getValue(i)).append('\"');
            }
            this.body.append('>');
        }
        this.bodyIn = false;
        ++this.level;
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        --this.level;
        if (ROW.equals(string3)) {
            if (this.listener != null) {
                this.listener.actionRow(this.element);
            }
            this.element = null;
        } else if (EXEC_SQL.equals(string3)) {
            this.element.setBody(this.body.toString().trim());
            if (this.listener != null) {
                this.listener.actionExecSQL(this.element);
            }
            this.element = null;
        } else if (MERGE_SQL.equals(string3)) {
            this.element.setBody(this.body.toString().trim());
            if (this.listener != null) {
                this.listener.actionMergeSQL(this.element);
            }
            this.element = null;
        } else if (this.level <= 2) {
            if (this.element != null) {
                this.element.put(this.key, this.body.toString().trim());
            }
        } else if (this.bodyIn) {
            this.body.append("</").append(string3).append('>');
        } else {
            this.body.insert(this.body.length() - 1, " /");
        }
    }
}

