/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.util;

import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.opengion.fukurou.util.ExcelReaderEvent;
import org.opengion.fukurou.util.POIUtil;

public final class ExcelReader_SS {
    private static final String VERSION = "6.0.3.0 (2014/11/13)";
    private static final String CR = System.getProperty("line.separator");

    public static void excelReader(String string, ExcelReaderEvent excelReaderEvent) {
        Workbook workbook = POIUtil.createWorkbook(string);
        for (int i = 0; i < workbook.getNumberOfSheets(); ++i) {
            Sheet sheet = workbook.getSheetAt(i);
            String string2 = sheet.getSheetName();
            excelReaderEvent.startSheet(string2, i);
            int n = sheet.getFirstRowNum();
            int n2 = sheet.getLastRowNum();
            for (int j = n; j <= n2; ++j) {
                Row row = sheet.getRow(j);
                if (row == null) continue;
                int n3 = row.getFirstCellNum();
                short s = row.getLastCellNum();
                for (int k = n3; k < s; ++k) {
                    Cell cell;
                    if (excelReaderEvent.isSkip(j) || (cell = row.getCell(k)) == null || cell.getCellType() == 3) continue;
                    String string3 = POIUtil.getValue(cell);
                    excelReaderEvent.value(string3, j, k);
                }
            }
            excelReaderEvent.endSheet(i);
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.err.println("Usage: java org.opengion.fukurou.util.ExcelReader_SS \u5165\u529b\u30d5\u30a1\u30a4\u30eb\u540d");
            return;
        }
        String string = stringArray[0];
        ExcelReader_SS.excelReader(string, new ExcelReaderEvent(){

            @Override
            public boolean startSheet(String string, int n) {
                System.out.println("S[" + n + "]=" + string);
                return super.startSheet(string, n);
            }

            @Override
            public boolean value(String string, int n, int n2) {
                System.out.println("R[" + n + "],C[" + n2 + "]=" + string);
                return super.value(string, n, n2);
            }
        });
    }
}

