/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.report;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.report.AbstractRFIDPrintPointService;

public class RFIDPrintPointService_DEFAULT
extends AbstractRFIDPrintPointService {
    private static final String CR = System.getProperty("line.separator");
    private final StringBuilder strXML = new StringBuilder();
    private final String xmlEncode = HybsSystem.sys("REPORT_RFID_TEXT_ENCODE");

    @Override
    public boolean execute() {
        System.out.print("RRID RequestData Creating ... ");
        BufferedWriter bufferedWriter = null;
        String string = this.outdir;
        boolean bl = false;
        try {
            this.makeXMLheader();
            this.makeXMLprintHeader();
            this.makeXMLprintCards();
            this.makeXMLfooter();
            bufferedWriter = this.getWriter(string, false, this.xmlEncode);
            bufferedWriter.write(this.strXML.toString());
            bufferedWriter.flush();
            bufferedWriter.close();
            this.makeShellCommand();
            bl = this.programRun();
        }
        catch (Throwable throwable) {
            this.errMsg.append("RFID Print Request Execution Error. ").append(CR);
            this.errMsg.append("==============================").append(CR);
            this.errMsg.append("SYSTEM_ID=[").append(this.systemId).append("] , ");
            this.errMsg.append("YKNO=[").append(this.ykno).append("] , ");
            this.errMsg.append(throwable.toString());
            this.errMsg.append(CR);
            throw new RuntimeException(this.errMsg.toString(), throwable);
        }
        return bl;
    }

    private void makeXMLheader() {
        this.strXML.append("<?xml version=\"1.0\" encoding=\"").append(this.xmlEncode).append("\" ?>").append(CR);
        this.strXML.append("<RfidEvent>").append(CR);
        this.strXML.append("<Type>210</Type>").append(CR);
        this.strXML.append("<SubType>1</SubType>").append(CR);
        this.strXML.append("<Id>").append(this.listid).append("</Id>").append(CR);
        this.strXML.append("<LayoutFilename>").append(this.layoutFile).append("</LayoutFilename>").append(CR);
        this.strXML.append("<SiteName>").append(this.hostName).append("</SiteName>").append(CR);
        this.strXML.append("<DeviceName>").append(this.prtid).append("</DeviceName>").append(CR);
        this.strXML.append("<Data>").append(CR);
    }

    private void makeXMLprintHeader() {
        this.strXML.append("<PrintHeader systemId=\"").append(this.systemId).append("\" demandNo=\"").append(this.ykno).append("\">").append(CR);
        for (int i = 0; i < this.table.getColumnCount(); ++i) {
            String string = this.table.getColumnName(i);
            String[] stringArray = (String[])this.rfidLayout.get(string);
            if (stringArray == null) continue;
            this.strXML.append("<Col name=\"").append(string).append('\"').append(CR);
            this.strXML.append(" kbout=\"").append(stringArray[0]).append('\"').append(CR);
            this.strXML.append(" data1=\"").append(stringArray[1]).append('\"').append(CR);
            this.strXML.append(" data2=\"").append(stringArray[2]).append('\"').append(CR);
            this.strXML.append(" data3=\"").append(stringArray[3]).append('\"').append(CR);
            this.strXML.append(" data4=\"").append(stringArray[4]).append('\"').append(CR);
            this.strXML.append(" data5=\"").append(stringArray[5]).append('\"').append(CR);
            this.strXML.append(" data6=\"").append(stringArray[6]).append('\"').append(CR);
            this.strXML.append(" data7=\"").append(stringArray[7]).append('\"').append(CR);
            this.strXML.append(" data8=\"").append(stringArray[8]).append('\"').append(CR);
            this.strXML.append(" data9=\"").append(stringArray[9]).append('\"').append(CR);
            this.strXML.append(" data10=\"").append(stringArray[10]).append('\"').append(CR);
            this.strXML.append(" data11=\"").append(stringArray[11]).append('\"').append(CR);
            this.strXML.append(" data12=\"").append(stringArray[12]).append('\"').append(CR);
            this.strXML.append(" data13=\"").append(stringArray[13]).append('\"').append(CR);
            this.strXML.append(" data14=\"").append(stringArray[14]).append('\"').append(CR);
            this.strXML.append(" data15=\"").append(stringArray[15]).append('\"');
            this.strXML.append(" />").append(CR);
        }
        this.strXML.append("</PrintHeader>").append(CR);
    }

    private void makeXMLprintCards() {
        this.strXML.append("<PrintCards>").append(CR);
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            this.strXML.append("<PrintCard control=\"").append(this.fgrun).append("\" edno=\"").append(Integer.toString(i + 1)).append("\">").append(CR);
            for (int j = 0; j < this.table.getColumnCount(); ++j) {
                this.strXML.append("<ColData name=\"").append(this.table.getColumnName(j)).append("\">");
                this.strXML.append((String)this.table.getValue(i, j));
                this.strXML.append("</ColData>").append(CR);
            }
            this.strXML.append("</PrintCard>").append(CR);
        }
        this.strXML.append("</PrintCards>").append(CR);
    }

    private void makeXMLfooter() {
        this.strXML.append("</Data>").append(CR);
        this.strXML.append("<Time>systemstamp</Time>").append(CR);
        this.strXML.append("<SourceName>null</SourceName>").append(CR);
        this.strXML.append("<CorrelationId>null</CorrelationId>").append(CR);
        this.strXML.append("</RfidEvent>").append(CR);
    }

    private BufferedWriter getWriter(String string, boolean bl, String string2) {
        BufferedWriter bufferedWriter;
        File file = new File(string);
        try {
            bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file, bl), string2));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.errMsg.append("[ERROR] Input File is written by Unsupported Encoding");
            throw new HybsSystemException(unsupportedEncodingException);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.errMsg.append("[ERROR] File not Found");
            throw new HybsSystemException(fileNotFoundException);
        }
        return bufferedWriter;
    }

    private boolean makeShellCommand() {
        StringBuilder stringBuilder = new StringBuilder(50);
        stringBuilder.append(this.prgdir + HybsSystem.FS + this.prgfile).append(' ');
        stringBuilder.append('\"').append(this.ykno).append("\" ");
        stringBuilder.append('\"').append(this.prtid).append("\" ");
        stringBuilder.append('\"').append(this.prtName).append("\" ");
        stringBuilder.append('\"').append(this.hostName).append("\" ");
        stringBuilder.append('\"').append(this.portnm).append("\" ");
        this.shellCmd = stringBuilder.toString();
        System.out.println(CR + this.shellCmd + CR);
        return true;
    }
}

