/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.db;

import org.opengion.fukurou.util.Attributes;
import org.opengion.fukurou.util.TagBuffer;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.db.CellEditor;
import org.opengion.hayabusa.db.DBColumn;

public abstract class AbstractEditor
implements CellEditor {
    private final int COLUMNS_MAXSIZE = HybsSystem.sysInt("HTML_COLUMNS_MAXSIZE");
    private final int VIEW_COLUMNS_MAXSIZE = HybsSystem.sysInt("HTML_VIEW_COLUMNS_MAXSIZE");
    protected Attributes attributes;
    protected String name;
    protected String size1;
    protected String size2;
    protected TagBuffer tagBuffer = new TagBuffer();

    public AbstractEditor() {
    }

    protected AbstractEditor(DBColumn dBColumn) {
        this.name = dBColumn.getName();
        String string = dBColumn.isWritable() ? null : "disabled";
        int n = dBColumn.getTotalSize();
        this.attributes = new Attributes();
        this.attributes.set("type", "text");
        this.attributes.set("maxlength", String.valueOf(n));
        this.attributes.set("disabled", string);
        this.attributes.addAttributes(dBColumn.getEditorAttributes());
        String string2 = dBColumn.getDbType();
        this.attributes.add("class", string2);
        if (n <= 5) {
            this.attributes.add("class", "S0" + n);
        }
        String string3 = this.attributes.get("optionAttributes");
        this.tagBuffer.add(string3);
        String string4 = dBColumn.getViewLength();
        if (string4 != null) {
            if (string4.indexOf(44) >= 0) {
                string4 = string4.substring(0, string4.indexOf(44));
            }
            this.size1 = string4;
            this.size2 = string4;
        } else {
            this.size1 = String.valueOf(dBColumn.getFieldSize(n, this.COLUMNS_MAXSIZE));
            this.size2 = String.valueOf(dBColumn.getFieldSize(n, this.VIEW_COLUMNS_MAXSIZE));
        }
    }

    @Override
    public String getValue(String string) {
        TagBuffer tagBuffer = new TagBuffer("input");
        tagBuffer.add("name", this.name);
        if (this.attributes.get("id") == null || this.attributes.get("id").length() == 0) {
            tagBuffer.add("id", this.name);
        }
        tagBuffer.add("value", string);
        tagBuffer.add("size", this.size1);
        tagBuffer.add(this.tagBuffer.makeTag());
        return tagBuffer.makeTag();
    }

    @Override
    public String getValue(int n, String string) {
        TagBuffer tagBuffer = new TagBuffer("input");
        String string2 = this.name + "__" + n;
        tagBuffer.add("name", string2);
        if (this.attributes.get("id") == null || this.attributes.get("id").length() == 0) {
            tagBuffer.add("id", string2);
        }
        tagBuffer.add("value", string);
        tagBuffer.add("size", this.size2);
        tagBuffer.add(this.tagBuffer.makeTag());
        return tagBuffer.makeTag(n, string);
    }
}

