/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.plugin.io;

import java.io.PrintWriter;
import org.odftoolkit.odfdom.OdfFileDom;
import org.odftoolkit.odfdom.doc.OdfSpreadsheetDocument;
import org.odftoolkit.odfdom.doc.office.OdfOfficeAutomaticStyles;
import org.odftoolkit.odfdom.doc.office.OdfOfficeSpreadsheet;
import org.odftoolkit.odfdom.doc.table.OdfTable;
import org.odftoolkit.odfdom.doc.table.OdfTableCell;
import org.odftoolkit.odfdom.doc.table.OdfTableRow;
import org.odftoolkit.odfdom.doc.text.OdfTextParagraph;
import org.odftoolkit.odfdom.dom.attribute.office.OfficeValueTypeAttribute;
import org.opengion.fukurou.model.NativeType;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.plugin.io.TableWriter_Default;
import org.w3c.dom.Node;

public class TableWriter_Calc
extends TableWriter_Default {
    private static final String VERSION = "6.0.4.0 (2014/11/28)";
    protected OdfSpreadsheetDocument wb = null;
    protected OdfTable sheet = null;
    protected OdfFileDom contentDom = null;
    protected OdfOfficeSpreadsheet officeSpreadsheet = null;
    protected OdfOfficeAutomaticStyles contentAutoStyles = null;
    protected boolean useNumber = true;
    private String sheetName = "Sheet1";
    private String filename = null;

    @Override
    public void writeDBTable() {
        if (!this.createDBColumn()) {
            return;
        }
        this.useNumber = this.isUseNumber();
        if (this.filename == null) {
            String string = "\u30d5\u30a1\u30a4\u30eb\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002";
            throw new HybsSystemException(string);
        }
        if (this.isAppend()) {
            String string = "Calc\u306e\u5834\u5408\u306fAppend\u5229\u7528\u3067\u304d\u307e\u305b\u3093\u3002";
            throw new HybsSystemException(string);
        }
        try {
            this.wb = OdfSpreadsheetDocument.newSpreadsheetDocument();
            this.contentDom = this.wb.getContentDom();
            this.officeSpreadsheet = this.wb.getContentRoot();
            this.contentAutoStyles = this.contentDom.getOrCreateAutomaticStyles();
            Node node = this.officeSpreadsheet.getFirstChild();
            while (node != null) {
                this.officeSpreadsheet.removeChild(node);
                node = this.officeSpreadsheet.getFirstChild();
            }
        }
        catch (Exception exception) {
            String string = "Calc\u306e\u6587\u66f8\u5ba3\u8a00\u304c\u3067\u304d\u307e\u305b\u3093\u3002";
            throw new HybsSystemException(string, (Throwable)exception);
        }
        this.resetAutoStylesAndMasterStyles();
        this.sheet = new OdfTable(this.contentDom);
        this.sheet.setTableNameAttribute(this.sheetName);
        super.writeDBTable(null);
        this.officeSpreadsheet.appendChild((Node)this.sheet);
        try {
            this.wb.save(this.filename);
            this.wb.close();
        }
        catch (Exception exception) {
            String string = "Calc\u306e\u6587\u66f8save\u304c\u3067\u304d\u307e\u305b\u3093\u3002";
            throw new HybsSystemException(string, (Throwable)exception);
        }
        finally {
            if (null != this.sheet) {
                this.sheet = null;
            }
            if (null != this.wb) {
                this.wb = null;
            }
        }
    }

    protected void writeLabel(DBTableModel dBTableModel, PrintWriter printWriter) {
        OdfTableRow odfTableRow = new OdfTableRow(this.contentDom);
        if (this.useNumber) {
            odfTableRow.appendCell((Node)this.createTextCell(this.contentDom, "#Label", false, false));
        }
        for (int i = 0; i < this.numberOfColumns; ++i) {
            int n = this.clmNo[i];
            if (n < 0) {
                odfTableRow.appendCell((Node)this.createTextCell(this.contentDom, "", false, false));
                continue;
            }
            String string = this.dbColumn[n].getLabel();
            if (i == 0 && !this.useNumber) {
                string = "#" + string;
            }
            odfTableRow.appendCell((Node)this.createTextCell(this.contentDom, string, false, false));
        }
        odfTableRow.setStyleName("ro1");
        this.sheet.appendRow((Node)odfTableRow);
    }

    protected void writeName(DBTableModel dBTableModel, PrintWriter printWriter) {
        OdfTableRow odfTableRow = new OdfTableRow(this.contentDom);
        if (this.useNumber) {
            odfTableRow.appendCell((Node)this.createTextCell(this.contentDom, "#Name", false, false));
        }
        for (int i = 0; i < this.numberOfColumns; ++i) {
            int n = this.clmNo[i];
            if (n < 0) {
                odfTableRow.appendCell((Node)this.createTextCell(this.contentDom, "", false, false));
                continue;
            }
            String string = dBTableModel.getColumnName(n);
            if (i == 0 && !this.useNumber) {
                string = "#" + string;
            }
            odfTableRow.appendCell((Node)this.createTextCell(this.contentDom, string, false, false));
        }
        odfTableRow.setStyleName("ro1");
        this.sheet.appendRow((Node)odfTableRow);
    }

    protected void writeSize(DBTableModel dBTableModel, PrintWriter printWriter) {
        OdfTableRow odfTableRow = new OdfTableRow(this.contentDom);
        if (this.useNumber) {
            odfTableRow.appendCell((Node)this.createTextCell(this.contentDom, "#Size", false, false));
        }
        for (int i = 0; i < this.numberOfColumns; ++i) {
            int n = this.clmNo[i];
            if (n < 0) {
                odfTableRow.appendCell((Node)this.createTextCell(this.contentDom, "", false, false));
                continue;
            }
            String string = String.valueOf(this.dbColumn[n].getTotalSize());
            if (i == 0 && !this.useNumber) {
                string = "#" + string;
            }
            odfTableRow.appendCell((Node)this.createTextCell(this.contentDom, string, true, false));
        }
        odfTableRow.setStyleName("ro1");
        this.sheet.appendRow((Node)odfTableRow);
    }

    protected void writeClass(DBTableModel dBTableModel, PrintWriter printWriter) {
        OdfTableRow odfTableRow = new OdfTableRow(this.contentDom);
        if (this.useNumber) {
            odfTableRow.appendCell((Node)this.createTextCell(this.contentDom, "#Class", false, false));
        }
        for (int i = 0; i < this.numberOfColumns; ++i) {
            int n = this.clmNo[i];
            if (n < 0) {
                odfTableRow.appendCell((Node)this.createTextCell(this.contentDom, "", false, false));
                continue;
            }
            String string = this.dbColumn[n].getClassName();
            if (i == 0 && !this.useNumber) {
                string = "#" + string;
            }
            odfTableRow.appendCell((Node)this.createTextCell(this.contentDom, string, false, false));
        }
        odfTableRow.setStyleName("ro1");
        this.sheet.appendRow((Node)odfTableRow);
    }

    protected void writeSeparator(DBTableModel dBTableModel, PrintWriter printWriter) {
        String string = "----";
        OdfTableRow odfTableRow = new OdfTableRow(this.contentDom);
        odfTableRow.appendCell((Node)this.createTextCell(this.contentDom, "#----", false, false));
        for (int i = 0; i < this.numberOfColumns; ++i) {
            if (i == 0 && !this.useNumber) continue;
            odfTableRow.appendCell((Node)this.createTextCell(this.contentDom, string, false, false));
        }
        this.sheet.appendRow((Node)odfTableRow);
    }

    @Override
    protected void writeData(DBTableModel dBTableModel, PrintWriter printWriter) {
        NativeType nativeType;
        int n;
        int n2;
        int n3 = dBTableModel.getRowCount();
        boolean[] blArray = new boolean[this.numberOfColumns];
        boolean[] blArray2 = new boolean[this.numberOfColumns];
        for (n2 = 0; n2 < this.numberOfColumns; ++n2) {
            n = this.clmNo[n2];
            if (n < 0) continue;
            nativeType = this.dbColumn[n].getNativeType();
            switch (nativeType) {
                case INT: 
                case LONG: 
                case DOUBLE: {
                    blArray2[n2] = true;
                    break;
                }
                default: {
                    blArray2[n2] = false;
                }
            }
            blArray[n2] = "NVAR".equals(this.dbColumn[n].getDbType());
        }
        n2 = this.isUseRenderer() ? 1 : 0;
        for (n = 0; n < n3; ++n) {
            nativeType = new OdfTableRow(this.contentDom);
            if (this.useNumber) {
                nativeType.appendCell((Node)this.createTextCell(this.contentDom, String.valueOf(n + 1), true, true));
            }
            for (int i = 0; i < this.numberOfColumns; ++i) {
                int n4 = this.clmNo[i];
                if (n4 < 0) {
                    nativeType.appendCell((Node)this.createTextCell(this.contentDom, "", false, false));
                    continue;
                }
                String string = (String)dBTableModel.getValue(n, n4);
                if (blArray[i]) {
                    string = StringUtil.getReplaceEscape((String)string);
                } else if (n2 != 0) {
                    string = this.dbColumn[n4].getWriteValue(string);
                }
                nativeType.appendCell((Node)this.createTextCell(this.contentDom, string, blArray2[i], false));
            }
            nativeType.setStyleName("ro1");
            this.sheet.appendRow((Node)nativeType);
        }
    }

    protected OdfTableCell createTextCell(OdfFileDom odfFileDom, String string, Boolean bl, Boolean bl2) {
        OdfTableCell odfTableCell = new OdfTableCell(odfFileDom);
        if (bl.booleanValue()) {
            odfTableCell.setOfficeValueAttribute(Double.valueOf(Double.parseDouble(string)));
            odfTableCell.setOfficeValueTypeAttribute(OfficeValueTypeAttribute.Value.FLOAT.toString());
        } else {
            odfTableCell.setOfficeValueTypeAttribute(OfficeValueTypeAttribute.Value.STRING.toString());
        }
        OdfTextParagraph odfTextParagraph = new OdfTextParagraph(odfFileDom, null, string);
        odfTableCell.appendChild((Node)odfTextParagraph);
        return odfTableCell;
    }

    protected void resetAutoStylesAndMasterStyles() {
    }

    public boolean isExcel() {
        return true;
    }

    public void setFilename(String string, String string2) {
        this.filename = StringUtil.urlAppend((String)string, (String)string2, (String[])new String[0]);
    }

    public void setSheetName(String string) {
        if (string != null) {
            this.sheetName = string;
        }
    }
}

